/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u001cB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00150\u0014J\u0015\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001bR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/util/TimeExpiringCache;", "IndexType", "DataType", "", "dataTimeout", "Ljava/time/Duration;", "maxNumElements", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;ILjava/time/Clock;)V", "cache", "Ljava/util/TreeMap;", "Lorg/jitsi/nlj/util/TimeExpiringCache$Container;", "clean", "", "expirationTimestamp", "", "forEachDescending", "predicate", "Lkotlin/Function1;", "", "get", "index", "(Ljava/lang/Object;)Ljava/lang/Object;", "insert", "data", "(Ljava/lang/Object;Ljava/lang/Object;)V", "Container", "jitsi-media-transform"})
public final class TimeExpiringCache<IndexType, DataType> {
    @NotNull
    private final Duration dataTimeout;
    private final int maxNumElements;
    @NotNull
    private final Clock clock;
    @NotNull
    private final TreeMap<IndexType, Container<DataType>> cache;

    public TimeExpiringCache(@NotNull Duration dataTimeout, int maxNumElements, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(dataTimeout, "dataTimeout");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.dataTimeout = dataTimeout;
        this.maxNumElements = maxNumElements;
        this.clock = clock;
        this.cache = new TreeMap();
    }

    public /* synthetic */ TimeExpiringCache(Duration duration, int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(duration, n, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(IndexType index, DataType data2) {
        Container<DataType> container = new Container<DataType>(data2, this.clock.millis());
        TreeMap<IndexType, Container<DataType>> treeMap = this.cache;
        synchronized (treeMap) {
            boolean bl = false;
            ((Map)this.cache).put(index, container);
            this.clean(this.clock.millis() - this.dataTimeout.toMillis());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DataType get(IndexType index) {
        TreeMap<IndexType, Container<DataType>> treeMap = this.cache;
        synchronized (treeMap) {
            Container container;
            block4: {
                boolean bl = false;
                if ((Container)((Map)this.cache).getOrDefault(index, null) != null) break block4;
                DataType DataType = null;
                return DataType;
            }
            Container container2 = container;
            Object Type2 = container2.getData();
            return (DataType)Type2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachDescending(@NotNull Function1<? super DataType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        TreeMap<IndexType, Container<DataType>> treeMap = this.cache;
        synchronized (treeMap) {
            boolean bl = false;
            NavigableMap<IndexType, Container<DataType>> navigableMap = this.cache.descendingMap();
            Intrinsics.checkNotNullExpressionValue(navigableMap, "cache.descendingMap()");
            Iterator iter = ((Map)navigableMap).entrySet().iterator();
            while (iter.hasNext()) {
                Container container = (Container)iter.next().getValue();
                if (predicate.invoke(container.getData()).booleanValue()) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clean(long expirationTimestamp) {
        TreeMap<IndexType, Container<DataType>> treeMap = this.cache;
        synchronized (treeMap) {
            boolean bl = false;
            Iterator<Map.Entry<IndexType, Container<DataType>>> iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<IndexType, Container<DataType>> entry = iter.next();
                Intrinsics.checkNotNullExpressionValue(entry, "next()");
                Container<DataType> container = entry.getValue();
                if (this.cache.size() > this.maxNumElements) {
                    iter.remove();
                    continue;
                }
                if (container.getTimeAdded() > expirationTimestamp) break;
                iter.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001c\u0010\u0003\u001a\u00028\u0002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/util/TimeExpiringCache$Container;", "Type", "", "data", "timeAdded", "", "(Ljava/lang/Object;J)V", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getTimeAdded", "()J", "setTimeAdded", "(J)V", "component1", "component2", "copy", "(Ljava/lang/Object;J)Lorg/jitsi/nlj/util/TimeExpiringCache$Container;", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    private static final class Container<Type> {
        private Type data;
        private long timeAdded;

        public Container(Type data2, long timeAdded) {
            this.data = data2;
            this.timeAdded = timeAdded;
        }

        public final Type getData() {
            return this.data;
        }

        public final void setData(Type Type2) {
            this.data = Type2;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        public final void setTimeAdded(long l) {
            this.timeAdded = l;
        }

        public final Type component1() {
            return this.data;
        }

        public final long component2() {
            return this.timeAdded;
        }

        @NotNull
        public final Container<Type> copy(Type data2, long timeAdded) {
            return new Container<Type>(data2, timeAdded);
        }

        public static /* synthetic */ Container copy$default(Container container, Object object, long l, int n, Object object2) {
            if ((n & 1) != 0) {
                object = container.data;
            }
            if ((n & 2) != 0) {
                l = container.timeAdded;
            }
            return container.copy(object, l);
        }

        @NotNull
        public String toString() {
            return "Container(data=" + this.data + ", timeAdded=" + this.timeAdded + ")";
        }

        public int hashCode() {
            int result2 = this.data == null ? 0 : this.data.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timeAdded);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Container)) {
                return false;
            }
            Container container = (Container)other;
            if (!Intrinsics.areEqual(this.data, container.data)) {
                return false;
            }
            return this.timeAdded == container.timeAdded;
        }
    }
}

