/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.srtp.AbstractSrtpTransformer;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.MultipleOutputTransformerNode;
import org.jitsi.srtp.SrtpErrorStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010\"\u001a\u00020\u0007H\u0014J(\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070!2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lorg/jitsi/nlj/transform/node/SrtpTransformerNode;", "Lorg/jitsi/nlj/transform/node/MultipleOutputTransformerNode;", "name", "", "(Ljava/lang/String;)V", "cachedPackets", "", "Lorg/jitsi/nlj/PacketInfo;", "firstPacketForwardedTimestamp", "", "firstPacketReceivedTimestamp", "numCachedPackets", "", "numSrtpAuthFail", "numSrtpFail", "numSrtpInvalidPacket", "numSrtpProcessed", "numSrtpReplayFail", "numSrtpReplayOld", "transformer", "Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "getTransformer", "()Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "setTransformer", "(Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;)V", "countErrorStatus", "", "err", "Lorg/jitsi/srtp/SrtpErrorStatus;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "stop", "transform", "", "packetInfo", "transformList", "packetInfos", "jitsi-media-transform"})
public abstract class SrtpTransformerNode
extends MultipleOutputTransformerNode {
    @Nullable
    private AbstractSrtpTransformer<?> transformer;
    @NotNull
    private List<PacketInfo> cachedPackets;
    private long firstPacketReceivedTimestamp;
    private long firstPacketForwardedTimestamp;
    private int numCachedPackets;
    private int numSrtpProcessed;
    private int numSrtpFail;
    private int numSrtpAuthFail;
    private int numSrtpReplayFail;
    private int numSrtpReplayOld;
    private int numSrtpInvalidPacket;

    public SrtpTransformerNode(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name);
        this.cachedPackets = new ArrayList();
        this.firstPacketReceivedTimestamp = -1L;
        this.firstPacketForwardedTimestamp = -1L;
    }

    @Nullable
    public final AbstractSrtpTransformer<?> getTransformer() {
        return this.transformer;
    }

    public final void setTransformer(@Nullable AbstractSrtpTransformer<?> abstractSrtpTransformer) {
        this.transformer = abstractSrtpTransformer;
    }

    private final List<PacketInfo> transformList(List<? extends PacketInfo> packetInfos, AbstractSrtpTransformer<?> transformer) {
        List transformedPackets = new ArrayList();
        Iterable $this$forEach$iv = packetInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketInfo packetInfo = (PacketInfo)element$iv;
            boolean bl = false;
            SrtpErrorStatus err = transformer.transform(packetInfo);
            if (err == SrtpErrorStatus.OK) {
                transformedPackets.add(packetInfo);
            } else {
                this.packetDiscarded(packetInfo);
            }
            this.countErrorStatus(err);
        }
        return transformedPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected List<PacketInfo> transform(@NotNull PacketInfo packetInfo) {
        AbstractSrtpTransformer<?> abstractSrtpTransformer;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (this.firstPacketReceivedTimestamp == -1L) {
            this.firstPacketReceivedTimestamp = System.currentTimeMillis();
        }
        if ((abstractSrtpTransformer = this.transformer) != null) {
            AbstractSrtpTransformer<?> transformer = abstractSrtpTransformer;
            boolean bl = false;
            if (this.firstPacketForwardedTimestamp == -1L) {
                this.firstPacketForwardedTimestamp = System.currentTimeMillis();
            }
            List<PacketInfo> outPackets = null;
            List<PacketInfo> list = this.cachedPackets;
            synchronized (list) {
                boolean $i$a$-synchronized-SrtpTransformerNode$transform$1$22 = false;
                if (!((Collection)this.cachedPackets).isEmpty()) {
                    this.cachedPackets.add(packetInfo);
                    outPackets = this.transformList(this.cachedPackets, transformer);
                    this.cachedPackets.clear();
                } else {
                    List<PacketInfo> list2;
                    SrtpErrorStatus err = transformer.transform(packetInfo);
                    this.countErrorStatus(err);
                    if (err == SrtpErrorStatus.OK) {
                        list2 = CollectionsKt.listOf(packetInfo);
                    } else {
                        this.packetDiscarded(packetInfo);
                        list2 = CollectionsKt.emptyList();
                    }
                    outPackets = list2;
                }
                Unit $i$a$-synchronized-SrtpTransformerNode$transform$1$22 = Unit.INSTANCE;
            }
            return outPackets;
        }
        SrtpTransformerNode $this$transform_u24lambda_u2d4 = this;
        boolean bl = false;
        int n = $this$transform_u24lambda_u2d4.numCachedPackets;
        $this$transform_u24lambda_u2d4.numCachedPackets = n + 1;
        List<PacketInfo> list = $this$transform_u24lambda_u2d4.cachedPackets;
        synchronized (list) {
            boolean bl2 = false;
            $this$transform_u24lambda_u2d4.cachedPackets.add(packetInfo);
            while ($this$transform_u24lambda_u2d4.cachedPackets.size() > 1024) {
                $this$transform_u24lambda_u2d4.packetDiscarded($this$transform_u24lambda_u2d4.cachedPackets.remove(0));
            }
            Unit unit = Unit.INSTANCE;
        }
        return CollectionsKt.emptyList();
    }

    private final void countErrorStatus(SrtpErrorStatus err) {
        switch (WhenMappings.$EnumSwitchMapping$0[err.ordinal()]) {
            case 1: {
                int n = this.numSrtpProcessed;
                this.numSrtpProcessed = n + 1;
                break;
            }
            case 2: {
                int n = this.numSrtpFail;
                this.numSrtpFail = n + 1;
                break;
            }
            case 3: {
                int n = this.numSrtpAuthFail;
                this.numSrtpAuthFail = n + 1;
                break;
            }
            case 4: {
                int n = this.numSrtpReplayFail;
                this.numSrtpReplayFail = n + 1;
                break;
            }
            case 5: {
                int n = this.numSrtpReplayOld;
                this.numSrtpReplayOld = n + 1;
                break;
            }
            case 6: {
                int n = this.numSrtpInvalidPacket;
                this.numSrtpInvalidPacket = n + 1;
            }
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d5 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_cached_packets", this.numCachedPackets);
        if (this.firstPacketReceivedTimestamp != -1L && this.firstPacketForwardedTimestamp != -1L) {
            long timeBetweenReceivedAndForwarded = this.firstPacketForwardedTimestamp - this.firstPacketReceivedTimestamp;
            $this$getNodeStats_u24lambda_u2d5.addNumber("time_initial_hold_ms", timeBetweenReceivedAndForwarded);
        } else {
            $this$getNodeStats_u24lambda_u2d5.addString("state", "hold_for_transformer");
        }
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_processed", this.numSrtpProcessed);
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_fail", this.numSrtpFail);
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_auth_fail", this.numSrtpAuthFail);
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_replay_fail", this.numSrtpReplayFail);
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_replay_old", this.numSrtpReplayOld);
        $this$getNodeStats_u24lambda_u2d5.addNumber("num_srtp_invalid_packet", this.numSrtpInvalidPacket);
        return nodeStatsBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        List<PacketInfo> list = this.cachedPackets;
        synchronized (list) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.cachedPackets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PacketInfo it = (PacketInfo)element$iv;
                boolean bl2 = false;
                this.packetDiscarded(it);
            }
            this.cachedPackets.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SrtpErrorStatus.values().length];
            nArray[SrtpErrorStatus.OK.ordinal()] = 1;
            nArray[SrtpErrorStatus.FAIL.ordinal()] = 2;
            nArray[SrtpErrorStatus.AUTH_FAIL.ordinal()] = 3;
            nArray[SrtpErrorStatus.REPLAY_FAIL.ordinal()] = 4;
            nArray[SrtpErrorStatus.REPLAY_OLD.ordinal()] = 5;
            nArray[SrtpErrorStatus.INVALID_PACKET.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

