/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.plugin.ProvisioningPlugin;

public abstract class ProvisioningPluginWithOptions
implements ProvisioningPlugin {
    private Map<String, ProvisioningOption> pluginOptions;

    @Override
    public Map<String, ProvisioningOption> getOptions() {
        if (this.pluginOptions == null) {
            List<ProvisioningOption> options = this.initPluginOptions();
            if (options.isEmpty()) {
                this.pluginOptions = Collections.emptyMap();
            } else if (options.size() == 1) {
                ProvisioningOption option = options.get(0);
                this.pluginOptions = Collections.singletonMap(option.getName(), option);
            } else {
                this.pluginOptions = new HashMap<String, ProvisioningOption>(options.size());
                for (int i = 0; i < options.size(); ++i) {
                    ProvisioningOption option = options.get(i);
                    this.pluginOptions.put(option.getName(), option);
                }
            }
        }
        return this.pluginOptions;
    }

    protected abstract List<ProvisioningOption> initPluginOptions();
}

