/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.install.internal;

import java.io.File;
import java.util.Collection;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.artifact.install.internal.Invoker;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.util.artifact.SubArtifact;

@Component(role=ArtifactInstaller.class, hint="maven31")
public class Maven31ArtifactInstaller
implements ArtifactInstaller {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private RepositoryManager repositoryManager;

    @Override
    public void install(ProjectBuildingRequest buildingRequest, Collection<org.apache.maven.artifact.Artifact> mavenArtifacts) throws ArtifactInstallerException {
        this.install(buildingRequest, null, mavenArtifacts);
    }

    @Override
    public void install(ProjectBuildingRequest buildingRequest, File localRepository, Collection<org.apache.maven.artifact.Artifact> mavenArtifacts) throws ArtifactInstallerException {
        InstallRequest request = new InstallRequest();
        for (org.apache.maven.artifact.Artifact mavenArtifact : mavenArtifacts) {
            Artifact mainArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
            request.addArtifact(mainArtifact);
            for (ArtifactMetadata metadata : mavenArtifact.getMetadataList()) {
                if (metadata instanceof ProjectArtifactMetadata) {
                    Artifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                    pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                    request.addArtifact(pomArtifact);
                    continue;
                }
                if (!(metadata instanceof ArtifactRepositoryMetadata)) continue;
            }
        }
        if (localRepository != null) {
            buildingRequest = this.repositoryManager.setLocalRepositoryBasedir(buildingRequest, localRepository);
        }
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        try {
            this.repositorySystem.install(session, request);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallerException(e.getMessage(), e);
        }
    }
}

