/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.highlight;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.CodeParser;
import com.almworks.tracklink.codelinks.highlight.StyleConstants;
import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SideBorder2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorInputHandler
extends KeyAdapter
implements EditorMouseMotionListener {
    private static final Key<Class> DYNAMIC_HIGHLIGHTER_KEY = Key.create((String)"DynamicLinkHighlighter");
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final CodeParser myParser;
    private final ArtifactInfoCache myCache;
    @Nullable
    private URLTextRange myLastLinkRange = null;
    private boolean myLastCtrlPressed = false;
    private boolean myLastAltPressed = false;
    private boolean myHandCursor = false;
    @Nullable
    private Point myLastLocation = null;
    @Nullable
    private LightweightHint myNavigateHint = null;
    @Nullable
    private LightweightHint myInfoHint = null;
    private static final CompoundBorder HINT_BORDER = new CompoundBorder((Border)new SideBorder2(Color.WHITE, Color.WHITE, Color.GRAY, Color.GRAY, 1), new EmptyBorder(2, 2, 2, 2));
    private static final Color HINT_BACKGROUND = new Color(253, 254, 226);

    public EditorInputHandler(Editor editor, PsiFile psiFile, CodeParser parser, ArtifactInfoCache cache) {
        this.myEditor = editor;
        this.myPsiFile = psiFile;
        this.myParser = parser;
        this.myCache = cache;
    }

    public void mouseMoved(EditorMouseEvent e) {
        this.myLastLocation = e.getMouseEvent().getPoint();
        this.updateHighlightAndCursor();
    }

    public void mouseDragged(EditorMouseEvent e) {
        this.myLastLocation = null;
        this.updateHighlightAndCursor();
    }

    public void keyPressed(KeyEvent e) {
        if (Utils.isControlOrMetaPressed(e) && !this.myLastCtrlPressed) {
            this.myLastAltPressed = true;
            this.updateHighlightAndCursor();
        }
        if (Utils.isAltPressed(e) && !this.myLastAltPressed) {
            this.myLastAltPressed = true;
            this.updateHighlightAndCursor();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (!Utils.isControlOrMetaPressed(e) && this.myLastCtrlPressed) {
            this.myLastCtrlPressed = false;
            this.updateHighlightAndCursor();
        }
        if (!Utils.isAltPressed(e) && this.myLastAltPressed) {
            this.myLastAltPressed = false;
            this.updateHighlightAndCursor();
        }
    }

    private void updateHighlightAndCursor() {
        this.updateHightlight();
        if (this.myNavigateHint != null) {
            this.setEditorCursor(12);
            this.myHandCursor = true;
        } else if (this.myHandCursor) {
            this.setEditorCursor(2);
            this.myHandCursor = false;
        }
    }

    private void updateHightlight() {
        URLTextRange hoveredRange;
        Point point = this.myLastLocation;
        URLTextRange uRLTextRange = hoveredRange = point != null ? this.myParser.getURLTextRange(this.myEditor, this.myPsiFile, point) : null;
        if (hoveredRange == null || !hoveredRange.isActive()) {
            if (this.myLastLinkRange != null) {
                this.clearNavigationHighlight();
                this.hideInfoHint();
                this.hideOpenHint();
                this.myLastLinkRange = null;
            }
            return;
        }
        boolean sameRange = Utils.equals(this.myLastLinkRange, hoveredRange);
        this.myLastLinkRange = hoveredRange;
        if (!this.myLastCtrlPressed && !this.myLastAltPressed) {
            this.hideOpenHint();
            this.clearNavigationHighlight();
            if (!sameRange || this.myInfoHint == null) {
                ArtifactInfo info = this.getInfo(hoveredRange);
                this.hideInfoHint();
                ArtifactInfoStatus status = info.getStatus();
                String hintText = status == ArtifactInfoStatus.OK ? "<html><body>" + (String)info.getPresentation(GenericKeys.SUMMARY) : info.getUrl();
                this.myInfoHint = this.createHintLabel(hintText);
                this.showHint(this.myInfoHint);
            }
            return;
        }
        if (sameRange && this.myNavigateHint != null) {
            return;
        }
        this.clearNavigationHighlight();
        String codeFragment = "<b>" + hoveredRange.getCodeLink().getCodeFragment() + "</b>";
        ArtifactInfo info = this.getInfo(hoveredRange);
        String summary = info.getStatus() == ArtifactInfoStatus.OK ? (String)info.getPresentation(GenericKeys.SHORT_DESCRIPTION_HTML) : codeFragment;
        String tooltip = StringBundle.get("action.show_issue.formatted.tooltip", summary);
        this.hideInfoHint();
        this.hideOpenHint();
        this.myNavigateHint = this.createHintLabel(tooltip);
        this.showHint(this.myNavigateHint);
        this.showNavigationHighlight();
    }

    private ArtifactInfo getInfo(URLTextRange hoveredRange) {
        return this.myCache.getArtifactInfoSnapshot(hoveredRange.getCodeLink().getUrl());
    }

    private LightweightHint createHintLabel(String hintText) {
        JLabel label = new JLabel();
        label.setText(hintText);
        label.setOpaque(true);
        label.setBorder(HINT_BORDER);
        label.setBackground(HINT_BACKGROUND);
        label.setForeground(Color.BLACK);
        return new LightweightHint((JComponent)label);
    }

    private void showHint(LightweightHint hint) {
        assert (this.myLastLocation != null);
        Point point = this.getHintLocation(this.myLastLocation);
        HintManager hintManager = HintManager.getInstance();
        hintManager.showEditorHint(hint, this.myEditor, point, 17, 0, true);
    }

    private Point getHintLocation(@NotNull Point mouseLocation) {
        if (mouseLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/EditorInputHandler.getHintLocation must not be null");
        }
        Point adjusted = this.myEditor.visualPositionToXY(this.myEditor.xyToVisualPosition(mouseLocation));
        adjusted.y -= this.myEditor.getLineHeight() + 2;
        adjusted.x += 2;
        return this.translateToFrame(adjusted);
    }

    private Point translateToFrame(Point point) {
        Point result = new Point(point);
        Container component = this.myEditor.getContentComponent();
        while (!(component instanceof JRootPane)) {
            result.x += ((Component)component).getX();
            result.y += ((Component)component).getY();
            component = component.getParent();
        }
        return result;
    }

    private void clearNavigationHighlight() {
        RangeHighlighter[] allHighlighters;
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        for (RangeHighlighter highlighter : allHighlighters = markupModel.getAllHighlighters()) {
            if (highlighter.getUserData(DYNAMIC_HIGHLIGHTER_KEY) == null) continue;
            markupModel.removeHighlighter(highlighter);
        }
    }

    private void showNavigationHighlight() {
        URLTextRange range = this.myLastLinkRange;
        assert (range != null);
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5001, StyleConstants.DYNAMIC_TEXT_ATTRIBUTES, HighlighterTargetArea.EXACT_RANGE);
        highlighter.putUserData(DYNAMIC_HIGHLIGHTER_KEY, EditorInputHandler.class);
    }

    private void hideOpenHint() {
        if (this.myNavigateHint != null) {
            this.myNavigateHint.hide();
            this.myNavigateHint = null;
        }
    }

    private void hideInfoHint() {
        if (this.myInfoHint != null) {
            this.myInfoHint.hide();
            this.myInfoHint = null;
        }
    }

    private void setEditorCursor(int cursor) {
        this.myEditor.getContentComponent().setCursor(Cursor.getPredefinedCursor(cursor));
    }
}

