
# Command name: /hilo
# Description:  This command changes upper chars to lower chars
#               and vice versa.
#               This is just a demo-script. You can see
#               here how you can add your own tkirc-scripts!
#
# Date:         2000-08-19
# Author:       Andreas Gelhausen, atte@netsplit.de
#
# Changes:      2000-08-19  Changes for tkirc's first release of version 2.
#                  [..]
#
# Install:
#               1. copy this file to `~/.tkirc2/autoload/hilo.tcl'
#               2. reload your tkircrc or restart tkirc


proc on_command_hilo {window arguments} {
  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /hilo <message>"
    return
  }
  set command "" ; set newline ""
  if {[regexp -- {^(/msg|/notice|/describe) .*} "$arguments"]} {
    set command "[leftwords "$arguments" 2] "
    set arguments "[cutwords "$arguments" 2]"
  }
  for {set i 0} {$i < [string length "$arguments"]} {incr i} {
    set char "[string index "$arguments" $i]"
    if {"$char" < "a"} {
      append newline "[string tolower "$char"]"
    } else {
      append newline "[string toupper "$char"]"
    }
  }
  send2tkirc $window "$command$newline"
}
