/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.awt.Toolkit;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Modifiers;
import org.assertj.swing.util.OSFamily;
import org.assertj.swing.util.OSIdentifier;
import org.assertj.swing.util.ToolkitProvider;

public final class Platform {
    private static OSIdentifier osIdentifier;
    private static Toolkit toolkit;

    @VisibleForTesting
    static void reload() {
        Platform.initialize(new OSIdentifier(), ToolkitProvider.instance().defaultToolkit());
    }

    @VisibleForTesting
    static void initialize(@Nonnull OSIdentifier osIdentifier, @Nonnull Toolkit toolkit) {
        Platform.osIdentifier = osIdentifier;
        Platform.toolkit = toolkit;
    }

    public static int controlOrCommandKey() {
        int menuShortcutKeyMask = Platform.controlOrCommandMask();
        int[] keys = Modifiers.keysFor(menuShortcutKeyMask);
        ((AbstractIntArrayAssert)((AbstractIntArrayAssert)Assertions.assertThat(keys).as(Strings.concat("Key code for mask ", String.valueOf(menuShortcutKeyMask)), new Object[0])).isNotNull()).hasSize(1);
        return keys[0];
    }

    public static int controlOrCommandMask() {
        return toolkit.getMenuShortcutKeyMask();
    }

    public static boolean canResizeWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean canMoveWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean isWindows() {
        return osIdentifier.isWindows();
    }

    public static boolean isWindows9x() {
        return osIdentifier.isWindows9x();
    }

    public static boolean isWindowsXP() {
        return osIdentifier.isWindowsXP();
    }

    public static boolean isMacintosh() {
        return osIdentifier.isMacintosh();
    }

    public static boolean isOSX() {
        return osIdentifier.isOSX();
    }

    public static boolean isX11() {
        return osIdentifier.isX11();
    }

    public static boolean isSolaris() {
        return osIdentifier.isSolaris();
    }

    public static boolean isHPUX() {
        return osIdentifier.isHPUX();
    }

    public static boolean isLinux() {
        return osIdentifier.isLinux();
    }

    @Nonnull
    public static OSFamily osFamily() {
        return osIdentifier.osFamily();
    }

    private Platform() {
    }

    static {
        Platform.reload();
    }
}

