/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickManager;
import com.intellij.ide.util.TipAndTrickPromotionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.BackgroundRoundedPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.LearningCourse;
import training.learn.course.Lesson;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.UISettings;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Ltraining/ui/IftTipAndTrickPromoter;", "Lcom/intellij/ide/util/TipAndTrickPromotionFactory;", "()V", "createOpenLessonPanel", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "lessonId", "", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "createPanel", "createPanelForNewUI", "createPromotionPanel", "findLessonIdForTip", "openLesson", "", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nIftTipAndTrickPromoter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IftTipAndTrickPromoter.kt\ntraining/ui/IftTipAndTrickPromoter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n1549#2:114\n1620#2,2:115\n1622#2:124\n494#3,7:117\n8#4:125\n8#4:127\n1#5:126\n*S KotlinDebug\n*F\n+ 1 IftTipAndTrickPromoter.kt\ntraining/ui/IftTipAndTrickPromoter\n*L\n38#1:110\n38#1:111,3\n39#1:114\n39#1:115,2\n39#1:124\n39#1:117,7\n42#1:125\n101#1:127\n*E\n"})
final class IftTipAndTrickPromoter
implements TipAndTrickPromotionFactory {
    @Nullable
    public JPanel createPromotionPanel(@NotNull Project project, @NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        if (!UtilsKt.getEnableLessonsAndPromoters()) {
            return null;
        }
        String string = this.findLessonIdForTip(tip);
        if (string == null) {
            return null;
        }
        String lessonId = string;
        return this.createOpenLessonPanel(project, lessonId, tip);
    }

    /*
     * WARNING - void declaration
     */
    private final String findLessonIdForTip(TipAndTrickBean tip) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = CourseManager.Companion.getInstance().getCurrentCourses();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            LearningCourse learningCourse = (LearningCourse)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLessonIdToTipsMap());
        }
        List lessonIdToTipsMaps = (List)destination$iv$iv;
        Iterable $this$map$iv2 = lessonIdToTipsMaps;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map bl = (Map)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void $this$filterValues$iv = it;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                List tipIds = (List)entry$iv.getValue();
                boolean bl3 = false;
                if (!tipIds.contains(tip.getId())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            collection.add(((Map)result$iv).keySet());
        }
        List lessonIds = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        if (!((Collection)lessonIds).isEmpty()) {
            if (lessonIds.size() > 1) {
                IftTipAndTrickPromoter $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IftTipAndTrickPromoter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(tip + " declared as suitable in more than one lesson: " + lessonIds);
            }
            return (String)CollectionsKt.first((List)lessonIds);
        }
        return null;
    }

    private final JPanel createOpenLessonPanel(Project project, String lessonId, TipAndTrickBean tip) {
        return ExperimentalUI.Companion.isNewUI() ? this.createPanelForNewUI(project, lessonId, tip) : this.createPanel(project, lessonId, tip);
    }

    private final JPanel createPanelForNewUI(Project project, String lessonId, TipAndTrickBean tip) {
        EditorNotificationPanel panel = new EditorNotificationPanel(EditorNotificationPanel.Status.Info);
        panel.setText(LearnBundle.INSTANCE.message("tip.and.trick.promotion.label", new Object[0]));
        panel.createActionLabel(LearnBundle.INSTANCE.message("tip.and.trick.promotion.open.lesson", new Object[0]), () -> IftTipAndTrickPromoter.createPanelForNewUI$lambda$3(this, project, lessonId, tip));
        Border insideBorder = panel.getBorder();
        Border outsideBorder = (Border)ClientProperty.get((Component)((Component)panel), (Key)FileEditorManager.SEPARATOR_BORDER);
        panel.setBorder(JBUI.Borders.compound((Border)outsideBorder, (Border)insideBorder));
        return (JPanel)panel;
    }

    private final JPanel createPanel(Project project, String lessonId, TipAndTrickBean tip) {
        BackgroundRoundedPanel container = new BackgroundRoundedPanel(8);
        container.setLayout((LayoutManager)new BoxLayout((Container)container, 0));
        container.setBackground(UISettings.Companion.getInstance().getShortcutBackgroundColor());
        JLabel promotionLabel = new JLabel(LearnBundle.INSTANCE.message("tip.and.trick.promotion.label", new Object[0]));
        promotionLabel.setIcon(AllIcons.General.BalloonInformation);
        promotionLabel.setIconTextGap(JBUI.scale((int)6));
        container.add(Box.createRigidArea((Dimension)new JBDimension(12, 28)));
        container.add((Component)promotionLabel);
        container.add(Box.createHorizontalGlue());
        ActionLink openLessonLink2 = new ActionLink(LearnBundle.INSTANCE.message("tip.and.trick.promotion.open.lesson", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this, project, lessonId, tip){
            final /* synthetic */ IftTipAndTrickPromoter this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $lessonId;
            final /* synthetic */ TipAndTrickBean $tip;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$lessonId = $lessonId;
                this.$tip = $tip;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IftTipAndTrickPromoter.access$openLesson(this.this$0, this.$project, this.$lessonId, this.$tip);
            }
        });
        container.add((Component)openLessonLink2);
        container.add(Box.createRigidArea((Dimension)new JBDimension(12, 28)));
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 0));
        wrapper.setBackground(UIUtil.getTextFieldBackground());
        wrapper.setBorder((Border)new JBEmptyBorder(8, 12, 3, 12));
        wrapper.add((Component)container);
        return wrapper;
    }

    private final void openLesson(Project project, String lessonId, TipAndTrickBean tip) {
        Object v0;
        CourseManager courseManager;
        block3: {
            TipAndTrickManager.Companion.getInstance().closeTipDialog();
            if (project.isDisposed()) {
                return;
            }
            courseManager = CourseManager.Companion.getInstance();
            Iterable iterable = courseManager.getLessonsForModules();
            for (Object t : iterable) {
                Lesson it = (Lesson)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)lessonId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Lesson lesson = v0;
        if (lesson == null) {
            IftTipAndTrickPromoter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IftTipAndTrickPromoter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Not found lesson with id: " + lessonId);
            return;
        }
        CourseManager.openLesson$default(courseManager, project, lesson, LessonStartingWay.TIP_AND_TRICK_PROMOTER, true, false, 16, null);
        String string = tip.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        StatisticBase.Companion.logLessonLinkClickedFromTip(lessonId, string);
    }

    private static final void createPanelForNewUI$lambda$3(IftTipAndTrickPromoter this$0, Project $project, String $lessonId, TipAndTrickBean $tip) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$lessonId, (String)"$lessonId");
        Intrinsics.checkNotNullParameter((Object)$tip, (String)"$tip");
        this$0.openLesson($project, $lessonId, $tip);
    }

    public static final /* synthetic */ void access$openLesson(IftTipAndTrickPromoter $this, Project project, String lessonId, TipAndTrickBean tip) {
        $this.openLesson(project, lessonId, tip);
    }
}

