/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class TextFileWriter {
    private static final TextFileWriter INSTANCE = new TextFileWriter();

    public static TextFileWriter instance() {
        return INSTANCE;
    }

    public void write(File file, String ... content) throws IOException {
        this.write(file, Charset.defaultCharset(), content);
    }

    public void write(File file, Charset charset, String ... content) throws IOException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));){
            for (String line : content) {
                writer.println(line);
            }
        }
    }

    private TextFileWriter() {
    }
}

