/*
 * Decompiled with CFR 0.152.
 */
package runtime.stringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.StringUtilsKt;
import runtime.stringUtils.Symbols;
import runtime.stringUtils.UnicodeUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u0018\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0006\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u001a\u0012\u0010\u0013\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0014\u001a\u00020\u0006*\u00020\u0006\u001a\u0012\u0010\u0015\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u0015\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u0012\u0010\u0015\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u00020\u0006*\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0006\u001a\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006\u001a\n\u0010\u001e\u001a\u00020\u0006*\u00020\u0006\u001a$\u0010\u001f\u001a\u00020\u0006*\u00020\u00062\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060!0\u0011\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0006\u001a\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011*\u00020\u00062\n\u0010%\u001a\u00020&\"\u00020'\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011*\u00020\u0006\u001a\u001c\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0!0\u0011*\u00020\u0006\u001a\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011*\u00020\u0006\u001a\u001c\u0010+\u001a\u00020\u0006*\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\b\b\u0002\u0010-\u001a\u00020\n\u001a\u0015\u0010.\u001a\u00020\u0006*\u00020\u00062\u0006\u0010/\u001a\u00020\u000fH\u0086\u0002\u001a\n\u00100\u001a\u00020\u0006*\u00020\u0006\u001a0\u00101\u001a\b\u0012\u0004\u0012\u0002H20\u0011\"\u0004\b\u0000\u00102*\b\u0012\u0004\u0012\u0002H20\u00112\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u00020\"04\u001a\u0010\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011*\u00020\u0006\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"whitespaceRegex", "Lkotlin/text/Regex;", "getWhitespaceRegex", "()Lkotlin/text/Regex;", "wordBoundaryRegex", "getPostfix", "", "string", "prefix", "containsIgnoreCase", "", "", "element", "ellipsize", "maxLength", "", "joinWithOxfordComma", "", "conjunction", "limitedView", "nonEmptyName", "pluralize", "count", "", "", "quoted", "quotation", "removePrefixOrNull", "removeSuffixOrNull", "suffix", "removeWhitespace", "replace", "ranges", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "singularize", "splitByCamelHumpsAndPunctuation", "letterLikeChars", "", "", "splitByWhitespace", "splitByWhitespaceWithRanges", "splitByWordBoundaries", "surround", "symbols", "reverseSuffix", "times", "n", "withNbsp", "withoutIntersections", "T", "getRange", "Lkotlin/Function1;", "wordBoundaryIndexes", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nruntime/stringUtils/StringUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1174#2,2:192\n1747#3,3:194\n766#3:197\n857#3,2:198\n2949#3:200\n2847#3,3:201\n2850#3,6:205\n731#3,9:211\n766#3:220\n857#3:221\n858#3:223\n1#4:204\n1#4:222\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nruntime/stringUtils/StringUtilsKt\n*L\n44#1:192,2\n109#1:194,3\n127#1:197\n127#1:198,2\n128#1:200\n128#1:201,3\n128#1:205,6\n129#1:211,9\n150#1:220\n150#1:221\n150#1:223\n128#1:204\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex whitespaceRegex = new Regex("\\s");
    @NotNull
    private static final Regex wordBoundaryRegex = new Regex("\\b");

    @NotNull
    public static final String getPostfix(@NotNull String string2, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        CharSequence charSequence = string2;
        Regex regex2 = new Regex(prefix + "(.*)");
        String string3 = "$1";
        return regex2.replaceFirst(charSequence, string3);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, double count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return count2 == 1.0 ? $this$pluralize : (StringsKt.endsWith$default((String)$this$pluralize, (String)"s", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"x", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"z", (boolean)false, (int)2, null) ? $this$pluralize + "es" : (StringsKt.endsWith$default((String)$this$pluralize, (String)"y", (boolean)false, (int)2, null) ? (StringsKt.endsWith$default((String)$this$pluralize, (String)"ay", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"ey", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"oy", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$pluralize, (String)"uy", (boolean)false, (int)2, null) ? $this$pluralize + "s" : (StringsKt.endsWith$default((String)$this$pluralize, (String)"iy", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$pluralize, (int)1) + "es" : StringsKt.dropLast((String)$this$pluralize, (int)1) + "ies")) : $this$pluralize + "s"));
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, int count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (double)count2);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize, long count2) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        return StringUtilsKt.pluralize($this$pluralize, (double)count2);
    }

    @NotNull
    public static final String singularize(@NotNull String $this$singularize) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$singularize, (String)"<this>");
        if (StringsKt.endsWith$default((String)$this$singularize, (String)"ies", (boolean)false, (int)2, null)) {
            object = StringsKt.dropLast((String)$this$singularize, (int)3) + "y";
        } else if (StringsKt.endsWith$default((String)$this$singularize, (String)"es", (boolean)false, (int)2, null)) {
            String string2;
            String it = string2 = StringsKt.dropLast((String)$this$singularize, (int)2);
            boolean bl = false;
            object = StringsKt.endsWith$default((CharSequence)it, (char)'s', (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"sh", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"ch", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)it, (char)'x', (boolean)false, (int)2, null) ? string2 : null;
            if (object == null) {
                object = StringsKt.dropLast((String)$this$singularize, (int)1);
            }
        } else {
            object = StringsKt.endsWith$default((CharSequence)$this$singularize, (char)'s', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)$this$singularize, (int)1) : $this$singularize;
        }
        return object;
    }

    @NotNull
    public static final List<String> splitByCamelHumpsAndPunctuation(@NotNull String $this$splitByCamelHumpsAndPunctuation, char ... letterLikeChars) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByCamelHumpsAndPunctuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)letterLikeChars, (String)"letterLikeChars");
        StringBuilder currentToken = new StringBuilder();
        List result2 = new ArrayList();
        boolean isPrevUpperCase = false;
        CharSequence $this$forEach$iv = $this$splitByCamelHumpsAndPunctuation;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            boolean isUpperCase = UnicodeUtilKt.isUpperCase(c);
            if (!UnicodeUtilKt.isAlphaNumeric(c) && !ArraysKt.contains((char[])letterLikeChars, (char)c)) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
            } else if (!isPrevUpperCase && isUpperCase) {
                StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
                currentToken.append(c);
            } else {
                currentToken.append(c);
            }
            isPrevUpperCase = isUpperCase;
        }
        StringUtilsKt.splitByCamelHumpsAndPunctuation$flushToken(currentToken, result2);
        return result2;
    }

    @NotNull
    public static final String surround(@NotNull String $this$surround, @NotNull String symbols, boolean reverseSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$surround, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        return symbols + $this$surround + (reverseSuffix ? ((Object)StringsKt.reversed((CharSequence)symbols)).toString() : symbols);
    }

    public static /* synthetic */ String surround$default(String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringUtilsKt.surround(string2, string3, bl);
    }

    @NotNull
    public static final String quoted(@NotNull String $this$quoted, @NotNull String quotation) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)quotation, (String)"quotation");
        return StringUtilsKt.surround$default($this$quoted, quotation, false, 2, null);
    }

    public static /* synthetic */ String quoted$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "\"";
        }
        return StringUtilsKt.quoted(string2, string3);
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return $this$ellipsize + Symbols.Ellipsis;
    }

    @NotNull
    public static final String ellipsize(@NotNull String $this$ellipsize, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$ellipsize, (String)"<this>");
        return $this$ellipsize.length() > maxLength ? StringsKt.take((String)$this$ellipsize, (int)(maxLength - 1)) + Symbols.Ellipsis : StringsKt.take((String)$this$ellipsize, (int)maxLength);
    }

    @NotNull
    public static final String times(@NotNull String $this$times, int n) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        switch (n) {
            case 0: {
                string2 = "";
                break;
            }
            case 1: {
                string2 = $this$times;
                break;
            }
            default: {
                int i = 0;
                StringBuilder result2 = new StringBuilder($this$times);
                while (++i < n) {
                    result2.append($this$times);
                }
                String string3 = result2.toString();
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            }
        }
        return string2;
    }

    @Nullable
    public static final String removePrefixOrNull(@NotNull String $this$removePrefixOrNull, @NotNull String prefix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$removePrefixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (StringsKt.startsWith$default((String)$this$removePrefixOrNull, (String)prefix, (boolean)false, (int)2, null)) {
            String string3 = $this$removePrefixOrNull.substring(prefix.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public static final String removeSuffixOrNull(@NotNull String $this$removeSuffixOrNull, @NotNull String suffix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$removeSuffixOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (StringsKt.endsWith$default((String)$this$removeSuffixOrNull, (String)suffix, (boolean)false, (int)2, null)) {
            String string3 = $this$removeSuffixOrNull.substring(0, $this$removeSuffixOrNull.length() - suffix.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final String withNbsp(@NotNull String $this$withNbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$withNbsp, (String)"<this>");
        return StringsKt.replace$default((String)$this$withNbsp, (String)" ", (String)Symbols.Nbsp.toString(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String limitedView(@NotNull String $this$limitedView, int maxLength) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$limitedView, (String)"<this>");
        if ($this$limitedView.length() > maxLength) {
            String string2 = $this$limitedView.substring(0, maxLength - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string2 + "...";
        } else {
            object = $this$limitedView;
        }
        return object;
    }

    public static final boolean containsIgnoreCase(@NotNull Collection<String> $this$containsIgnoreCase, @NotNull String element) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$containsIgnoreCase, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable $this$any$iv = $this$containsIgnoreCase;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)element, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final Regex getWhitespaceRegex() {
        return whitespaceRegex;
    }

    @NotNull
    public static final String removeWhitespace(@NotNull String $this$removeWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$removeWhitespace, (String)"<this>");
        CharSequence charSequence = $this$removeWhitespace;
        Regex regex2 = whitespaceRegex;
        String string2 = "";
        return regex2.replace(charSequence, string2);
    }

    @NotNull
    public static final List<String> splitByWhitespace(@NotNull String $this$splitByWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespace, (String)"<this>");
        CharSequence charSequence = $this$splitByWhitespace;
        Regex regex2 = whitespaceRegex;
        int n = 0;
        return regex2.split(charSequence, n);
    }

    @NotNull
    public static final List<String> splitByWordBoundaries(@NotNull String $this$splitByWordBoundaries) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWordBoundaries, (String)"<this>");
        CharSequence charSequence = $this$splitByWordBoundaries;
        Regex regex2 = wordBoundaryRegex;
        int n = 0;
        return regex2.split(charSequence, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Integer> wordBoundaryIndexes(@NotNull String $this$wordBoundaryIndexes) {
        List list2;
        List list3;
        void $this$scan$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$wordBoundaryIndexes, (String)"<this>");
        Iterable $this$filter$iv = StringUtilsKt.splitByWordBoundaries($this$wordBoundaryIndexes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Integer initial$iv = 0;
        boolean $i$f$scan = false;
        void $this$runningFold$iv$iv = $this$scan$iv;
        boolean $i$f$runningFold = false;
        int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv, (int)9);
        if (estimatedSize$iv$iv == 0) {
            list3 = CollectionsKt.listOf((Object)initial$iv);
        } else {
            Object element$iv$iv;
            Object $this$runningFold_u24lambda_u2418$iv$iv = element$iv$iv = new ArrayList(estimatedSize$iv$iv + 1);
            boolean bl = false;
            ((ArrayList)$this$runningFold_u24lambda_u2418$iv$iv).add((Integer)initial$iv);
            Object result$iv$iv = element$iv$iv;
            Integer accumulator$iv$iv = initial$iv;
            for (Object element$iv$iv2 : $this$runningFold$iv$iv) {
                void word;
                String string2 = (String)element$iv$iv2;
                int len = ((Number)accumulator$iv$iv).intValue();
                boolean bl3 = false;
                accumulator$iv$iv = len + word.length();
                ((ArrayList)result$iv$iv).add(accumulator$iv$iv);
            }
            list3 = (List)result$iv$iv;
        }
        List $this$dropLastWhile$iv = list3;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                int it = ((Number)iterator$iv.previous()).intValue();
                boolean bl = false;
                if (it >= $this$wordBoundaryIndexes.length()) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<Pair<String, IntRange>> splitByWhitespaceWithRanges(@NotNull String $this$splitByWhitespaceWithRanges) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByWhitespaceWithRanges, (String)"<this>");
        Ref.IntRef prevIndex = new Ref.IntRef();
        Sequence wordBoundaries2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super IntRange>, Continuation<? super Unit>, Object>($this$splitByWhitespaceWithRanges, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $this_splitByWhitespaceWithRanges;
            {
                this.$this_splitByWhitespaceWithRanges = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.map((Sequence)Regex.findAll$default((Regex)StringUtilsKt.getWhitespaceRegex(), (CharSequence)this.$this_splitByWhitespaceWithRanges, (int)0, (int)2, null), (Function1)splitByWhitespaceWithRanges.wordBoundaries.1.INSTANCE), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield((Object)new IntRange(this.$this_splitByWhitespaceWithRanges.length(), this.$this_splitByWhitespaceWithRanges.length()), (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super IntRange> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)wordBoundaries2, (Function1)((Function1)new Function1<IntRange, Pair<? extends String, ? extends IntRange>>(prevIndex, $this$splitByWhitespaceWithRanges){
            final /* synthetic */ Ref.IntRef $prevIndex;
            final /* synthetic */ String $this_splitByWhitespaceWithRanges;
            {
                this.$prevIndex = $prevIndex;
                this.$this_splitByWhitespaceWithRanges = $receiver;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Pair<String, IntRange> invoke(@NotNull IntRange range3) {
                Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
                IntRange intRange = range3;
                Ref.IntRef intRef = this.$prevIndex;
                IntRange it = intRange;
                boolean $i$a$-takeIf-StringUtilsKt$splitByWhitespaceWithRanges$1$22 = false;
                if (it.getFirst() <= intRef.element) return null;
                boolean bl = true;
                if (!bl) return null;
                IntRange intRange2 = intRange;
                IntRange intRange3 = intRange2;
                if (intRange3 == null) return null;
                intRef = intRange3;
                String string2 = this.$this_splitByWhitespaceWithRanges;
                Ref.IntRef $i$a$-takeIf-StringUtilsKt$splitByWhitespaceWithRanges$1$22 = this.$prevIndex;
                Ref.IntRef it2 = intRef;
                boolean bl2 = false;
                String string3 = string2.substring($i$a$-takeIf-StringUtilsKt$splitByWhitespaceWithRanges$1$22.element, it2.getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                intRange = TuplesKt.to((Object)string3, (Object)RangesKt.until((int)$i$a$-takeIf-StringUtilsKt$splitByWhitespaceWithRanges$1$22.element, (int)it2.getFirst()));
                if (intRange == null) return null;
                intRef = intRange;
                string2 = this.$prevIndex;
                Ref.IntRef it3 = intRef;
                boolean bl3 = false;
                ((Ref.IntRef)string2).element = range3.getLast() + 1;
                Ref.IntRef intRef2 = intRef;
                return intRef2;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> withoutIntersections(@NotNull List<? extends T> $this$withoutIntersections, @NotNull Function1<? super T, IntRange> getRange) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$withoutIntersections, (String)"<this>");
        Intrinsics.checkNotNullParameter(getRange, (String)"getRange");
        int lastRangeEndIx = 0;
        lastRangeEndIx = -1;
        Function1[] function1Array = new Function1[]{new Function1<T, Comparable<?>>(getRange){
            final /* synthetic */ Function1<T, IntRange> $getRange;
            {
                this.$getRange = $getRange;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(T it) {
                return ((IntRange)this.$getRange.invoke(it)).getFirst();
            }
        }, new Function1<T, Comparable<?>>(getRange){
            final /* synthetic */ Function1<T, IntRange> $getRange;
            {
                this.$getRange = $getRange;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(T it) {
                return -((IntRange)this.$getRange.invoke(it)).getLast();
            }
        }};
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$withoutIntersections, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            boolean $this$withoutIntersections_u24lambda_u247_u24lambda_u246 = bl = ((IntRange)getRange.invoke(it)).getFirst() > lastRangeEndIx;
            boolean bl3 = false;
            lastRangeEndIx = ((IntRange)getRange.invoke(it)).getLast();
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String replace(@NotNull String $this$replace, @NotNull List<Pair<IntRange, String>> ranges2) {
        Intrinsics.checkNotNullParameter((Object)$this$replace, (String)"<this>");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        if (ranges2.isEmpty()) {
            return $this$replace;
        }
        Object result2 = "";
        int pos = 0;
        Pair pair2 = new Pair[]{replace.1.INSTANCE, replace.2.INSTANCE};
        for (Pair pair2 : CollectionsKt.sortedWith((Iterable)ranges2, (Comparator)ComparisonsKt.compareBy((Function1[])pair2))) {
            IntRange range3 = (IntRange)pair2.component1();
            String serverView = (String)pair2.component2();
            if (pos > range3.getFirst() || range3.getFirst() >= $this$replace.length()) continue;
            result2 = (String)result2 + $this$replace.subSequence(pos, range3.getFirst());
            result2 = (String)result2 + serverView;
            pos = range3.getLast() + 1;
        }
        if (pos < $this$replace.length()) {
            result2 = (String)result2 + $this$replace.subSequence(pos, $this$replace.length());
        }
        return result2;
    }

    @NotNull
    public static final String joinWithOxfordComma(@NotNull List<String> $this$joinWithOxfordComma, @NotNull String conjunction) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$joinWithOxfordComma, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)conjunction, (String)"conjunction");
        List<String> list2 = $this$joinWithOxfordComma;
        StringBuilder $this$joinWithOxfordComma_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (list2.size() == 1) {
            $this$joinWithOxfordComma_u24lambda_u248.append((String)CollectionsKt.single(list2));
        } else if (list2.size() == 2) {
            $this$joinWithOxfordComma_u24lambda_u248.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)(" " + conjunction + " "), null, null, (int)0, null, null, (int)62, null));
        } else if (list2.size() > 2) {
            $this$joinWithOxfordComma_u24lambda_u248.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)list2, (int)CollectionsKt.getLastIndex(list2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ", " + conjunction + " " + CollectionsKt.last(list2));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String joinWithOxfordComma$default(List list2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "or";
        }
        return StringUtilsKt.joinWithOxfordComma(list2, string2);
    }

    @NotNull
    public static final String nonEmptyName(@NotNull String $this$nonEmptyName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$nonEmptyName, (String)"<this>");
        CharSequence charSequence2 = $this$nonEmptyName;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "Untitled";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final void splitByCamelHumpsAndPunctuation$flushToken(StringBuilder currentToken, List<String> result2) {
        if (((CharSequence)currentToken).length() > 0) {
            String string2 = currentToken.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            result2.add(string2);
            StringsKt.clear((StringBuilder)currentToken);
        }
    }
}

