/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.DebugKt;
import libraries.collections.MutableSetLike;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellTrackerKt;
import runtime.reactive.ComputedExpression;
import runtime.reactive.DependenciesState;
import runtime.reactive.Effect;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackable;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a<\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\t\u001a0\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\t\u001a\u001f\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\t\u00a2\u0006\u0002\u0010\u0018\u001a/\u0010\u0019\u001a\u00020\f*\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\b\u001e\u001a#\u0010\u0019\u001a\u00020\f*\u00020\u001a2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\b\u001e\u001a^\u0010 \u001a\u00020\f\"\u0004\b\u0000\u0010\u0016*\u00020\u001a2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u00160\u0010\u00a2\u0006\u0002\b\u001e2\b\b\u0002\u0010#\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u001d\u0010 \u001a\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\f0$\u00a2\u0006\u0002\b\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"log", "Llibraries/klogging/KLogger;", "isNeedToBeReexecuted", "Lkotlin/Pair;", "", "Lruntime/reactive/ComputedExpression;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "currentDependenciesState", "Lkotlin/Function0;", "Lruntime/reactive/DependenciesState;", "markAsPossiblyStale", "", "dependency", "dependenciesState", "setDependenciesState", "Lkotlin/Function1;", "Lruntime/reactive/DependenciesState$Tracked$PossiblyStale;", "schedule", "markAsStale", "Lruntime/reactive/DependenciesState$Tracked$Stale;", "mutate", "T", "actionHandler", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "effect", "Llibraries/coroutines/extra/Lifetimed;", "dbgName", "", "Lruntime/reactive/XTrackableLifetimed;", "Lkotlin/ExtensionFunctionType;", "effectFunction", "reaction", "expression", "Lruntime/reactive/XTrackable;", "initialReaction", "Lkotlin/Function2;", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nReactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reactions.kt\nruntime/reactive/ReactionsKt\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,298:1\n12#2:299\n*S KotlinDebug\n*F\n+ 1 Reactions.kt\nruntime/reactive/ReactionsKt\n*L\n9#1:299\n*E\n"})
public final class ReactionsKt {
    @NotNull
    private static final KLogger log;

    public static final <T> T mutate(@NotNull Function0<? extends T> actionHandler) {
        Intrinsics.checkNotNullParameter(actionHandler, (String)"actionHandler");
        return TransactionalReactionsScheduler.INSTANCE.transaction(actionHandler);
    }

    public static final void effect(@NotNull Lifetimed $this$effect, @NotNull Function1<? super XTrackableLifetimed, Unit> effectFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"<this>");
        Intrinsics.checkNotNullParameter(effectFunction, (String)"effectFunction");
        if ($this$effect.getLifetime().isTerminated()) {
            return;
        }
        new Effect($this$effect.getLifetime(), effectFunction).run();
    }

    public static final void effect(@NotNull Lifetimed $this$effect, @Nullable String dbgName, @NotNull Function1<? super XTrackableLifetimed, Unit> effect2) {
        Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"<this>");
        Intrinsics.checkNotNullParameter(effect2, (String)"effect");
        ReactionsKt.effect($this$effect, DebugKt.assignDbgName(effect2, dbgName));
    }

    public static /* synthetic */ void effect$default(Lifetimed lifetimed, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        ReactionsKt.effect(lifetimed, string2, (Function1<? super XTrackableLifetimed, Unit>)function1);
    }

    public static final <T> void reaction(@NotNull Lifetimed $this$reaction, @NotNull Function1<? super XTrackable, ? extends T> expression, boolean initialReaction, @Nullable String dbgName, @NotNull Function2<? super Lifetimed, ? super T, Unit> reaction2) {
        Intrinsics.checkNotNullParameter((Object)$this$reaction, (String)"<this>");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter(reaction2, (String)"reaction");
        Ref.BooleanRef isFirstCall = new Ref.BooleanRef();
        isFirstCall.element = true;
        ReactionsKt.effect($this$reaction, dbgName, (Function1<? super XTrackableLifetimed, Unit>)((Function1)new Function1<XTrackableLifetimed, Unit>(expression, isFirstCall, initialReaction, reaction2){
            final /* synthetic */ Function1<XTrackable, T> $expression;
            final /* synthetic */ Ref.BooleanRef $isFirstCall;
            final /* synthetic */ boolean $initialReaction;
            final /* synthetic */ Function2<Lifetimed, T, Unit> $reaction;
            {
                this.$expression = $expression;
                this.$isFirstCall = $isFirstCall;
                this.$initialReaction = $initialReaction;
                this.$reaction = $reaction;
                super(1);
            }

            public final void invoke(@NotNull XTrackableLifetimed $this$effect) {
                Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"$this$effect");
                Object result2 = this.$expression.invoke((Object)$this$effect);
                if (!this.$isFirstCall.element || this.$initialReaction) {
                    CellTrackerKt.untrack((Function1)new Function1<XTrackable, Unit>(this.$reaction, $this$effect, result2){
                        final /* synthetic */ Function2<Lifetimed, T, Unit> $reaction;
                        final /* synthetic */ XTrackableLifetimed $this_effect;
                        final /* synthetic */ T $result;
                        {
                            this.$reaction = $reaction;
                            this.$this_effect = $this_effect;
                            this.$result = $result;
                            super(1);
                        }

                        public final void invoke(@NotNull XTrackable $this$untrack) {
                            Intrinsics.checkNotNullParameter((Object)$this$untrack, (String)"$this$untrack");
                            this.$reaction.invoke((Object)this.$this_effect.getLifetime(), this.$result);
                        }
                    });
                }
                this.$isFirstCall.element = false;
            }
        }));
    }

    public static /* synthetic */ void reaction$default(Lifetimed lifetimed, Function1 function1, boolean bl, String string2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        ReactionsKt.reaction(lifetimed, function1, bl, string2, function2);
    }

    public static final void markAsPossiblyStale(@NotNull ComputedExpression<?> dependency, @NotNull DependenciesState dependenciesState, @NotNull Function1<? super DependenciesState.Tracked.PossiblyStale, Unit> setDependenciesState, @NotNull Function0<Unit> schedule2) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"dependenciesState");
        Intrinsics.checkNotNullParameter(setDependenciesState, (String)"setDependenciesState");
        Intrinsics.checkNotNullParameter(schedule2, (String)"schedule");
        DependenciesState dependenciesState2 = dependenciesState;
        if (Intrinsics.areEqual((Object)dependenciesState2, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            DependenciesState.Tracked.PossiblyStale newDependenciesState = new DependenciesState.Tracked.PossiblyStale();
            newDependenciesState.getDependenciesMightHaveChanged().add(dependency);
            setDependenciesState.invoke((Object)newDependenciesState);
            schedule2.invoke();
        } else if (dependenciesState2 instanceof DependenciesState.Tracked.PossiblyStale) {
            ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().add(dependency);
        }
    }

    public static final void markAsStale(@NotNull DependenciesState dependenciesState, @NotNull Function1<? super DependenciesState.Tracked.Stale, Unit> setDependenciesState, @NotNull Function0<Unit> schedule2) {
        Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"dependenciesState");
        Intrinsics.checkNotNullParameter(setDependenciesState, (String)"setDependenciesState");
        Intrinsics.checkNotNullParameter(schedule2, (String)"schedule");
        setDependenciesState.invoke((Object)DependenciesState.Tracked.Stale.INSTANCE);
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            schedule2.invoke();
        }
    }

    @NotNull
    public static final Pair<Boolean, ComputedExpression<?>> isNeedToBeReexecuted(@NotNull Lifetime lifetime, @NotNull Function0<? extends DependenciesState> currentDependenciesState) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(currentDependenciesState, (String)"currentDependenciesState");
        DependenciesState dependenciesState = (DependenciesState)currentDependenciesState.invoke();
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            pair = TuplesKt.to((Object)false, null);
        } else if (dependenciesState instanceof DependenciesState.NotTracked) {
            pair = TuplesKt.to((Object)false, null);
        } else if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE)) {
            pair = TuplesKt.to((Object)true, null);
        } else if (dependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
            boolean needsToBeReexecuted = false;
            MutableSetLike<ComputedExpression<?>> dependenciesToInvalidate = ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().copy();
            Ref.ObjectRef cause = new Ref.ObjectRef();
            while (!needsToBeReexecuted) {
                MutableSetLike<ComputedExpression<?>> mutableSetLike = dependenciesToInvalidate;
                boolean bl = mutableSetLike != null ? !mutableSetLike.isEmpty() : false;
                if (!bl || lifetime.isTerminated()) break;
                needsToBeReexecuted = dependenciesToInvalidate.any((Function1)new Function1<ComputedExpression<?>, Boolean>(dependenciesState, cause){
                    final /* synthetic */ DependenciesState $dependenciesState;
                    final /* synthetic */ Ref.ObjectRef<ComputedExpression<?>> $cause;
                    {
                        this.$dependenciesState = $dependenciesState;
                        this.$cause = $cause;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ComputedExpression<?> dependency) {
                        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                        ((DependenciesState.Tracked.PossiblyStale)this.$dependenciesState).getDependenciesMightHaveChanged().remove(dependency);
                        boolean changed = dependency.tryInvalidate();
                        if (changed) {
                            this.$cause.element = dependency;
                        }
                        return changed;
                    }
                });
                if (needsToBeReexecuted) continue;
                DependenciesState newDependenciesState = (DependenciesState)currentDependenciesState.invoke();
                if (Intrinsics.areEqual((Object)newDependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE)) {
                    needsToBeReexecuted = true;
                    continue;
                }
                if (newDependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
                    dependenciesToInvalidate = ((DependenciesState.Tracked.PossiblyStale)newDependenciesState).getDependenciesMightHaveChanged().copy();
                    continue;
                }
                dependenciesToInvalidate = null;
            }
            pair = TuplesKt.to((Object)needsToBeReexecuted, (Object)cause.element);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$logger$iv;
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "runtime/TrCellable.kt";
        boolean $i$f$logger = false;
        log = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
    }
}

