/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bj\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lruntime/logging/LogLevelUpdater;", "", "()V", "log", "Llibraries/klogging/KLogger;", "loggerContext", "Lch/qos/logback/classic/LoggerContext;", "overriddenLoggers", "Ljava/util/HashMap;", "", "Lch/qos/logback/classic/Level;", "Lkotlin/collections/HashMap;", "set", "", "config", "", "OverriddenLogger", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nLogLevelUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogLevelUpdater.kt\nruntime/logging/LogLevelUpdater\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,40:1\n35#2,5:41\n215#3,2:46\n526#4:48\n511#4,6:49\n1855#5,2:55\n14#6:57\n*S KotlinDebug\n*F\n+ 1 LogLevelUpdater.kt\nruntime/logging/LogLevelUpdater\n*L\n15#1:41,5\n21#1:46,2\n32#1:48\n32#1:49,6\n32#1:55,2\n7#1:57\n*E\n"})
public final class LogLevelUpdater {
    @NotNull
    public static final LogLevelUpdater INSTANCE = new LogLevelUpdater();
    @NotNull
    private static final KLogger log;
    @Nullable
    private static final LoggerContext loggerContext;
    @NotNull
    private static final HashMap<String, Level> overriddenLoggers;

    private LogLevelUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void set(@NotNull Map<String, Level> config2) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        if (loggerContext == null) {
            KLogger this_$iv = log;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = "Logback logger context not found. Debug logging modifications can't be applied";
                this_$iv.error(msgStr$iv);
            }
            return;
        }
        HashMap<String, Level> hashMap = overriddenLoggers;
        synchronized (hashMap) {
            void $this$filterTo$iv$iv;
            Level level;
            String name2;
            Map.Entry<String, Object> element$iv;
            boolean bl = false;
            Object $this$forEach$iv = config2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Level> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                name2 = entry.getKey();
                level = entry.getValue();
                Logger logger2 = loggerContext.getLogger(name2);
                if (Intrinsics.areEqual((Object)logger2.getLevel(), (Object)level)) continue;
                log.info("Override logger " + name2 + " level to " + level);
                if (!overriddenLoggers.containsKey(name2)) {
                    ((Map)overriddenLoggers).put(name2, logger2.getLevel());
                }
                logger2.setLevel(level);
            }
            Map $this$filter$iv = overriddenLoggers;
            boolean $i$f$filter = false;
            iterator2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator bl2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (bl2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = bl2.next();
                boolean bl3 = false;
                if (!(!config2.containsKey(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$forEach$iv = MapsKt.toList((Map)destination$iv$iv);
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                Pair pair = (Pair)element$iv;
                boolean bl4 = false;
                name2 = (String)pair.component1();
                level = (Level)pair.component2();
                log.info("Restore logger " + name2 + " level to " + level);
                loggerContext.getLogger(name2).setLevel(level);
                overriddenLoggers.remove(name2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(LogLevelUpdater.class));
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        loggerContext = iLoggerFactory instanceof LoggerContext ? (LoggerContext)iLoggerFactory : null;
        overriddenLoggers = new HashMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lruntime/logging/LogLevelUpdater$OverriddenLogger;", "", "name", "", "level", "Lch/qos/logback/classic/Level;", "(Ljava/lang/String;Lch/qos/logback/classic/Level;)V", "getLevel", "()Lch/qos/logback/classic/Level;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "platform-runtime"})
    private static final class OverriddenLogger {
        @NotNull
        private final String name;
        @NotNull
        private final Level level;

        public OverriddenLogger(@NotNull String name2, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            this.name = name2;
            this.level = level;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Level component2() {
            return this.level;
        }

        @NotNull
        public final OverriddenLogger copy(@NotNull String name2, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return new OverriddenLogger(name2, level);
        }

        public static /* synthetic */ OverriddenLogger copy$default(OverriddenLogger overriddenLogger, String string2, Level level, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = overriddenLogger.name;
            }
            if ((n & 2) != 0) {
                level = overriddenLogger.level;
            }
            return overriddenLogger.copy(string2, level);
        }

        @NotNull
        public String toString() {
            return "OverriddenLogger(name=" + this.name + ", level=" + this.level + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.level.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverriddenLogger)) {
                return false;
            }
            OverriddenLogger overriddenLogger = (OverriddenLogger)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)overriddenLogger.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.level, (Object)overriddenLogger.level);
        }
    }
}

