/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class ApacheURLLister {
    private static final Pattern PATTERN = Pattern.compile("<a[^>]*href=\"([^\"]*)\"[^>]*>(?:<[^>]+>)*?([^<>]+?)(?:<[^>]+>)*?</a>", 2);

    public List<URL> listAll(URL url2) throws IOException {
        return this.retrieveListing(url2, true, true);
    }

    public List<URL> listDirectories(URL url2) throws IOException {
        return this.retrieveListing(url2, false, true);
    }

    public List<URL> listFiles(URL url2) throws IOException {
        return this.retrieveListing(url2, true, false);
    }

    public List<URL> retrieveListing(URL url2, boolean includeFiles, boolean includeDirectories) throws IOException {
        URLHandler urlHandler;
        URLHandler.URLInfo urlInfo;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!url2.getPath().endsWith("/") && !url2.getPath().endsWith(".html")) {
            url2 = new URL(url2.getProtocol(), url2.getHost(), url2.getPort(), url2.getPath() + "/");
        }
        if ((urlInfo = (urlHandler = URLHandlerRegistry.getDefault()).getURLInfo(url2)) == URLHandler.UNAVAILABLE) {
            return urlList;
        }
        String charset = urlInfo.getBodyCharset();
        InputStream contentStream = urlHandler.openStream(url2);
        BufferedReader r = null;
        r = charset == null ? new BufferedReader(new InputStreamReader(contentStream)) : new BufferedReader(new InputStreamReader(contentStream, charset));
        String htmlText = FileUtil.readEntirely(r);
        Matcher matcher2 = PATTERN.matcher(htmlText);
        while (matcher2.find()) {
            boolean directory;
            String strippedText;
            String strippedHref;
            String text2;
            String href2;
            block10: {
                href2 = matcher2.group(1);
                text2 = matcher2.group(2);
                if (href2 == null || text2 == null) continue;
                text2 = text2.trim();
                try {
                    URI uri = new URI(href2);
                    href2 = uri.getPath();
                    if (uri.getScheme() == null) break block10;
                    if (!href2.startsWith(url2.getPath())) continue;
                    href2 = href2.substring(url2.getPath().length());
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            if (href2.startsWith("../")) continue;
            if (href2.startsWith("/")) {
                int slashIndex = href2.substring(0, href2.length() - 1).lastIndexOf(47);
                href2 = href2.substring(slashIndex + 1);
            }
            if (href2.startsWith("./")) {
                href2 = href2.substring("./".length());
            }
            if (text2.endsWith("..>")) {
                if (!href2.startsWith(text2.substring(0, text2.length() - 3))) {
                    continue;
                }
            } else if (!text2.endsWith("..&gt;") ? !(strippedHref = href2.endsWith("/") ? href2.substring(0, href2.length() - 1) : href2).equalsIgnoreCase(strippedText = text2.endsWith("/") ? text2.substring(0, text2.length() - 1) : text2) : !href2.startsWith(text2.substring(0, text2.length() - 6))) continue;
            if ((!(directory = href2.endsWith("/")) || !includeDirectories) && (directory || !includeFiles)) continue;
            URL child = new URL(url2, href2);
            urlList.add(child);
            Message.debug("ApacheURLLister found URL=[" + child + "].");
        }
        return urlList;
    }
}

