/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static boolean symlink(File target, File link, boolean overwrite) throws IOException {
        if (target.isFile()) {
            if (!FileUtil.prepareCopy(target, link, overwrite)) {
                return false;
            }
        } else {
            if (Files.isSymbolicLink(link.toPath()) && overwrite) {
                Message.verbose("Un-linking existing symbolic link " + link + " during symlink creation, since overwrite=true");
                Files.delete(link.toPath());
            }
            if (link.getParentFile() != null) {
                link.getParentFile().mkdirs();
            }
        }
        Files.createSymbolicLink(link.toPath(), target.getAbsoluteFile().toPath(), new FileAttribute[0]);
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l) throws IOException {
        return FileUtil.copy(src, dest, l, false);
    }

    public static boolean prepareCopy(File src, File dest, boolean overwrite) throws IOException {
        if (src.isDirectory()) {
            if (dest.exists()) {
                if (!dest.isDirectory()) {
                    throw new IOException("impossible to copy: destination is not a directory: " + dest);
                }
            } else {
                dest.mkdirs();
            }
            return true;
        }
        if (dest.exists()) {
            boolean unlinkSymlinkIfOverwrite = true;
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (Files.isSymbolicLink(dest.toPath())) {
                    dest.delete();
                } else if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
                return false;
            }
        }
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(src, dest, overwrite)) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtil.deepCopy(src, dest, l, overwrite);
        }
        try {
            if (Files.isSameFile(src.toPath(), dest.toPath())) {
                Message.verbose("Skipping copy of file " + src + " to " + dest + " since they are the same file");
                return overwrite;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ioe) {
            Message.verbose("Could not determine if " + src + " and dest " + dest + " are the same file", ioe);
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
        return true;
    }

    public static boolean deepCopy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        List<File> existingChild = Collections.emptyList();
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                dest.delete();
                dest.mkdirs();
                dest.setLastModified(src.lastModified());
            } else {
                File[] children2 = dest.listFiles();
                if (children2 != null) {
                    existingChild = new ArrayList<File>(Arrays.asList(children2));
                }
            }
        } else {
            dest.mkdirs();
            dest.setLastModified(src.lastModified());
        }
        File[] toCopy = src.listFiles();
        if (toCopy != null) {
            for (File cf : toCopy) {
                File childDest = new File(dest, cf.getName());
                if (!existingChild.isEmpty()) {
                    existingChild.remove(childDest);
                }
                if (cf.isDirectory()) {
                    FileUtil.deepCopy(cf, childDest, l, overwrite);
                    continue;
                }
                FileUtil.copy(cf, childDest, l, overwrite);
            }
        }
        for (File child : existingChild) {
            FileUtil.forceDelete(child);
        }
        return true;
    }

    public static void copy(URL src, File dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = URLHandlerRegistry.getDefault();
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).download(src, dest, listener2, timeoutConstraint);
            return;
        }
        handler.download(src, dest, listener2);
    }

    public static void copy(File src, URL dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = URLHandlerRegistry.getDefault();
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).upload(src, dest, listener2, timeoutConstraint);
            return;
        }
        handler.upload(src, dest, listener2);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l, boolean autoClose) throws IOException {
        CopyProgressEvent evt = null;
        if (l != null) {
            evt = new CopyProgressEvent();
        }
        try {
            int c;
            byte[] buffer2 = new byte[65536];
            long total2 = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer2)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer2, 0, c);
                total2 += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer2, c, total2));
            }
            if (l != null) {
                evt.update(EMPTY_BUFFER, 0, total2);
            }
            try {
                dest.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (autoClose) {
                src.close();
                dest.close();
            }
        }
        finally {
            if (autoClose) {
                try {
                    src.close();
                }
                catch (IOException iOException) {}
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (l != null) {
            l.end(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader in) throws IOException {
        try {
            StringBuilder buf = new StringBuilder();
            String line2 = in.readLine();
            while (line2 != null) {
                buf.append(line2).append("\n");
                line2 = in.readLine();
            }
            String string2 = buf.toString();
            return string2;
        }
        finally {
            in.close();
        }
    }

    public static String readEntirely(File f) throws IOException {
        return FileUtil.readEntirely(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(InputStream is) throws IOException {
        try {
            int c;
            StringBuilder sb = new StringBuilder();
            byte[] buffer2 = new byte[65536];
            while ((c = is.read(buffer2)) != -1) {
                sb.append(new String(buffer2, 0, c));
            }
            String string2 = sb.toString();
            return string2;
        }
        finally {
            is.close();
        }
    }

    public static String concat(String dir, String file2) {
        return dir + "/" + file2;
    }

    public static boolean forceDelete(File file2) {
        File[] files2;
        if (!file2.exists()) {
            return true;
        }
        if (file2.isDirectory() && (files2 = file2.listFiles()) != null) {
            for (File df : files2) {
                if (FileUtil.forceDelete(df)) continue;
                return false;
            }
        }
        return file2.delete();
    }

    public static List<File> getPathFiles(File root2, File file2) {
        ArrayList<File> ret = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(root2.getAbsolutePath())) {
            ret.add(file2);
            file2 = file2.getParentFile();
        }
        if (root2 != null) {
            ret.add(root2);
        }
        Collections.reverse(ret);
        return ret;
    }

    public static Collection<File> listAll(File dir, Collection<String> ignore) {
        return FileUtil.listAll(dir, new ArrayList<File>(), ignore);
    }

    private static Collection<File> listAll(File file2, Collection<File> list2, Collection<String> ignore) {
        if (ignore.contains(file2.getName())) {
            return list2;
        }
        if (file2.exists()) {
            list2.add(file2);
        }
        if (file2.isDirectory()) {
            File[] files2;
            for (File lf : files2 = file2.listFiles()) {
                FileUtil.listAll(lf, list2, ignore);
            }
        }
        return list2;
    }

    public static File resolveFile(File file2, String filename) {
        File result2 = new File(filename);
        if (!result2.isAbsolute()) {
            result2 = new File(file2, filename);
        }
        return FileUtil.normalize(result2.getPath());
    }

    public static File normalize(String path2) {
        Stack<String> s = new Stack<String>();
        DissectedPath dissectedPath = FileUtil.dissect(path2);
        s.push(dissectedPath.root);
        StringTokenizer tok = new StringTokenizer(dissectedPath.remainingPath, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    return new File(path2);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.elementAt(i));
        }
        return new File(sb.toString());
    }

    private static DissectedPath dissect(String path2) {
        char sep = File.separatorChar;
        String pathToDissect = path2.replace('/', sep).replace('\\', sep).trim();
        File[] filesystemRoots = File.listRoots();
        if (filesystemRoots != null) {
            for (File filesystemRoot : filesystemRoots) {
                if (!pathToDissect.startsWith(filesystemRoot.getPath())) continue;
                String root2 = filesystemRoot.getPath();
                String rest = pathToDissect.substring(root2.length());
                StringBuilder sbPath = new StringBuilder();
                for (int i = 0; i < rest.length(); ++i) {
                    char currentChar = rest.charAt(i);
                    if (i == 0) {
                        sbPath.append(currentChar);
                        continue;
                    }
                    char previousChar = rest.charAt(i - 1);
                    if (currentChar == sep && previousChar == sep) continue;
                    sbPath.append(currentChar);
                }
                return new DissectedPath(root2, sbPath.toString());
            }
        }
        if (pathToDissect.length() > 1 && pathToDissect.charAt(1) == sep) {
            int nextsep = pathToDissect.indexOf(sep, 2);
            String root3 = (nextsep = pathToDissect.indexOf(sep, nextsep + 1)) > 2 ? pathToDissect.substring(0, nextsep + 1) : pathToDissect;
            String rest = pathToDissect.substring(root3.length());
            return new DissectedPath(root3, rest);
        }
        return new DissectedPath(File.separator, pathToDissect);
    }

    public static long getFileLength(File file2) {
        long l = 0L;
        if (file2.isDirectory()) {
            File[] files2 = file2.listFiles();
            if (files2 != null) {
                for (File gf : files2) {
                    l += FileUtil.getFileLength(gf);
                }
            }
        } else {
            l = file2.length();
        }
        return l;
    }

    public static InputStream unwrapPack200(InputStream packed) throws IOException {
        BufferedInputStream buffered = new BufferedInputStream(packed);
        buffered.mark(4);
        byte[] magic = new byte[4];
        buffered.read(magic, 0, 4);
        buffered.reset();
        FilterInputStream in = buffered;
        if (magic[0] == 31 && magic[1] == -117 && magic[2] == 8) {
            in = new GZIPInputStream(in);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(baos);
        Pack200.newUnpacker().unpack((InputStream)new UncloseInputStream(in), jar);
        jar.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static final class DissectedPath {
        private final String root;
        private final String remainingPath;

        private DissectedPath(String root2, String remainingPath) {
            this.root = root2;
            this.remainingPath = remainingPath;
        }

        public String toString() {
            return "Dissected Path [root=" + this.root + ", remainingPath=" + this.remainingPath + "]";
        }
    }

    private static final class UncloseInputStream
    extends InputStream {
        private InputStream wrapped;

        public UncloseInputStream(InputStream wrapped2) {
            this.wrapped = wrapped2;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public int read(byte[] b, int off2, int len) throws IOException {
            return this.wrapped.read(b, off2, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

