/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.plugins.resolver.util.URLLister;

public class FileURLLister
implements URLLister {
    private File basedir;

    public FileURLLister() {
        this(null);
    }

    public FileURLLister(File baseDir) {
        this.basedir = baseDir;
    }

    @Override
    public boolean accept(String pattern2) {
        return pattern2.startsWith("file");
    }

    @Override
    public List<URL> listAll(URL url2) throws IOException {
        File file2;
        String path2;
        try {
            path2 = new File(new URI(url2.toExternalForm())).getPath();
        }
        catch (URISyntaxException e) {
            path2 = url2.getPath();
        }
        File file3 = file2 = this.basedir == null ? new File(path2) : new File(this.basedir, path2);
        if (file2.exists() && file2.isDirectory()) {
            String[] files2 = file2.list();
            ArrayList<URL> ret = new ArrayList<URL>(files2.length);
            URL context2 = url2.getPath().endsWith("/") ? url2 : new URL(url2.toExternalForm() + "/");
            for (String fileName : files2) {
                ret.add(new URL(context2, fileName));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "file lister";
    }
}

