/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.MemoryUtil;
import org.apache.ivy.util.Message;

public class RepositoryManagementEngine {
    private static final double THOUSAND = 1000.0;
    private static final int KILO = 1024;
    private boolean loaded;
    private Map<ModuleRevisionId, ModuleDescriptor> revisions = new HashMap<ModuleRevisionId, ModuleDescriptor>();
    private Map<ModuleRevisionId, String> errors = new HashMap<ModuleRevisionId, String>();
    private Map<ModuleId, Collection<ModuleDescriptor>> modules = new HashMap<ModuleId, Collection<ModuleDescriptor>>();
    private boolean analyzed;
    private Map<ModuleRevisionId, ModuleRevisionId> cache = new HashMap<ModuleRevisionId, ModuleRevisionId>();
    private Map<ModuleRevisionId, List<ModuleRevisionId>> dependers = new HashMap<ModuleRevisionId, List<ModuleRevisionId>>();
    private SearchEngine searchEngine;
    private ResolveEngine resolveEngine;
    private RepositoryManagementEngineSettings settings;

    public RepositoryManagementEngine(RepositoryManagementEngineSettings settings2, SearchEngine searchEngine, ResolveEngine resolveEngine) {
        this.settings = settings2;
        this.searchEngine = searchEngine;
        this.resolveEngine = resolveEngine;
    }

    public void load() {
        long startingMemoryUse = 0L;
        if (this.settings.dumpMemoryUsage()) {
            startingMemoryUse = MemoryUtil.getUsedMemory();
        }
        long startTime = System.currentTimeMillis();
        Message.rawinfo("searching modules... ");
        ModuleRevisionId[] mrids = this.searchModules();
        Message.info("loading repository metadata...");
        for (ModuleRevisionId mrid : mrids) {
            try {
                this.loadModuleRevision(mrid);
            }
            catch (Exception e) {
                Message.debug(e);
                this.errors.put(mrid, e.getMessage());
            }
        }
        long endTime = System.currentTimeMillis();
        Message.info(String.format("%nrepository loaded: %d modules; %d revisions; %s%ss", this.modules.size(), this.revisions.size(), this.settings.dumpMemoryUsage() ? (MemoryUtil.getUsedMemory() - startingMemoryUse) / 1024L + "kB; " : "", (double)(endTime - startTime) / 1000.0));
        this.loaded = true;
    }

    public void analyze() {
        this.ensureLoaded();
        Message.info("\nanalyzing dependencies...");
        for (ModuleDescriptor md : this.revisions.values()) {
            for (DependencyDescriptor dd : md.getDependencies()) {
                ModuleRevisionId dep = this.getDependency(dd);
                if (dep == null) {
                    Message.warn("inconsistent repository: declared dependency not found: " + dd);
                    continue;
                }
                this.getDependers(dep).add(md.getModuleRevisionId());
            }
            Message.progress();
        }
        this.analyzed = true;
    }

    public int getRevisionsNumber() {
        this.ensureLoaded();
        return this.revisions.size();
    }

    public int getModuleIdsNumber() {
        this.ensureLoaded();
        return this.modules.size();
    }

    public Collection<ModuleRevisionId> getOrphans() {
        this.ensureAnalyzed();
        HashSet<ModuleRevisionId> orphans = new HashSet<ModuleRevisionId>(this.revisions.keySet());
        orphans.removeAll(this.dependers.keySet());
        return orphans;
    }

    private ModuleRevisionId[] searchModules() {
        return this.searchEngine.listModules(ModuleRevisionId.newInstance("*", "*", "*", "*"), (PatternMatcher)RegexpPatternMatcher.INSTANCE);
    }

    private ModuleRevisionId getDependency(DependencyDescriptor dd) {
        ModuleRevisionId askedMrid = dd.getDependencyRevisionId();
        VersionMatcher vmatcher = this.settings.getVersionMatcher();
        if (vmatcher.isDynamic(askedMrid)) {
            ModuleRevisionId mrid = this.cache.get(askedMrid);
            if (mrid == null) {
                for (ModuleDescriptor md : this.getAllRevisions(askedMrid)) {
                    if (vmatcher.needModuleDescriptor(askedMrid, md.getResolvedModuleRevisionId())) {
                        if (!vmatcher.accept(askedMrid, md)) continue;
                        mrid = md.getResolvedModuleRevisionId();
                        break;
                    }
                    if (!vmatcher.accept(askedMrid, md.getResolvedModuleRevisionId())) continue;
                    mrid = md.getResolvedModuleRevisionId();
                    break;
                }
                if (mrid == null) {
                    return null;
                }
                this.cache.put(askedMrid, mrid);
            }
            return mrid;
        }
        return askedMrid;
    }

    private Collection<ModuleRevisionId> getDependers(ModuleRevisionId id2) {
        List<ModuleRevisionId> depders = this.dependers.get(id2);
        if (depders == null) {
            depders = new ArrayList<ModuleRevisionId>();
            this.dependers.put(id2, depders);
        }
        return depders;
    }

    private void loadModuleRevision(ModuleRevisionId mrid) throws Exception {
        ResolvedModuleRevision module2 = this.settings.getResolver(mrid).getDependency(new DefaultDependencyDescriptor(mrid, false), this.newResolveData());
        if (module2 == null) {
            Message.warn("module not found while listed: " + mrid);
        } else {
            this.revisions.put(module2.getId(), module2.getDescriptor());
            this.getAllRevisions(module2.getId()).add(module2.getDescriptor());
        }
        Message.progress();
    }

    private Collection<ModuleDescriptor> getAllRevisions(ModuleRevisionId id2) {
        Collection<ModuleDescriptor> revisions = this.modules.get(id2.getModuleId());
        if (revisions == null) {
            revisions = new TreeSet<ModuleDescriptor>(new Comparator<ModuleDescriptor>(){

                @Override
                public int compare(ModuleDescriptor md1, ModuleDescriptor md2) {
                    return RepositoryManagementEngine.this.settings.getDefaultLatestStrategy().sort(new ArtifactInfo[]{md1, md2}).get(0).equals(md1) ? 1 : -1;
                }
            });
            this.modules.put(id2.getModuleId(), revisions);
        }
        return revisions;
    }

    private ResolveData newResolveData() {
        return new ResolveData(this.resolveEngine, new ResolveOptions());
    }

    private void ensureAnalyzed() {
        if (!this.analyzed) {
            throw new IllegalStateException("repository must have been analyzed to perform this method");
        }
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("repository must have be loaded to perform this method");
        }
    }
}

