/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import libraries.collections.HashUtil;
import libraries.collections.LongSet;
import libraries.collections.MathUtil;
import libraries.collections.MutableLongIterator;
import libraries.collections.MutableLongSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0006\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0005$%&'(B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0019\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0011\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0002J\t\u0010\u001e\u001a\u00020\u001fH\u0096\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006)"}, d2={"Llibraries/collections/LongHashSet;", "Lkotlin/collections/AbstractMutableSet;", "", "Llibraries/collections/MutableLongSet;", "source", "Llibraries/collections/LongSet;", "(Llibraries/collections/LongSet;)V", "", "(Ljava/util/Collection;)V", "capacity", "", "loadFactor", "", "(IF)V", "mask", "<set-?>", "size", "getSize", "()I", "table", "", "Llibraries/collections/LongHashSet$Entry;", "[Llibraries/collections/LongHashSet$Entry;", "add", "", "element", "allocateTable", "", "length", "contains", "iterator", "Llibraries/collections/MutableLongIterator;", "rehash", "remove", "toLongArray", "", "AbstractHashSetIterator", "Companion", "Entry", "HashSetIterator", "RehashIterator", "libraries-collections"})
public final class LongHashSet
extends AbstractMutableSet<Long>
implements MutableLongSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float loadFactor;
    @NotNull
    private Entry[] table;
    private int capacity;
    private int size;
    private int mask;
    @NotNull
    private static final Entry[] hack = new Entry[0];

    public LongHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = hack;
        int proposedCapacity = capacity;
        if (proposedCapacity < 4) {
            proposedCapacity = 4;
        }
        this.allocateTable(HashUtil.INSTANCE.getCeilingPrime((int)((float)proposedCapacity / this.loadFactor)));
        this.capacity = proposedCapacity;
        this.size = 0;
    }

    public /* synthetic */ LongHashSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        this(n, f);
    }

    public int getSize() {
        return this.size;
    }

    public LongHashSet(@NotNull LongSet source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this(source2.size(), 0.0f, 2, null);
        Iterator iterator2 = source2.iterator();
        while (iterator2.hasNext()) {
            long element = ((Number)iterator2.next()).longValue();
            this.add(element);
        }
    }

    public LongHashSet(@NotNull Collection<Long> source2) {
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        this(source2.size(), 0.0f, 2, null);
        Iterator<Long> iterator2 = source2.iterator();
        while (iterator2.hasNext()) {
            long element = ((Number)iterator2.next()).longValue();
            this.add(element);
        }
    }

    @Override
    public boolean contains(long element) {
        Entry[] table = this.table;
        int index2 = HashUtil.INSTANCE.indexFor(element, table.length, this.mask);
        for (Entry e = table[index2]; e != null; e = e.getHashNext()) {
            if (e.getKey() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(long element) {
        Entry e;
        Entry[] table = this.table;
        int index2 = HashUtil.INSTANCE.indexFor(element, table.length, this.mask);
        LongHashSet $this$add_u24lambda_u240 = this;
        boolean bl = false;
        for (Entry e2 = table[index2]; e2 != null; e2 = e2.getHashNext()) {
            if (e2.getKey() != element) continue;
            return false;
        }
        table[index2] = e = new Entry(element, table[index2]);
        this.size = this.size() + 1;
        if (this.size() > this.capacity) {
            this.rehash(HashUtil.INSTANCE.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean remove(long element) {
        Entry[] table = this.table;
        int index2 = HashUtil.INSTANCE.indexFor(element, table.length, this.mask);
        Entry entry = table[index2];
        if (entry == null) {
            return false;
        }
        Entry e = entry;
        if (e.getKey() == element) {
            table[index2] = e.getHashNext();
        } else {
            Entry last;
            do {
                last = e;
                if (e.getHashNext() != null) continue;
                return false;
            } while (e.getKey() != element);
            last.setHashNext(e.getHashNext());
        }
        this.size = this.size() - 1;
        return true;
    }

    @NotNull
    public MutableLongIterator iterator() {
        return new HashSetIterator();
    }

    @Override
    @NotNull
    public long[] toLongArray() {
        if (this.size() == 0) {
            return LongSet.Companion.getEMPTY_ARRAY();
        }
        long[] result2 = new long[this.size()];
        int i = 0;
        MutableLongIterator itr = this.iterator();
        while (itr.hasNext()) {
            result2[i++] = itr.nextLong();
        }
        return result2;
    }

    private final void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.INSTANCE.integerLogarithm(this.table.length)) - 1;
    }

    private final void rehash(int capacity) {
        int length = HashUtil.INSTANCE.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator entries = new RehashIterator();
            this.allocateTable(length);
            Entry[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index2 = HashUtil.INSTANCE.indexFor(e.getKey(), length, mask);
                e.setHashNext(table[index2]);
                table[index2] = e;
            }
        }
    }

    public LongHashSet() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0012"}, d2={"Llibraries/collections/LongHashSet$AbstractHashSetIterator;", "T", "", "(Llibraries/collections/LongHashSet;)V", "e", "Llibraries/collections/LongHashSet$Entry;", "index", "", "last", "table", "", "[Llibraries/collections/LongHashSet$Entry;", "hasNext", "", "initNextEntry", "", "nextEntry", "remove", "libraries-collections"})
    private abstract class AbstractHashSetIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final Entry[] table;
        private int index;
        @Nullable
        private Entry e;
        @Nullable
        private Entry last;

        public AbstractHashSetIterator() {
            this.table = LongHashSet.this.table;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            Entry entry = this.last;
            if (entry == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            LongHashSet.this.remove((Object)entry.getKey());
            this.last = null;
        }

        @NotNull
        protected final Entry nextEntry() {
            Entry entry = this.last = this.e;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry result2 = entry;
            this.initNextEntry();
            return result2;
        }

        private final void initNextEntry() {
            Entry result2 = this.e;
            if (result2 != null) {
                result2 = result2.getHashNext();
            }
            Entry[] table = this.table;
            while (result2 == null && this.index < table.length) {
                int n = this.index;
                this.index = n + 1;
                result2 = table[n];
            }
            this.e = result2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Llibraries/collections/LongHashSet$Companion;", "", "()V", "hack", "", "Llibraries/collections/LongHashSet$Entry;", "[Llibraries/collections/LongHashSet$Entry;", "libraries-collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Llibraries/collections/LongHashSet$Entry;", "", "key", "", "hashNext", "(JLlibraries/collections/LongHashSet$Entry;)V", "getHashNext", "()Llibraries/collections/LongHashSet$Entry;", "setHashNext", "(Llibraries/collections/LongHashSet$Entry;)V", "getKey", "()J", "libraries-collections"})
    private static final class Entry {
        private final long key;
        @Nullable
        private Entry hashNext;

        public Entry(long key2, @Nullable Entry hashNext) {
            this.key = key2;
            this.hashNext = hashNext;
        }

        public final long getKey() {
            return this.key;
        }

        @Nullable
        public final Entry getHashNext() {
            return this.hashNext;
        }

        public final void setHashNext(@Nullable Entry entry) {
            this.hashNext = entry;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Llibraries/collections/LongHashSet$HashSetIterator;", "Llibraries/collections/LongHashSet$AbstractHashSetIterator;", "", "Llibraries/collections/LongHashSet;", "Llibraries/collections/MutableLongIterator;", "(Llibraries/collections/LongHashSet;)V", "next", "()Ljava/lang/Long;", "nextLong", "libraries-collections"})
    private final class HashSetIterator
    extends AbstractHashSetIterator<Long>
    implements MutableLongIterator {
        @Override
        @NotNull
        public Long next() {
            return this.nextEntry().getKey();
        }

        @Override
        public long nextLong() {
            return this.nextEntry().getKey();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0002H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Llibraries/collections/LongHashSet$RehashIterator;", "Llibraries/collections/LongHashSet$AbstractHashSetIterator;", "Llibraries/collections/LongHashSet$Entry;", "Llibraries/collections/LongHashSet;", "(Llibraries/collections/LongHashSet;)V", "next", "libraries-collections"})
    private final class RehashIterator
    extends AbstractHashSetIterator<Entry> {
        @Override
        @NotNull
        public Entry next() {
            return this.nextEntry();
        }
    }
}

