/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.web.flow.v2;

import circlet.rd.api.RdWorkspaceState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.space.gateway.SpaceKt;
import com.intellij.space.gateway.client.data.RdWorkspaceKt;
import com.intellij.space.gateway.connection.SpaceConnectionFlow;
import com.intellij.space.gateway.web.flow.v2.SpaceConnectionData;
import com.intellij.space.gateway.web.flow.v2.SpaceOpenInIdeConnectionHandle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnectionProvider;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import libraries.coroutines.extra.LifetimeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J/\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionProvider;", "Lcom/jetbrains/gateway/api/GatewayConnectionProvider;", "()V", "connections", "", "Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionData;", "requiredParams", "", "", "buildConnectionData", "parameters", "", "connect", "Lcom/jetbrains/gateway/api/GatewayConnectionHandle;", "requestor", "Lcom/jetbrains/gateway/api/ConnectionRequestor;", "(Ljava/util/Map;Lcom/jetbrains/gateway/api/ConnectionRequestor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "", "Companion", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceOpenInIdeConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceOpenInIdeConnectionProvider.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n10#2:84\n*S KotlinDebug\n*F\n+ 1 SpaceOpenInIdeConnectionProvider.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionProvider\n*L\n81#1:84\n*E\n"})
public final class SpaceOpenInIdeConnectionProvider
implements GatewayConnectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SpaceConnectionData> connections = new LinkedHashSet();
    @NotNull
    private final Set<String> requiredParams;
    @NotNull
    private static final Logger LOG;

    public SpaceOpenInIdeConnectionProvider() {
        Object[] objectArray = new String[]{"wsStatus", "wsNumber", "pKey", "pName", "ideTypeId", "ideBuild", "code"};
        this.requiredParams = SetsKt.setOf((Object[])objectArray);
    }

    public boolean isApplicable(@NotNull Map<String, String> parameters2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        return parameters2.keySet().contains("newui") && CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new String[]{"space", "rd-spinoff"})), (Object)parameters2.get("type")) && parameters2.keySet().containsAll((Collection)this.requiredParams);
    }

    @Nullable
    public Object connect(@NotNull Map<String, String> parameters2, @NotNull ConnectionRequestor requestor, @NotNull Continuation<? super GatewayConnectionHandle> $completion) {
        SpaceConnectionData connectionData = this.buildConnectionData(parameters2);
        if (connectionData == null) {
            Set missing = CollectionsKt.toMutableSet((Iterable)this.requiredParams);
            missing.removeAll((Collection)parameters2.keySet());
            LOG.info("Missing required params " + missing + " ");
            return null;
        }
        if (this.connections.contains(connectionData)) {
            LOG.info(connectionData + " is already started");
            return null;
        }
        LifetimeDefinition clientLifetime = new LifetimeDefinition();
        SpaceOpenInIdeConnectionHandle connectionHandle = new SpaceOpenInIdeConnectionHandle(clientLifetime, new SpaceConnectionFlow(LifetimeUtilsKt.nested(SpaceKt.spaceLifetime((Lifetime)clientLifetime)), connectionData, null, 4, null));
        CollectionExKt.addUnique((Collection)this.connections, (Lifetime)connectionHandle.getLifetime(), (Object)connectionData);
        return connectionHandle;
    }

    private final SpaceConnectionData buildConnectionData(Map<String, String> parameters2) {
        Integer n;
        String string2 = parameters2.get("workspaceId");
        if (string2 == null && (string2 = parameters2.get("wsId")) == null) {
            return null;
        }
        String workspaceId = string2;
        Object object = parameters2.get("wsNumber");
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int workspaceNumber = (Integer)object;
        String string3 = parameters2.get("wsStatus");
        if (string3 == null) {
            return null;
        }
        String workspaceStatus = string3;
        String string4 = parameters2.get("spaceInstance");
        if (string4 == null && (string4 = parameters2.get("apiUrl")) == null) {
            return null;
        }
        String server = string4;
        String string5 = parameters2.get("ideTypeId");
        if (string5 == null) {
            return null;
        }
        String ideTypeId = string5;
        String string6 = parameters2.get("ideBuild");
        if (string6 == null) {
            return null;
        }
        String ideBuild = string6;
        String string7 = parameters2.get("code");
        if (string7 == null) {
            return null;
        }
        String code = string7;
        String string8 = parameters2.get("pName");
        if (string8 == null) {
            return null;
        }
        String projectName2 = string8;
        String string9 = parameters2.get("pKey");
        if (string9 == null) {
            return null;
        }
        String projectKey = string9;
        Object object2 = parameters2.get("eta");
        Duration eta = object2 != null && (n = StringsKt.toIntOrNull((String)object2)) != null ? Duration.box-impl((long)DurationKt.toDuration((int)n, (DurationUnit)DurationUnit.SECONDS)) : null;
        object2 = RdWorkspaceKt.convertToDevEnvStatus(workspaceStatus);
        return new SpaceConnectionData(workspaceId, (RdWorkspaceState)object2, workspaceNumber, projectKey, projectName2, server, ideBuild, ideTypeId, code, eta, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SpaceOpenInIdeConnectionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.space.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

