/*
 * Decompiled with CFR 0.152.
 */
package circlet.documents;

import circlet.client.api.DocumentFolder;
import circlet.client.api.TD_MemberProfile;
import circlet.common.documents.FolderPermissions;
import circlet.documents.DocumentsCommonUtilsKt;
import circlet.platform.api.Ref;
import circlet.platform.api.RefResolver;
import circlet.platform.client.RefResolveKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001ak\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u0002H\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00040\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0012\u00a2\u0006\u0002\u0010\u0013\u001a;\u0010\u0014\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u0004*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u0002H\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00040\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"log", "Llibraries/klogging/KLogger;", "folderBreadcrumbsImpl", "", "T", "folder", "Lcirclet/client/api/DocumentFolder;", "inclusive", "", "refResolver", "Lcirclet/platform/api/RefResolver;", "meRef", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TD_MemberProfile;", "inaccessibleBreadcrumb", "breadcrumbBuilder", "Lkotlin/Function1;", "sharedWithMeBreadcrumbBuilder", "Lkotlin/Function0;", "(Lcirclet/client/api/DocumentFolder;ZLcirclet/platform/api/RefResolver;Lcirclet/platform/api/Ref;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/util/List;", "toBreadcrumb", "inaccessibeBreadcrumb", "(Lcirclet/client/api/DocumentFolder;Lcirclet/platform/api/RefResolver;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "app-state"})
@SourceDebugExtension(value={"SMAP\nbreadcrumbs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 breadcrumbs.kt\ncirclet/documents/BreadcrumbsKt\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,62:1\n14#2,5:63\n12#3:68\n*S KotlinDebug\n*F\n+ 1 breadcrumbs.kt\ncirclet/documents/BreadcrumbsKt\n*L\n27#1:63,5\n9#1:68\n*E\n"})
public final class BreadcrumbsKt {
    @NotNull
    private static final KLogger log;

    @NotNull
    public static final <T> List<T> folderBreadcrumbsImpl(@Nullable DocumentFolder folder, boolean inclusive, @NotNull RefResolver refResolver, @NotNull Ref<TD_MemberProfile> meRef, T inaccessibleBreadcrumb, @NotNull Function1<? super DocumentFolder, ? extends T> breadcrumbBuilder, @NotNull Function0<? extends T> sharedWithMeBreadcrumbBuilder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)refResolver, (String)"refResolver");
        Intrinsics.checkNotNullParameter(meRef, (String)"meRef");
        Intrinsics.checkNotNullParameter(breadcrumbBuilder, (String)"breadcrumbBuilder");
        Intrinsics.checkNotNullParameter(sharedWithMeBreadcrumbBuilder, (String)"sharedWithMeBreadcrumbBuilder");
        List breadcrumbs = new ArrayList();
        boolean previousBreadCrumbIsInaccessible = false;
        DocumentFolder currentFolder2 = null;
        DocumentFolder documentFolder = inclusive ? folder : ((object = folder) != null && (object = ((DocumentFolder)object).getParent()) != null ? (DocumentFolder)RefResolveKt.resolve(object) : (currentFolder2 = null));
        while (currentFolder2 != null) {
            KLogger this_$iv = log;
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                boolean bl = false;
                String msgStr$iv = "currentFolder = " + currentFolder2.getName();
                this_$iv.debug(msgStr$iv);
            }
            if (DocumentsCommonUtilsKt.isRootFolder(currentFolder2)) break;
            T breadcrumb = BreadcrumbsKt.toBreadcrumb(currentFolder2, refResolver, inaccessibleBreadcrumb, breadcrumbBuilder);
            if (!Intrinsics.areEqual(breadcrumb, inaccessibleBreadcrumb)) {
                if (previousBreadCrumbIsInaccessible) {
                    breadcrumbs.add(inaccessibleBreadcrumb);
                    previousBreadCrumbIsInaccessible = false;
                }
                breadcrumbs.add(breadcrumb);
            } else {
                previousBreadCrumbIsInaccessible = true;
            }
            Ref<DocumentFolder> ref2 = currentFolder2.getParent();
            currentFolder2 = ref2 != null ? RefResolveKt.resolve(ref2) : null;
        }
        DocumentFolder documentFolder2 = folder;
        List sharedWithMeIfNeeded = (documentFolder2 != null ? DocumentsCommonUtilsKt.isInPersonalSharedWithMe(documentFolder2, meRef, refResolver) : false) ? CollectionsKt.listOf((Object)sharedWithMeBreadcrumbBuilder.invoke()) : CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)sharedWithMeIfNeeded, (Iterable)CollectionsKt.reversed((Iterable)breadcrumbs));
    }

    public static /* synthetic */ List folderBreadcrumbsImpl$default(DocumentFolder documentFolder, boolean bl, RefResolver refResolver, Ref ref2, Object object, Function1 function1, Function0 function0, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return BreadcrumbsKt.folderBreadcrumbsImpl(documentFolder, bl, refResolver, ref2, object, function1, function0);
    }

    private static final <T> T toBreadcrumb(DocumentFolder $this$toBreadcrumb, RefResolver refResolver, T inaccessibeBreadcrumb, Function1<? super DocumentFolder, ? extends T> breadcrumbBuilder) {
        boolean canViewFolder = FolderPermissions.INSTANCE.canView(DocumentsCommonUtilsKt.permissionsChecker$default($this$toBreadcrumb, refResolver, null, 2, null));
        return (T)(canViewFolder ? breadcrumbBuilder.invoke((Object)$this$toBreadcrumb) : inaccessibeBreadcrumb);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$logger$iv;
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "documents/breadcrumbs.kt";
        boolean $i$f$logger = false;
        log = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
    }
}

