/*
 * Decompiled with CFR 0.152.
 */
package circlet.completion.mentions;

import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TD_Team;
import circlet.client.api.TeamDirectoryKt;
import circlet.common.mentions.MentionData;
import circlet.completion.mentions.MentionProvider;
import circlet.completion.mentions.MentionProvidersKt;
import circlet.completion.mentions.MentionTrie;
import circlet.completion.mentions.ProfileNamesResolverKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import libraries.collections.Trie;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0007\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcirclet/completion/mentions/MentionTrie;", "Llibraries/collections/Trie;", "Lcirclet/common/mentions/MentionData;", "()V", "findAll", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "text", "resolve", "clientView", "Companion", "Profile", "Team", "Lcirclet/completion/mentions/MentionTrie$Profile;", "Lcirclet/completion/mentions/MentionTrie$Team;", "app-state"})
@SourceDebugExtension(value={"SMAP\nProfileNamesResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileNamesResolver.kt\ncirclet/completion/mentions/MentionTrie\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,244:1\n1#2:245\n28#3,5:246\n*S KotlinDebug\n*F\n+ 1 ProfileNamesResolver.kt\ncirclet/completion/mentions/MentionTrie\n*L\n229#1:246,5\n*E\n"})
public abstract class MentionTrie
extends Trie<MentionData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(MentionTrie.class));

    private MentionTrie() {
        super(true);
    }

    @NotNull
    public final List<Pair<String, IntRange>> findAll(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List mentions2 = new ArrayList();
        List duplicatedMentions = new ArrayList();
        int maxTextLength = Math.min(text2.length(), 8192);
        Ref.IntRef index2 = new Ref.IntRef();
        while (index2.element < maxTextLength) {
            int stoppedAtIx;
            Trie.SearchPrefixResult searchPrefixResult;
            int n;
            if (text2.charAt(index2.element) != '@' || MentionTrie.findAll$isEscaped(index2, text2)) {
                n = index2.element;
                index2.element = n + 1;
                continue;
            }
            n = index2.element;
            index2.element = n + 1;
            Trie.SearchPrefixResult searchPrefixResult2 = searchPrefixResult = this.searchMaxPrefix(text2, index2.element, (Function1<Character, Boolean>)((Function1)findAll.1.INSTANCE));
            boolean bl = false;
            index2.element = stoppedAtIx = searchPrefixResult2.component1();
            Pair pair = searchPrefixResult.getResult();
            if (pair == null) continue;
            searchPrefixResult2 = pair;
            boolean bl2 = false;
            IntRange range3 = (IntRange)searchPrefixResult2.component1();
            List found = (List)searchPrefixResult2.component2();
            IntRange rangeWithAt = new IntRange(range3.getFirst() - 1, range3.getLast());
            if (found.size() > 1) {
                ((Collection)duplicatedMentions).add(StringsKt.substring((String)text2, (IntRange)rangeWithAt));
                continue;
            }
            ((Collection)mentions2).add(TuplesKt.to((Object)StringsKt.substring((String)text2, (IntRange)rangeWithAt), (Object)rangeWithAt));
        }
        if (!((Collection)duplicatedMentions).isEmpty()) {
            KLogger this_$iv = log;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                boolean bl = false;
                String msgStr$iv = "For " + text2 + " found duplicates " + CollectionsKt.joinToString$default((Iterable)duplicatedMentions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                this_$iv.warn(msgStr$iv);
            }
        }
        return mentions2;
    }

    @Nullable
    public final MentionData resolve(@NotNull String clientView2) {
        Intrinsics.checkNotNullParameter((Object)clientView2, (String)"clientView");
        return (MentionData)CollectionsKt.singleOrNull(this.resolveName(clientView2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findAll$isEscaped(Ref.IntRef index2, String $text) {
        if (index2.element - 1 < 0) return false;
        Character c = Character.valueOf($text.charAt(index2.element - 1));
        Character prev = c;
        if (prev == null) return false;
        char c2 = '\\';
        if (prev.charValue() != c2) return false;
        return true;
    }

    public /* synthetic */ MentionTrie(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcirclet/completion/mentions/MentionTrie$Companion;", "", "()V", "log", "Llibraries/klogging/KLogger;", "getLog", "()Llibraries/klogging/KLogger;", "app-state"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcirclet/completion/mentions/MentionTrie$Profile;", "Lcirclet/completion/mentions/MentionTrie;", "()V", "put", "", "profile", "Lcirclet/client/api/TD_MemberProfile;", "remove", "data", "Lcirclet/common/mentions/MentionData;", "app-state"})
    @SourceDebugExtension(value={"SMAP\nProfileNamesResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileNamesResolver.kt\ncirclet/completion/mentions/MentionTrie$Profile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1855#2,2:245\n1855#2,2:247\n*S KotlinDebug\n*F\n+ 1 ProfileNamesResolver.kt\ncirclet/completion/mentions/MentionTrie$Profile\n*L\n163#1:245,2\n172#1:247,2\n*E\n"})
    public static final class Profile
    extends MentionTrie {
        public Profile() {
            super(null);
        }

        public final void put(@NotNull TD_MemberProfile profile2) {
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            MentionData mention = this.data(profile2);
            if (mention != null) {
                Iterable $this$forEach$iv = ProfileNamesResolverKt.mentionVariations(profile2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    this.putName(it, mention);
                }
            }
        }

        public final void remove(@NotNull TD_MemberProfile profile2) {
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            MentionData mention = this.data(profile2);
            if (mention != null) {
                Iterable $this$forEach$iv = ProfileNamesResolverKt.mentionVariations(profile2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    this.removeName(it, mention);
                }
            }
        }

        private final MentionData data(TD_MemberProfile $this$data) {
            return ((MentionProvider)MapsKt.getValue(MentionProvidersKt.getMention_providers(), (Object)"p")).data($this$data.getId(), $this$data.getUsername(), TeamDirectoryKt.englishFullName($this$data));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcirclet/completion/mentions/MentionTrie$Team;", "Lcirclet/completion/mentions/MentionTrie;", "()V", "put", "", "team", "Lcirclet/client/api/TD_Team;", "remove", "data", "Lcirclet/common/mentions/MentionData;", "app-state"})
    public static final class Team
    extends MentionTrie {
        public Team() {
            super(null);
        }

        public final void put(@NotNull TD_Team team2) {
            Intrinsics.checkNotNullParameter((Object)team2, (String)"team");
            MentionData mention = this.data(team2);
            if (mention != null) {
                this.putName(team2.getName(), mention);
            }
        }

        public final void remove(@NotNull TD_Team team2) {
            Intrinsics.checkNotNullParameter((Object)team2, (String)"team");
            MentionData mention = this.data(team2);
            if (mention != null) {
                this.removeName(team2.getName(), mention);
            }
        }

        private final MentionData data(TD_Team $this$data) {
            return MentionProvider.DefaultImpls.data$default((MentionProvider)MapsKt.getValue(MentionProvidersKt.getMention_providers(), (Object)"t"), $this$data.getId(), $this$data.getName(), null, 4, null);
        }
    }
}

