/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValidatorImpl
extends ParserConfigurationSettings
implements Validator,
ContentHandler,
DTDHandler,
XMLLocator,
XMLEntityResolver,
EntityState {
    private final XMLSchemaValidator schemaValidator = new XMLSchemaValidator();
    private final XMLErrorReporter errorReporter = new XMLErrorReporter();
    private final ValidationManager validationManager = new ValidationManager();
    private final NamespaceContext namespaceContext = new NamespaceSupport();
    private final XMLAttributes attributes = new XMLAttributesImpl();
    private final SymbolTable symbolTable;
    private final XMLComponent[] components;
    private Locator locator;
    private final Hashtable entityTable = new Hashtable();
    private boolean pushedContext = false;
    private static final String[] recognizedFeatures = new String[]{"http://apache.org/xml/features/validation/schema/augment-psvi", "http://apache.org/xml/features/validation/schema-full-checking", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema"};
    private static final String[] recognizedProperties = new String[]{"http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/entity-resolver"};

    ValidatorImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, PropertyMap propertyMap) {
        this.symbolTable = symbolTable;
        ErrorHandlerWrapper errorHandlerWrapper = new ErrorHandlerWrapper(ValidateProperty.ERROR_HANDLER.get(propertyMap));
        this.components = new XMLComponent[]{this.errorReporter, this.schemaValidator};
        int n = 0;
        while (n < this.components.length) {
            this.addRecognizedFeatures(this.components[n].getRecognizedFeatures());
            this.addRecognizedProperties(this.components[n].getRecognizedProperties());
            ++n;
        }
        this.addRecognizedFeatures(recognizedFeatures);
        this.addRecognizedProperties(recognizedProperties);
        this.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", false);
        this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPool);
        this.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        this.errorReporter.setDocumentLocator((XMLLocator)this);
        this.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.errorReporter);
        this.setProperty("http://apache.org/xml/properties/internal/error-handler", errorHandlerWrapper);
        this.setProperty("http://apache.org/xml/properties/internal/validation-manager", this.validationManager);
        this.setProperty("http://apache.org/xml/properties/internal/entity-manager", this);
        this.setProperty("http://apache.org/xml/properties/internal/entity-resolver", this);
        this.reset();
    }

    public void reset() {
        this.validationManager.reset();
        this.namespaceContext.reset();
        int n = 0;
        while (n < this.components.length) {
            this.components[n].reset((XMLComponentManager)this);
            ++n;
        }
        this.validationManager.setEntityState((EntityState)this);
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void notationDecl(String string2, String string3, String string4) {
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) {
        this.entityTable.put(string2, string2);
    }

    public boolean isEntityDeclared(String string2) {
        return this.entityTable.get(string2) != null;
    }

    public boolean isEntityUnparsed(String string2) {
        return this.entityTable.get(string2) != null;
    }

    public void startDocument() throws SAXException {
        try {
            this.schemaValidator.startDocument((XMLLocator)(this.locator == null ? null : this), null, this.namespaceContext, null);
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.schemaValidator.endDocument(null);
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
            } else {
                this.pushedContext = false;
            }
            int n = 0;
            int n2 = attributes.getLength();
            while (n < n2) {
                this.attributes.addAttribute(this.makeQName(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n)), this.symbolTable.addSymbol(attributes.getType(n)), attributes.getValue(n));
                ++n;
            }
            this.schemaValidator.startElement(this.makeQName(string2, string3, string4), this.attributes, null);
            this.attributes.removeAllAttributes();
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.schemaValidator.endElement(this.makeQName(string2, string3, string4), null);
            this.namespaceContext.popContext();
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        try {
            if (!this.pushedContext) {
                this.namespaceContext.pushContext();
                this.pushedContext = true;
            }
            string2 = string2 == null ? XMLSymbols.EMPTY_STRING : this.symbolTable.addSymbol(string2);
            if (string3 != null) {
                string3 = string3.equals("") ? null : this.symbolTable.addSymbol(string3);
            }
            this.namespaceContext.declarePrefix(string2, string3);
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void endPrefixMapping(String string2) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.schemaValidator.characters(new XMLString(cArray, n, n2), null);
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.schemaValidator.ignorableWhitespace(new XMLString(cArray, n, n2), null);
        }
        catch (XNIException xNIException) {
            throw ValidatorImpl.toSAXException(xNIException);
        }
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    private QName makeQName(String string2, String string3, String string4) {
        String string5;
        string3 = this.symbolTable.addSymbol(string3);
        if (string2.equals("")) {
            string2 = null;
            string5 = XMLSymbols.EMPTY_STRING;
            string4 = string3;
        } else {
            string2 = this.symbolTable.addSymbol(string2);
            if (string4.equals("")) {
                string5 = this.namespaceContext.getPrefix(string2);
                string4 = string5 == XMLSymbols.EMPTY_STRING ? string3 : (string5 == null ? string3 : this.symbolTable.addSymbol(string5 + ":" + string3));
            } else {
                int n = (string4 = this.symbolTable.addSymbol(string4)).indexOf(58);
                string5 = n > 0 ? this.symbolTable.addSymbol(string4.substring(0, n)) : XMLSymbols.EMPTY_STRING;
            }
        }
        return new QName(string5, string3, string4, string2);
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        return null;
    }

    public String getPublicId() {
        return this.locator.getPublicId();
    }

    public String getEncoding() {
        return null;
    }

    public String getBaseSystemId() {
        return null;
    }

    public String getLiteralSystemId() {
        return null;
    }

    public String getExpandedSystemId() {
        return this.locator.getSystemId();
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    static SAXException toSAXException(XNIException xNIException) {
        if (xNIException instanceof XMLParseException) {
            XMLParseException xMLParseException = (XMLParseException)xNIException;
            return new SAXParseException(xMLParseException.getMessage(), xMLParseException.getPublicId(), xMLParseException.getExpandedSystemId(), xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getException());
        }
        Exception exception = xNIException.getException();
        if (exception == null) {
            return new SAXException(xNIException.getMessage());
        }
        if (exception instanceof SAXException) {
            return (SAXException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        return new SAXException(exception);
    }
}

