/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details.commit;

import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;

    public ReferencesPanel(int limit) {
        this((LayoutManager)new WrappedFlowLayout(JBUIScale.scale((int)4), JBUIScale.scale((int)0)), limit);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        if (references == null) {
            ReferencesPanel.$$$reportNull$$$0(0);
        }
        if (this.myReferences.equals(references)) {
            return;
        }
        this.myReferences = references;
        List visibleReferences = this.myRefsLimit > 0 ? ContainerUtil.getFirstItems(this.myReferences, (int)this.myRefsLimit) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy((Iterable)visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type2 = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon2 = this.createIcon(type2, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text2 = reference.getName() + ending;
                JBLabel label2 = this.createLabel(text2, icon2);
                if (firstLabel == null) {
                    firstLabel = label2;
                    this.add((Component)label2);
                } else {
                    this.addWrapped(label2, firstLabel);
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label3 = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label3, Objects.requireNonNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        JBLabel jBLabel = this.createLabel(VcsLogBundle.message("vcs.log.details.references.more.label", restSize), null);
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(1);
        }
        return jBLabel;
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type2, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (type2 == null) {
            ReferencesPanel.$$$reportNull$$$0(2);
        }
        if (refs == null) {
            ReferencesPanel.$$$reportNull$$$0(3);
        }
        if (refIndex == 0) {
            Color color = type2.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? List.of(color, color) : Collections.singletonList(color));
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label2, @NotNull JBLabel referent) {
        if (label2 == null) {
            ReferencesPanel.$$$reportNull$$$0(4);
        }
        if (referent == null) {
            ReferencesPanel.$$$reportNull$$$0(5);
        }
        Wrapper wrapper = new Wrapper((JComponent)label2);
        wrapper.setVerticalSizeReferent((JComponent)referent);
        this.add((Component)wrapper);
    }

    @NotNull
    protected JBLabel createLabel(@Nls @NotNull String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            ReferencesPanel.$$$reportNull$$$0(6);
        }
        JBLabel label2 = new JBLabel(text2, icon2, 2);
        label2.setFont(this.getLabelsFont());
        label2.setIconTextGap(0);
        label2.setHorizontalAlignment(2);
        label2.setVerticalTextPosition(0);
        label2.setCopyable(true);
        JBLabel jBLabel = label2;
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(7);
        }
        return jBLabel;
    }

    @NotNull
    protected Font getLabelsFont() {
        Font font = FontUtil.getCommitMetadataFont();
        if (font == null) {
            ReferencesPanel.$$$reportNull$$$0(8);
        }
        return font;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitDetailsPanelKt.getCommitDetailsBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/details/commit/ReferencesPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/details/commit/ReferencesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReferences";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWrapped";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

