/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEntityRefImpl
extends XmlElementImpl
implements XmlEntityRef {
    @NonNls
    private static final String GT_ENTITY = "&gt;";
    @NonNls
    private static final String QUOT_ENTITY = "&quot;";

    public XmlEntityRefImpl() {
        super(XmlElementType.XML_ENTITY_REF);
    }

    @Override
    public XmlEntityDecl resolve(PsiFile targetFile) {
        String text2 = this.getText();
        if (text2.equals(GT_ENTITY) || text2.equals(QUOT_ENTITY)) {
            return null;
        }
        return XmlEntityRefImpl.resolveEntity(this, text2, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl resolveEntity(XmlElement element, String text2, PsiFile targetFile) {
        CachedValue value2;
        String entityName = text2.substring(1, text2.length() - 1);
        Object targetElement = targetFile != null ? targetFile : element;
        Object object = XmlEntityCache.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> map2 = XmlEntityCache.getCachingMap((PsiElement)targetElement);
            value2 = map2.get(entityName);
            PsiFile containingFile = element.getContainingFile();
            if (value2 == null) {
                PsiManager manager = element.getManager();
                if (manager == null) {
                    return (XmlEntityDecl)XmlEntityRefImpl.doResolveEntity((PsiElement)targetElement, entityName, containingFile).getValue();
                }
                value2 = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> XmlEntityRefImpl.lambda$resolveEntity$0((PsiElement)targetElement, entityName, containingFile), true);
                map2.put(entityName, (CachedValue<XmlEntityDecl>)value2);
            }
        }
        return (XmlEntityDecl)value2.getValue();
    }

    private static CachedValueProvider.Result<XmlEntityDecl> doResolveEntity(final PsiElement targetElement, final String entityName, final PsiFile contextFile) {
        return (CachedValueProvider.Result)RecursionManager.doPreventingRecursion((Object)targetElement, (boolean)true, (Computable)new Computable<CachedValueProvider.Result<XmlEntityDecl>>(){

            public CachedValueProvider.Result<XmlEntityDecl> compute() {
                final ArrayList<PsiFile> deps = new ArrayList<PsiFile>();
                final XmlEntityDecl[] result2 = new XmlEntityDecl[]{null};
                PsiElementProcessor<PsiElement> processor2 = new PsiElementProcessor<PsiElement>(){

                    public boolean execute(@NotNull PsiElement element) {
                        XmlEntityDecl entityDecl;
                        String declName;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof XmlDoctype) {
                            XmlMarkupDecl markupDecl;
                            XmlDoctype xmlDoctype = (XmlDoctype)element;
                            String dtdUri = XmlEntityRefImpl.getDtdForEntity(xmlDoctype);
                            if (dtdUri != null) {
                                XmlFile file = XmlUtil.getContainingFile(element);
                                if (file == null) {
                                    return true;
                                }
                                XmlFile xmlFile = XmlUtil.findNamespace(file, dtdUri);
                                if (xmlFile != null && xmlFile != targetElement) {
                                    deps.add(xmlFile);
                                    if (!XmlUtil.processXmlElements(xmlFile, this, true)) {
                                        return false;
                                    }
                                }
                            }
                            if ((markupDecl = xmlDoctype.getMarkupDecl()) != null && !XmlUtil.processXmlElements(markupDecl, this, true)) {
                                return false;
                            }
                        } else if (element instanceof XmlEntityDecl && StringUtil.equals((CharSequence)(declName = (entityDecl = (XmlEntityDecl)element).getName()), (CharSequence)entityName)) {
                            result2[0] = entityDecl;
                            deps.add(entityDecl.getContainingFile());
                            return false;
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlEntityRefImpl$1$1", "execute"));
                    }
                };
                FileViewProvider provider = targetElement.getContainingFile().getViewProvider();
                deps.add(provider.getPsi(provider.getBaseLanguage()));
                boolean notfound = PsiTreeUtil.processElements((PsiElement)targetElement, (PsiElementProcessor)processor2);
                if (notfound && contextFile != targetElement && contextFile != null && contextFile.isValid()) {
                    notfound = PsiTreeUtil.processElements((PsiElement)contextFile, (PsiElementProcessor)processor2);
                }
                if (notfound && targetElement instanceof XmlFile && deps.size() == 1 && ((XmlFile)targetElement).getFileType() != DTDFileType.INSTANCE) {
                    for (XmlFile descriptorFile : XmlExtension.getExtension((XmlFile)targetElement).getCharEntitiesDTDs((XmlFile)targetElement)) {
                        if (descriptorFile.getName().equals(((XmlFile)targetElement).getName() + ".dtd")) continue;
                        deps.add(descriptorFile);
                        if (XmlUtil.processXmlElements(descriptorFile, (PsiElementProcessor<? super PsiElement>)processor2, true)) continue;
                        break;
                    }
                }
                return new CachedValueProvider.Result((Object)result2[0], ArrayUtil.toObjectArray(deps));
            }
        });
    }

    private static String getDtdForEntity(XmlDoctype xmlDoctype) {
        return HtmlUtil.isHtml5Doctype(xmlDoctype) ? Html5SchemaProvider.getCharsDtdLocation() : XmlUtil.getDtdUri(xmlDoctype);
    }

    @Override
    public XmlTag getParentTag() {
        XmlElement parent = (XmlElement)this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    @Override
    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    @Override
    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            XmlEntityRefImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlEntityRefImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlElement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$resolveEntity$0(PsiElement targetElement, String entityName, PsiFile containingFile) {
        return XmlEntityRefImpl.doResolveEntity(targetElement, entityName, containingFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlEntityRefImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlEntityRefImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

