/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupportKt;
import com.intellij.openapi.vcs.changes.ui.DefaultChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0003+,-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00062\u000b\u0010\"\u001a\u00070\n\u00a2\u0006\u0002\b#H\u0086\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\nH\u0016J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0019\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0006H\u0087\u0002J\u0016\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0*H\u0007R4\u0010\b\u001a(\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b \r*\u0012\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "", "project", "Lcom/intellij/openapi/project/Project;", "source", "showConflictsNode", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Z)V", "_groupingKeys", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "changeSupport", "Ljava/beans/PropertyChangeSupport;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "getGrouping", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "groupingKeys", "getGroupingKeys", "()Ljava/util/Set;", "isDirectory", "()Z", "isNone", "getProject", "()Lcom/intellij/openapi/project/Project;", "getShowConflictsNode", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "get", "groupingKey", "Lorg/jetbrains/annotations/NonNls;", "isAvailable", "removePropertyChangeListener", "set", "state", "setGroupingKeysOrSkip", "newGroupingKeys", "", "CombinedGroupingPolicyFactory", "Companion", "Disabled", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n766#2:126\n857#2,2:127\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport\n*L\n56#1:126\n56#1:127,2\n*E\n"})
public class ChangesGroupingSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean showConflictsNode;
    @NotNull
    private final PropertyChangeSupport changeSupport;
    @NotNull
    private final Set<String> _groupingKeys;
    @JvmField
    @NotNull
    public static final DataKey<ChangesGroupingSupport> KEY;
    @NotNull
    public static final String PROP_GROUPING_KEYS = "ChangesGroupingKeys";
    @NotNull
    public static final String DIRECTORY_GROUPING = "directory";
    @NotNull
    public static final String MODULE_GROUPING = "module";
    @NotNull
    public static final String REPOSITORY_GROUPING = "repository";
    @NotNull
    public static final String NONE_GROUPING = "none";
    @NotNull
    private static final ClearableLazyValue<Map<String, ChangesGroupingPolicyFactory>> FACTORIES;

    public ChangesGroupingSupport(@NotNull Project project2, @NotNull Object source2, boolean showConflictsNode) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.project = project2;
        this.showConflictsNode = showConflictsNode;
        this.changeSupport = new PropertyChangeSupport(source2);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this._groupingKeys = set;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getShowConflictsNode() {
        return this.showConflictsNode;
    }

    @NotNull
    public final Set<String> getGroupingKeys() {
        return CollectionsKt.toSet((Iterable)this._groupingKeys);
    }

    public final boolean get(@NotNull String groupingKey) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            return false;
        }
        return this._groupingKeys.contains(groupingKey);
    }

    @RequiresEdt
    public final void set(@NotNull String groupingKey, boolean state) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            throw new IllegalArgumentException("Unknown grouping " + groupingKey);
        }
        boolean currentState = this._groupingKeys.contains(groupingKey);
        if (currentState == state) {
            return;
        }
        Set oldGroupingKeys = CollectionsKt.toSet((Iterable)this._groupingKeys);
        if (state) {
            ((Collection)this._groupingKeys).add(groupingKey);
        } else {
            ((Collection)this._groupingKeys).remove(groupingKey);
        }
        this.changeSupport.firePropertyChange(PROP_GROUPING_KEYS, oldGroupingKeys, CollectionsKt.toSet((Iterable)this._groupingKeys));
    }

    @NotNull
    public final ChangesGroupingPolicyFactory getGrouping() {
        return new CombinedGroupingPolicyFactory();
    }

    public final boolean isNone() {
        return this._groupingKeys.isEmpty();
    }

    public final boolean isDirectory() {
        return this.get(DIRECTORY_GROUPING);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void setGroupingKeysOrSkip(@NotNull Collection<String> newGroupingKeys) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(newGroupingKeys, (String)"newGroupingKeys");
        this._groupingKeys.clear();
        Collection collection = this._groupingKeys;
        Iterable $this$filter$iv = newGroupingKeys;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String groupingKey = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isAvailable(groupingKey)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
    }

    public boolean isAvailable(@NotNull String groupingKey) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        return Companion.findFactory(groupingKey) != null;
    }

    public final void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.changeSupport.addPropertyChangeListener(listener2);
    }

    public final void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.changeSupport.removePropertyChangeListener(listener2);
    }

    private static final Map FACTORIES$lambda$1() {
        return ChangesGroupingSupport.Companion.buildFactories();
    }

    private static final void _init_$lambda$2() {
        FACTORIES.drop();
    }

    @JvmStatic
    @NotNull
    public static final ChangesGroupingPolicyFactory getFactory(@NotNull String key2) {
        return Companion.getFactory(key2);
    }

    @JvmStatic
    @Nullable
    public static final ChangesGroupingPolicyFactory findFactory(@NotNull String key2) {
        return Companion.findFactory(key2);
    }

    static {
        DataKey dataKey = DataKey.create((String)"ChangesTree.GroupingSupport");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
        ClearableLazyValue clearableLazyValue = ClearableLazyValue.create(ChangesGroupingSupport::FACTORIES$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"create(...)");
        FACTORIES = clearableLazyValue;
        ChangesGroupingPolicyFactory.EP_NAME.addChangeListener(ChangesGroupingSupport::_init_$lambda$2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;)V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1054#2:126\n1855#2:127\n1856#2:129\n1#3:128\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory\n*L\n72#1:126\n72#1:127\n72#1:129\n*E\n"})
    private final class CombinedGroupingPolicyFactory
    extends ChangesGroupingPolicyFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            result2.element = new DefaultChangesGroupingPolicy.Factory(ChangesGroupingSupport.this.getShowConflictsNode()).createGroupingPolicy(project2, model2);
            Iterable $this$sortedByDescending$iv = ChangesGroupingSupport.this._groupingKeys;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    String it = (String)b;
                    boolean bl = false;
                    Comparable comparable = (Integer)ChangesGroupingSupportKt.access$getPREDEFINED_PRIORITIES$p().get(it);
                    it = (String)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)ChangesGroupingSupportKt.access$getPREDEFINED_PRIORITIES$p().get(it)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$createGroupingPolicy_u24lambda_u242_u24lambda_u241;
                ChangesGroupingPolicy changesGroupingPolicy;
                ChangesGroupingPolicyFactory factory;
                String groupingKey = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)groupingKey);
                if (Companion.findFactory(groupingKey) == null) {
                    throw new IllegalArgumentException("Unknown grouping " + groupingKey);
                }
                Intrinsics.checkNotNullExpressionValue((Object)factory.createGroupingPolicy(project2, model2), (String)"createGroupingPolicy(...)");
                ChangesGroupingPolicy changesGroupingPolicy2 = changesGroupingPolicy;
                Ref.ObjectRef objectRef = result2;
                boolean bl2 = false;
                $this$createGroupingPolicy_u24lambda_u242_u24lambda_u241.setNextGroupingPolicy((ChangesGroupingPolicy)result2.element);
                objectRef.element = changesGroupingPolicy;
            }
            return (ChangesGroupingPolicy)result2.element;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R9\u0010\u0005\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion;", "", "()V", "DIRECTORY_GROUPING", "", "FACTORIES", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "MODULE_GROUPING", "NONE_GROUPING", "PROP_GROUPING_KEYS", "REPOSITORY_GROUPING", "buildFactories", "findFactory", "key", "getFactory", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n10#2:126\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion\n*L\n119#1:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChangesGroupingPolicyFactory getFactory(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.findFactory(key2);
            if (changesGroupingPolicyFactory == null) {
                changesGroupingPolicyFactory = NoneChangesGroupingFactory.INSTANCE;
            }
            return changesGroupingPolicyFactory;
        }

        @JvmStatic
        @Nullable
        public final ChangesGroupingPolicyFactory findFactory(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            return (ChangesGroupingPolicyFactory)((Map)FACTORIES.getValue()).get(key2);
        }

        private final Map<String, ChangesGroupingPolicyFactory> buildFactories() {
            Map result2 = new LinkedHashMap();
            for (KeyedFactoryEPBean bean : ChangesGroupingPolicyFactory.EP_NAME.getExtensionList()) {
                if (bean.key == null || bean.implementationClass == null) continue;
                try {
                    Object object;
                    String key2;
                    String clazz;
                    Map map2 = result2;
                    Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().instantiateClass(clazz, bean.getPluginDescriptor()), (String)"instantiateClass(...)");
                    map2.put(key2, object);
                }
                catch (Throwable e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ChangesGroupingSupport.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(e);
                }
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Disabled;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "source", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "isAvailable", "", "groupingKey", "", "intellij.platform.vcs.impl"})
    public static final class Disabled
    extends ChangesGroupingSupport {
        public Disabled(@NotNull Project project2, @NotNull Object source2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            super(project2, source2, false);
        }

        @Override
        public boolean isAvailable(@NotNull String groupingKey) {
            Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
            return false;
        }
    }
}

