/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowChangeMarkerAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Data data2;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(0);
        }
        boolean isEnabled = (data2 = ShowChangeMarkerAction.getDataFromContext(e)) != null && data2.tracker.isValid() && data2.tracker.isAvailableAt(data2.editor) && this.getTargetRange(data2.tracker, data2.editor) != null;
        e.getPresentation().setEnabled(isEnabled);
        e.getPresentation().setVisible(data2 != null || e.isFromActionToolbar());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Data data2;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(2);
        }
        if ((data2 = ShowChangeMarkerAction.getDataFromContext(e)) == null) {
            return;
        }
        Range targetRange = this.getTargetRange(data2.tracker, data2.editor);
        if (targetRange == null) {
            return;
        }
        this.moveToRange(data2.tracker, data2.editor, targetRange);
    }

    @Nullable
    private static Data getDataFromContext(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(3);
        }
        if ((project2 = e.getProject()) == null) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(editor.getDocument());
        if (tracker == null) {
            return null;
        }
        return new Data(tracker, editor);
    }

    protected void moveToRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor, @NotNull Range range) {
        if (tracker == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(5);
        }
        if (range == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(6);
        }
        tracker.scrollAndShowHint(range, editor);
    }

    @Nullable
    private Range getTargetRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(8);
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        return this.getTargetRange(tracker, line);
    }

    @Nullable
    protected abstract Range getTargetRange(@NotNull LineStatusTracker<?> var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveToRange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class Data {
        @NotNull
        private final LineStatusTracker<?> tracker;
        @NotNull
        private final Editor editor;

        Data(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor) {
            if (tracker == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.tracker = tracker;
            this.editor = editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Current
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Current.$$$reportNull$$$0(0);
            }
            return tracker.getRangeForLine(line);
        }

        @Override
        protected void moveToRange(@NotNull LineStatusTracker<?> tracker, @NotNull Editor editor, @NotNull Range range) {
            if (tracker == null) {
                Current.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                Current.$$$reportNull$$$0(2);
            }
            if (range == null) {
                Current.$$$reportNull$$$0(3);
            }
            tracker.showHint(range, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Current";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Prev
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Prev.$$$reportNull$$$0(0);
            }
            return tracker.getPrevRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Prev", "getTargetRange"));
        }
    }

    public static class Next
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker, int line) {
            if (tracker == null) {
                Next.$$$reportNull$$$0(0);
            }
            return tracker.getNextRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Next", "getTargetRange"));
        }
    }
}

