/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.util.SmartList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/requests/RequestStatus;", "", "statuses", "", "Lcom/jetbrains/rdclient/requests/RequestStatus$Companion$Status;", "([Lcom/jetbrains/rdclient/requests/RequestStatus$Companion$Status;)V", "flags", "Lcom/intellij/util/SmartList;", "kotlin.jvm.PlatformType", "cancel", "isCancelled", "", "isCompleted", "isExecuting", "isPending", "isReverted", "revert", "toString", "", "undoRevert", "Companion", "intellij.rd.client"})
public final class RequestStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartList<Companion.Status> flags;
    @NotNull
    private static final RequestStatus PENDING;
    @NotNull
    private static final RequestStatus EXECUTING;
    @NotNull
    private static final RequestStatus COMPLETED;
    @NotNull
    private static final RequestStatus REVERTED_PENDING;
    @NotNull
    private static final RequestStatus REVERTED_EXECUTING;
    @NotNull
    private static final RequestStatus CANCELLED_PENDING;
    @NotNull
    private static final RequestStatus CANCELLED_EXECUTING;
    @NotNull
    private static final RequestStatus CANCELLED_COMPLETED;

    private RequestStatus(Companion.Status ... statuses) {
        this.flags = new SmartList((Object[])Arrays.copyOf(statuses, statuses.length));
    }

    public final boolean isPending() {
        return this.flags.contains((Object)Companion.Status.Pending);
    }

    public final boolean isExecuting() {
        return this.flags.contains((Object)Companion.Status.Executing);
    }

    public final boolean isCompleted() {
        return this.flags.contains((Object)Companion.Status.Completed);
    }

    public final boolean isCancelled() {
        return this.flags.contains((Object)Companion.Status.Cancelled);
    }

    public final boolean isReverted() {
        return this.flags.contains((Object)Companion.Status.Reverted);
    }

    @NotNull
    public final RequestStatus revert() {
        RequestStatus requestStatus;
        if (Intrinsics.areEqual((Object)this, (Object)PENDING)) {
            requestStatus = REVERTED_PENDING;
        } else if (Intrinsics.areEqual((Object)this, (Object)EXECUTING)) {
            requestStatus = REVERTED_EXECUTING;
        } else {
            throw new IllegalStateException(("revert is supported only for " + PENDING + " and " + EXECUTING + ", but got " + this).toString());
        }
        return requestStatus;
    }

    @NotNull
    public final RequestStatus undoRevert() {
        RequestStatus requestStatus;
        if (Intrinsics.areEqual((Object)this, (Object)REVERTED_PENDING)) {
            requestStatus = PENDING;
        } else if (Intrinsics.areEqual((Object)this, (Object)REVERTED_EXECUTING)) {
            requestStatus = EXECUTING;
        } else {
            throw new IllegalStateException(("undo of revert is supported only for reverted status, but got " + this).toString());
        }
        return requestStatus;
    }

    @NotNull
    public final RequestStatus cancel() {
        RequestStatus requestStatus;
        if (Intrinsics.areEqual((Object)this, (Object)PENDING)) {
            requestStatus = CANCELLED_PENDING;
        } else if (Intrinsics.areEqual((Object)this, (Object)EXECUTING)) {
            requestStatus = CANCELLED_EXECUTING;
        } else if (Intrinsics.areEqual((Object)this, (Object)COMPLETED)) {
            requestStatus = CANCELLED_COMPLETED;
        } else {
            throw new IllegalStateException(("cancel is supported only for " + PENDING + ", " + EXECUTING + ", " + COMPLETED + ", but got " + this).toString());
        }
        return requestStatus;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)this.flags), (CharSequence)" & ", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        Companion.Status[] statusArray = new Companion.Status[]{Companion.Status.Pending};
        PENDING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Executing};
        EXECUTING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Completed};
        COMPLETED = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Reverted, Companion.Status.Pending};
        REVERTED_PENDING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Reverted, Companion.Status.Executing};
        REVERTED_EXECUTING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Cancelled, Companion.Status.Pending};
        CANCELLED_PENDING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Cancelled, Companion.Status.Executing};
        CANCELLED_EXECUTING = new RequestStatus(statusArray);
        statusArray = new Companion.Status[]{Companion.Status.Cancelled, Companion.Status.Completed};
        CANCELLED_COMPLETED = new RequestStatus(statusArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/requests/RequestStatus$Companion;", "", "()V", "CANCELLED_COMPLETED", "Lcom/jetbrains/rdclient/requests/RequestStatus;", "getCANCELLED_COMPLETED", "()Lcom/jetbrains/rdclient/requests/RequestStatus;", "CANCELLED_EXECUTING", "getCANCELLED_EXECUTING", "CANCELLED_PENDING", "getCANCELLED_PENDING", "COMPLETED", "getCOMPLETED", "EXECUTING", "getEXECUTING", "PENDING", "getPENDING", "REVERTED_EXECUTING", "getREVERTED_EXECUTING", "REVERTED_PENDING", "getREVERTED_PENDING", "Status", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RequestStatus getPENDING() {
            return PENDING;
        }

        @NotNull
        public final RequestStatus getEXECUTING() {
            return EXECUTING;
        }

        @NotNull
        public final RequestStatus getCOMPLETED() {
            return COMPLETED;
        }

        @NotNull
        public final RequestStatus getREVERTED_PENDING() {
            return REVERTED_PENDING;
        }

        @NotNull
        public final RequestStatus getREVERTED_EXECUTING() {
            return REVERTED_EXECUTING;
        }

        @NotNull
        public final RequestStatus getCANCELLED_PENDING() {
            return CANCELLED_PENDING;
        }

        @NotNull
        public final RequestStatus getCANCELLED_EXECUTING() {
            return CANCELLED_EXECUTING;
        }

        @NotNull
        public final RequestStatus getCANCELLED_COMPLETED() {
            return CANCELLED_COMPLETED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/requests/RequestStatus$Companion$Status;", "", "(Ljava/lang/String;I)V", "Pending", "Executing", "Reverted", "Cancelled", "Completed", "intellij.rd.client"})
        private static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status Pending = new Status();
            public static final /* enum */ Status Executing = new Status();
            public static final /* enum */ Status Reverted = new Status();
            public static final /* enum */ Status Cancelled = new Status();
            public static final /* enum */ Status Completed = new Status();
            private static final /* synthetic */ Status[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String value) {
                return Enum.valueOf(Status.class, value);
            }

            @NotNull
            public static EnumEntries<Status> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = statusArray = new Status[]{Status.Pending, Status.Executing, Status.Reverted, Status.Cancelled, Status.Completed};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

