/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdExKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0014J\u0011\u0010\u0017\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "isBatchingAllowed", "", "()Z", "assertClientId", "", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "redo", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n42#2,3:65\n8#3:68\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n34#1:65,3\n43#1:68\n*E\n"})
public final class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, patch);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
    }

    @NotNull
    public final TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object redo(@NotNull Continuation<? super Boolean> $completion) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        Editor editor2 = FrontendTextControlHostKt.toEditorOrNull(this.editorId);
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (editorImpl == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        EditorImpl editor3 = editorImpl;
        editor2 = FrontendPatchEngineKt.getEngine(this.getSession());
        String description$iv = "Redoing call editor action " + this.frontendActionId;
        boolean $i$f$recordChanges = false;
        AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
        Throwable throwable = null;
        try {
            AnAction anAction;
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
            boolean bl = false;
            ChangeScope $this$redo_u24lambda_u240 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction2 = anAction = actionManager.getAction(this.frontendActionId);
            if (anAction2 == null) {
                throw new IllegalStateException(("Not found action id: " + this.frontendActionId).toString());
            }
            Intrinsics.checkNotNull((Object)anAction2);
            AnAction action2 = anAction;
            DataContext dataContext = editor3.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"keyboard shortcut", (DataContext)dataContext2);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
            AnActionEvent actionEvent = anActionEvent;
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)actionEvent);
            rdPatch = it$iv.getSession().getPatch();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        RdPatch patch = rdPatch;
        if (patch == null && this.getPatch() != null) {
            FrontendCallEditorActionRequest $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FrontendCallEditorActionRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Setting null patch to " + this);
        }
        this.setPatch(patch);
        return Boxing.boxBoolean((patch != null || this.getStatus().isExecuting() ? 1 : 0) != 0);
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        String backendActionId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return (RdRequest)new RdCallEditorActionRequest(backendActionId, this.editorId);
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + "\n" + this.getPatch();
    }

    @Override
    public void assertClientId() {
        ClientIdExKt.assertClientIdConsistency((ClientId)new ClientId(this.editorId.getClientId()), (String)(this.debugDescription() + "::" + this.editorId.getDocumentId()));
    }
}

