/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.codeInsight.daemon.impl.AsyncDescriptionSupplier;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.model.HtmlStringTooltipModel;
import com.jetbrains.rd.ide.model.RichTooltipModel;
import com.jetbrains.rd.ide.model.StringTooltipModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendAsyncTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendLazyTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipCalculator;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0016\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendAsyncTooltipHighlightInfo;", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendLazyTooltipHighlightInfo;", "Lcom/intellij/codeInsight/daemon/impl/AsyncDescriptionSupplier;", "forcedTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "range", "Lcom/intellij/openapi/util/TextRange;", "isAfterEOL", "", "needsUpdate", "modelId", "", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "(Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;Lcom/intellij/openapi/util/TextRange;ZLjava/lang/Boolean;JLcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "getModelId", "()J", "promiseLocker", "", "tooltipCalculator", "com/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendAsyncTooltipHighlightInfo$tooltipCalculator$1", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendAsyncTooltipHighlightInfo$tooltipCalculator$1;", "getTooltipProvider", "()Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "updatePromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "calculateTooltip", "", "getOrCreatePromise", "requestDescription", "Lorg/jetbrains/concurrency/Promise;", "intellij.rd.client"})
public final class FrontendAsyncTooltipHighlightInfo
extends FrontendLazyTooltipHighlightInfo
implements AsyncDescriptionSupplier {
    private final long modelId;
    @NotNull
    private final FrontendTooltipProvider tooltipProvider;
    @Nullable
    private volatile AsyncPromise<String> updatePromise;
    @NotNull
    private final Object promiseLocker;
    @NotNull
    private final tooltipCalculator.1 tooltipCalculator;

    public FrontendAsyncTooltipHighlightInfo(@Nullable TextAttributes forcedTextAttributes, @NotNull HighlightInfoType infoType, @NotNull TextRange range2, boolean isAfterEOL, @Nullable Boolean needsUpdate, long modelId, @NotNull FrontendTooltipProvider tooltipProvider) {
        Intrinsics.checkNotNullParameter((Object)infoType, (String)"infoType");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        super(forcedTextAttributes, infoType, range2, isAfterEOL, needsUpdate);
        this.modelId = modelId;
        this.tooltipProvider = tooltipProvider;
        this.promiseLocker = new Object();
        long l = this.modelId;
        FrontendTooltipProvider frontendTooltipProvider = this.tooltipProvider;
        this.tooltipCalculator = new FrontendTooltipCalculator(this, l, frontendTooltipProvider){
            final /* synthetic */ FrontendAsyncTooltipHighlightInfo this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void updateData(@Nullable TooltipModel tooltipModel) {
                TooltipModel tooltipModel2 = tooltipModel;
                if (tooltipModel2 instanceof StringTooltipModel) {
                    String string = ((StringTooltipModel)tooltipModel).getText();
                    this.this$0.setToolTip(string != null ? RichTextHtmlUtils.INSTANCE.escapeToIdeaTooltip(string) : null);
                    String string2 = ((StringTooltipModel)tooltipModel).getText();
                    String desc2 = string2 != null ? StringsKt.replace$default((String)string2, (String)"_HORIZONTAL_LINE_TOOLTIP_SEPARATOR_", (String)"\n", (boolean)false, (int)4, null) : null;
                    String string3 = ((StringTooltipModel)tooltipModel).getText();
                    this.this$0.setDescription(string3 != null ? StringsKt.replace$default((String)string3, (String)"_HORIZONTAL_LINE_TOOLTIP_SEPARATOR_", (String)"\n", (boolean)false, (int)4, null) : null);
                    FrontendAsyncTooltipHighlightInfo.access$getOrCreatePromise(this.this$0).setResult((Object)desc2);
                } else if (tooltipModel2 instanceof HtmlStringTooltipModel) {
                    this.this$0.setToolTip(((HtmlStringTooltipModel)tooltipModel).getHtmlText());
                    String desc3 = ((HtmlStringTooltipModel)tooltipModel).getDescription();
                    this.this$0.setDescription(((HtmlStringTooltipModel)tooltipModel).getDescription());
                    FrontendAsyncTooltipHighlightInfo.access$getOrCreatePromise(this.this$0).setResult((Object)desc3);
                } else if (tooltipModel2 instanceof RichTooltipModel) {
                    this.this$0.setToolTip(RichTextHtmlUtils.INSTANCE.escapeToIdeaTooltip(((RichTooltipModel)tooltipModel).getRichText()));
                    String desc4 = StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)((RichTooltipModel)tooltipModel).getRichText().getParts(), (CharSequence)"", null, null, (int)0, null, (Function1)tooltipCalculator.updateData.desc.1.INSTANCE, (int)30, null), (String)"_HORIZONTAL_LINE_TOOLTIP_SEPARATOR_", (String)"\n", (boolean)false, (int)4, null);
                    this.this$0.setDescription(desc4);
                    FrontendAsyncTooltipHighlightInfo.access$getOrCreatePromise(this.this$0).setResult((Object)desc4);
                }
            }
        };
    }

    public final long getModelId() {
        return this.modelId;
    }

    @NotNull
    public final FrontendTooltipProvider getTooltipProvider() {
        return this.tooltipProvider;
    }

    @NotNull
    public Promise<String> requestDescription() {
        this.calculateTooltip();
        return (Promise)this.getOrCreatePromise();
    }

    @Override
    public void calculateTooltip() {
        if (this.modelId < 0L) {
            return;
        }
        if (RLifetimeKt.isAlive((Lifetime)this.tooltipProvider.getLifetime())) {
            this.tooltipCalculator.calculateTooltip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AsyncPromise<String> getOrCreatePromise() {
        if (this.updatePromise == null) {
            Object object = this.promiseLocker;
            synchronized (object) {
                boolean bl = false;
                if (this.updatePromise == null) {
                    this.updatePromise = new AsyncPromise();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        AsyncPromise<String> asyncPromise = this.updatePromise;
        Intrinsics.checkNotNull(asyncPromise);
        return asyncPromise;
    }

    public static final /* synthetic */ AsyncPromise access$getOrCreatePromise(FrontendAsyncTooltipHighlightInfo $this) {
        return $this.getOrCreatePromise();
    }
}

