/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.channel;

import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/util/channel/ChannelOutputStream;", "Ljava/io/OutputStream;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "", "(Lkotlinx/coroutines/channels/SendChannel;)V", "close", "", "write", "b", "off", "", "len", "intellij.platform.util.base"})
@ApiStatus.Experimental
public final class ChannelOutputStream
extends OutputStream {
    @NotNull
    private final SendChannel<byte[]> channel;

    public ChannelOutputStream(@NotNull SendChannel<? super byte[]> channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.channel = channel;
    }

    @Override
    public void write(int b) {
        byte[] byArray = new byte[]{(byte)b};
        Object result2 = ChannelsKt.trySendBlocking(this.channel, byArray);
        if (ChannelResult.isClosed-impl(result2)) {
            throw new IOException("Unable to write, channel is closed");
        }
        if (ChannelResult.isFailure-impl(result2)) {
            throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl(result2));
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter(b, "b");
        int offset = off;
        while (offset < len) {
            int nextOffset = Math.min(offset + 1024, len);
            byte[] byArray = b;
            Object result2 = ChannelsKt.trySendBlocking(this.channel, ArraysKt.copyOfRange(byArray, offset, nextOffset));
            if (ChannelResult.isClosed-impl(result2)) {
                throw new IOException("Unable to write, channel is closed");
            }
            if (ChannelResult.isFailure-impl(result2)) {
                throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl(result2));
            }
            offset = nextOffset;
        }
    }

    @Override
    public void close() {
        SendChannel.DefaultImpls.close$default(this.channel, null, 1, null);
        super.close();
    }
}

