/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.quickfix.CompatibilityPrintCallQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveUnderscoresInNumericLiteralsQuickFix;
import com.jetbrains.python.inspections.quickfix.PyReplaceStarByUnpackQuickFix;
import com.jetbrains.python.inspections.quickfix.RemovePrefixQuickFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingSuffixQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBackquoteExpressionQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBuiltinsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceExceptPartQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceListComprehensionsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceNotEqOperatorQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceOctalNumericLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceRaiseStatementQuickFix;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFStringFragmentFormatPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReprExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.StarAnnotator;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompatibilityVisitor
extends PyAnnotator {
    @NotNull
    private static final Set<String> PYTHON2_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"});
    @NotNull
    private static final Set<String> PYTHON34_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"});
    @NotNull
    private static final Set<String> PYTHON36_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB", "F", "FR", "RF"});
    @NotNull
    protected List<LanguageLevel> myVersionsToProcess;

    public CompatibilityVisitor(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(0);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    @Override
    public void visitPyAnnotation(@NotNull PyAnnotation node) {
        PsiElement parent;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(1);
        }
        if (!((parent = node.getParent()) instanceof PyFunction) && !(parent instanceof PyNamedParameter)) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.variable.annotations", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyExceptBlock(@NotNull PyExceptPart node) {
        PsiElement star;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(2);
        }
        super.visitPyExceptBlock(node);
        PyExpression exceptClass = node.getExceptClass();
        if (exceptClass != null) {
            PsiElement element = exceptClass.getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null && ",".equals(element.getText())) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, new ReplaceExceptPartQuickFix());
            }
        }
        if ((star = PyPsiUtils.getFirstChildOfType(node, PyTokenTypes.MULT)) != null) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON311), PyPsiBundle.message("INSP.compatibility.feature.support.starred.except.part", new Object[0]), star, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(3);
        }
        super.visitPyImportStatement(node);
        PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyIfStatement.class);
        if (ifParent != null) {
            return;
        }
        for (PyImportElement importElement : node.getImportElements()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            if (qName.matches(new String[]{"builtins"})) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.module.builtins", new Object[0]), (PsiElement)node, new ReplaceBuiltinsQuickFix());
                continue;
            }
            if (!qName.matches(new String[]{"__builtin__"})) continue;
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.module.builtin", new Object[0]), (PsiElement)node, new ReplaceBuiltinsQuickFix());
        }
    }

    @Override
    public void visitPyStarExpression(@NotNull PyStarExpression node) {
        PsiElement parent;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyStarExpression(node);
        if (node.isAssignmentTarget()) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.as.assignment.targets", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
        if (node.isUnpacking()) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.tuples.lists.and.sets", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
            PsiElement container = PsiTreeUtil.skipParentsOfType((PsiElement)node, (Class[])new Class[]{PyParenthesizedExpression.class});
            if (container instanceof PyTupleExpression) {
                PsiElement tupleParent = container.getParent();
                if (tupleParent instanceof PyReturnStatement) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.unpacking.without.parentheses.in.return.statements", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
                }
                if (tupleParent instanceof PyYieldExpression && !((PyYieldExpression)tupleParent).isDelegating()) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.unpacking.without.parentheses.in.yield.statements", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
                }
                if (tupleParent instanceof PySubscriptionExpression) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON311) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.subscriptions", new Object[0]), (PsiElement)node, new PyReplaceStarByUnpackQuickFix());
                }
            }
            if (node.getParent() instanceof PySubscriptionExpression || node.getParent() instanceof PySliceItem) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON311) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.subscriptions", new Object[0]), (PsiElement)node, new PyReplaceStarByUnpackQuickFix());
            }
        }
        if ((parent = node.getParent()) instanceof PyAnnotation && StarAnnotator.isVariadicArg(parent.getParent())) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON311) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.type.annotations", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyDoubleStarExpression(@NotNull PyDoubleStarExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(5);
        }
        super.visitPyDoubleStarExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.dicts", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(6);
        }
        super.visitPyBinaryExpression(node);
        if (node.isOperator("<>")) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.diamond.operator", new Object[0]), (PsiElement)node, new ReplaceNotEqOperatorQuickFix());
        } else if (node.isOperator("@")) {
            this.checkMatrixMultiplicationOperator(node.getPsiOperator());
        }
        this.checkBitwiseOrUnionSyntax(node);
    }

    private void checkMatrixMultiplicationOperator(PsiElement node) {
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.matrix.multiplication.operators", new Object[0]), node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyNumericLiteralExpression(@NotNull PyNumericLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(7);
        }
        super.visitPyNumericLiteralExpression(node);
        String text = node.getText();
        if (node.isIntegerLiteral()) {
            char secondChar;
            String suffix = node.getIntegerLiteralSuffix();
            if ("l".equalsIgnoreCase(suffix)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.long.integer.literal.suffix", suffix), (PsiElement)node, new RemoveTrailingSuffixQuickFix());
            }
            if (text.length() > 1 && text.charAt(0) == '0' && (secondChar = Character.toLowerCase(text.charAt(1))) != 'o' && secondChar != 'b' && secondChar != 'x' && text.chars().anyMatch(c -> c != 48)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.old.style.octal.literals", new Object[0]), (PsiElement)node, new ReplaceOctalNumericLiteralQuickFix());
            }
        }
        if (text.contains("_")) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.underscores.in.numeric.literals", new Object[0]), (PsiElement)node, new PyRemoveUnderscoresInNumericLiteralsQuickFix());
        }
    }

    @Override
    public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(8);
        }
        super.visitPyStringLiteralExpression(node);
        boolean seenBytes = false;
        boolean seenNonBytes = false;
        for (PyStringElement element : node.getStringElements()) {
            String prefix = StringUtil.toUpperCase((String)element.getPrefix());
            if (prefix.isEmpty()) continue;
            boolean bytes = element.isBytes();
            seenBytes |= bytes;
            seenNonBytes |= !bytes;
            int elementStart = element.getTextOffset();
            this.registerForAllMatchingVersions((LanguageLevel level) -> !CompatibilityVisitor.getSupportedStringPrefixes(level).contains(prefix) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.string.literal.prefix", prefix), (PsiElement)node, TextRange.create((int)elementStart, (int)(elementStart + element.getPrefixLength())), true, new RemovePrefixQuickFix(prefix));
        }
        if (seenBytes && seenNonBytes) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.to.mix.bytes.and.non.bytes.literals", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static Set<String> getSupportedStringPrefixes(@NotNull LanguageLevel level) {
        if (level == null) {
            CompatibilityVisitor.$$$reportNull$$$0(9);
        }
        if (level.isPython2()) {
            Set<String> set = PYTHON2_PREFIXES;
            if (set == null) {
                CompatibilityVisitor.$$$reportNull$$$0(10);
            }
            return set;
        }
        if (level.isOlderThan(LanguageLevel.PYTHON36)) {
            Set<String> set = PYTHON34_PREFIXES;
            if (set == null) {
                CompatibilityVisitor.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<String> set = PYTHON36_PREFIXES;
        if (set == null) {
            CompatibilityVisitor.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    public void visitPyListCompExpression(@NotNull PyListCompExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(13);
        }
        super.visitPyListCompExpression(node);
        for (PyComprehensionForComponent component2 : node.getForComponents()) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.listComprehensionIteratesOverNonParenthesizedTuple(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax.in.list.comprehensions", new Object[0]), (PsiElement)component2.getIteratedList(), new ReplaceListComprehensionsQuickFix());
        }
    }

    @Override
    public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(14);
        }
        super.visitPyRaiseStatement(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasNoArgsUnderFinally(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.raise.with.no.arguments.outside.except.block", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasMoreThenOneArg(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, new ReplaceRaiseStatementQuickFix());
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasFromKeyword(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, new ReplaceRaiseStatementQuickFix());
    }

    @Override
    public void visitPyReprExpression(@NotNull PyReprExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(15);
        }
        super.visitPyReprExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.backquotes", new Object[0]), (PsiElement)node, new ReplaceBackquoteExpressionQuickFix());
    }

    @Override
    public void visitPyWithStatement(@NotNull PyWithStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(16);
        }
        super.visitPyWithStatement(node);
        this.checkParenthesizedWithItems(node);
        this.checkAsyncKeyword(node);
    }

    private void checkParenthesizedWithItems(@NotNull PyWithStatement node) {
        boolean canBeParsedAsSingleParenthesizedExpression;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(17);
        }
        PsiElement lpar = PyPsiUtils.getFirstChildOfType(node, PyTokenTypes.LPAR);
        PsiElement rpar = PyPsiUtils.getFirstChildOfType(node, PyTokenTypes.RPAR);
        if (lpar == null && rpar == null) {
            return;
        }
        PyWithItem[] withItems = node.getWithItems();
        boolean bl = canBeParsedAsSingleParenthesizedExpression = withItems.length == 1 && PyPsiUtils.getFirstChildOfType((PsiElement)withItems[0], PyTokenTypes.AS_KEYWORD) == null && PyPsiUtils.getFirstChildOfType(node, PyTokenTypes.COMMA) == null;
        if (canBeParsedAsSingleParenthesizedExpression) {
            return;
        }
        for (PsiElement parenthesis : ContainerUtil.packNullables((Object[])new PsiElement[]{lpar, rpar})) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON39) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.parenthesized.context.expressions", new Object[0]), parenthesis, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyForStatement(@NotNull PyForStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(18);
        }
        super.visitPyForStatement(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyPrintStatement(@NotNull PyPrintStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(19);
        }
        super.visitPyPrintStatement(node);
        Object[] arguments = node.getChildren();
        Condition nonParenthesesPredicate = element -> !(element instanceof PyParenthesizedExpression) && !(element instanceof PyTupleExpression);
        if (arguments.length == 0 || ContainerUtil.exists((Object[])arguments, (Condition)nonParenthesesPredicate)) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.print.statement", new Object[0]), (PsiElement)node, new CompatibilityPrintCallQuickFix());
        }
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(20);
        }
        super.visitPyCallExpression(node);
        PsiElement firstChild = node.getFirstChild();
        if (firstChild != null && "super".equals(firstChild.getText()) && ArrayUtil.isEmpty((Object[])node.getArguments())) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.super.without.arguments", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
        this.highlightIncorrectArguments(node);
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(21);
        }
        super.visitPyFunction(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(22);
        }
        super.visitPyPrefixExpression(node);
        if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(23);
        }
        super.visitPyYieldExpression(node);
        Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)node)).map(owner -> PyUtil.as(owner, PyFunction.class)).filter(function -> function.isAsync() && function.isAsyncAllowed()).ifPresent(function -> {
            if (!node.isDelegating() && this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.yield.inside.async.functions", new Object[0]), new LocalQuickFix[0]);
            }
        });
        if (!node.isDelegating()) {
            return;
        }
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.yield.from", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        PyFunction function;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(24);
        }
        if (ContainerUtil.exists(this.myVersionsToProcess, level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level))) && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class})) != null && node.getExpression() != null) {
            YieldVisitor visitor2 = new YieldVisitor();
            function.acceptChildren(visitor2);
            if (visitor2.haveYield()) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.pre35.versions.do.not.allow.return.with.argument.inside.generator", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @Override
    public void visitPyNoneLiteralExpression(@NotNull PyNoneLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(25);
        }
        if (node.isEllipsis()) {
            PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PySubscriptionExpression.class);
            if (subscription != null && PsiTreeUtil.isAncestor((PsiElement)subscription.getIndexExpression(), (PsiElement)node, (boolean)false)) {
                return;
            }
            PySliceItem sliceItem = (PySliceItem)PsiTreeUtil.getParentOfType((PsiElement)node, PySliceItem.class);
            if (sliceItem != null) {
                return;
            }
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.ellipsis.outside.slices", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
        IElementType operationType;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(26);
        }
        super.visitPyAugAssignmentStatement(node);
        PsiElement operation = node.getOperation();
        if (operation != null && ((Object)((Object)PyTokenTypes.ATEQ)).equals(operationType = operation.getNode().getElementType())) {
            this.checkMatrixMultiplicationOperator(operation);
        }
    }

    private void checkAsyncKeyword(@NotNull PsiElement node) {
        ASTNode asyncNode;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(27);
        }
        if ((asyncNode = node.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)) != null) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), node, asyncNode.getTextRange(), true, new LocalQuickFix[0]);
        }
    }

    protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            CompatibilityVisitor.$$$reportNull$$$0(28);
        }
        return true;
    }

    protected abstract void registerProblem(@NotNull PsiElement var1, @NotNull TextRange var2, @NotNull @InspectionMessage String var3, boolean var4, LocalQuickFix ... var5);

    protected void registerProblem(@NotNull PsiElement node, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(29);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(30);
        }
        if (fixes == null) {
            CompatibilityVisitor.$$$reportNull$$$0(31);
        }
        this.registerProblem(node, node.getTextRange(), message, true, fixes);
    }

    protected void setVersionsToProcess(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(32);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node, @NotNull TextRange range, boolean asError, LocalQuickFix ... fixes) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(33);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(34);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(35);
        }
        if (range == null) {
            CompatibilityVisitor.$$$reportNull$$$0(36);
        }
        if (fixes == null) {
            CompatibilityVisitor.$$$reportNull$$$0(37);
        }
        List levels = ContainerUtil.filter(this.myVersionsToProcess, levelPredicate::test);
        if (!levels.isEmpty()) {
            @NlsSafe String versions2 = StringUtil.join((Iterable)levels, (String)", ");
            @InspectionMessage String message = PyPsiBundle.message("INSP.compatibility.inspection.unsupported.feature.prefix", levels.size(), versions2, suffix);
            this.registerProblem(node, range, message, asError, fixes);
        }
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node, LocalQuickFix ... fixes) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(38);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(39);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(40);
        }
        if (fixes == null) {
            CompatibilityVisitor.$$$reportNull$$$0(41);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, node.getTextRange(), true, fixes);
    }

    @Override
    public void visitPyNonlocalStatement(@NotNull PyNonlocalStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(42);
        }
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.nonlocal.keyword", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    private void highlightIncorrectArguments(@NotNull PyCallExpression callExpression) {
        PsiElement sibling;
        if (callExpression == null) {
            CompatibilityVisitor.$$$reportNull$$$0(43);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        boolean seenKeywordArgument = false;
        boolean seenKeywordContainer = false;
        boolean seenPositionalContainer = false;
        for (PyExpression argument : callExpression.getArguments()) {
            if (argument instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)argument).getKeyword();
                if (keywordArgumentNames.contains(keyword)) {
                    this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.keyword.argument.repeated", new Object[0]), new PyRemoveArgumentQuickFix());
                } else if (seenKeywordContainer) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.keyword.arguments.after.kwargs", new Object[0]), (PsiElement)argument, new PyRemoveArgumentQuickFix());
                }
                seenKeywordArgument = true;
                keywordArgumentNames.add(keyword);
                continue;
            }
            if (argument instanceof PyStarArgument) {
                PyStarArgument starArgument = (PyStarArgument)argument;
                if (starArgument.isKeyword()) {
                    if (seenKeywordContainer) {
                        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.duplicate.kwargs", new Object[0]), (PsiElement)argument, new PyRemoveArgumentQuickFix());
                    }
                    seenKeywordContainer = true;
                    continue;
                }
                if (seenPositionalContainer) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.duplicate.positional.varargs", new Object[0]), (PsiElement)argument, new PyRemoveArgumentQuickFix());
                }
                seenPositionalContainer = true;
                continue;
            }
            if (seenKeywordArgument) {
                this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.positional.argument.after.keyword.argument", new Object[0]), new PyRemoveArgumentQuickFix());
                continue;
            }
            if (seenPositionalContainer) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.positional.arguments.after.expression", new Object[0]), (PsiElement)argument, new PyRemoveArgumentQuickFix());
                continue;
            }
            if (!seenKeywordContainer) continue;
            this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.positional.argument.after.kwargs", new Object[0]), new PyRemoveArgumentQuickFix());
        }
        PyExpression lastArg = (PyExpression)ContainerUtil.getLastItem(Arrays.asList(callExpression.getArguments()));
        if (lastArg instanceof PyStarArgument && (sibling = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)lastArg)) != null && sibling.getNode().getElementType() == PyTokenTypes.COMMA) {
            boolean isKeyword = ((PyStarArgument)lastArg).isKeyword();
            String message = isKeyword ? PyPsiBundle.message("INSP.compatibility.feature.allow.trailing.comma.after.kwargs", new Object[0]) : PyPsiBundle.message("INSP.compatibility.feature.allow.trailing.comma.after.positional.vararg", new Object[0]);
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), message, sibling, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(44);
        }
        super.visitPyComprehensionElement(node);
        if (this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
            Arrays.stream(node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.ASYNC_KEYWORD}))).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.async.inside.comprehensions.and.generator.expressions", new Object[0]), new LocalQuickFix[0]));
            Stream resultPrefixExpressions = PsiTreeUtil.collectElementsOfType((PsiElement)node.getResultExpression(), (Class[])new Class[]{PyPrefixExpression.class}).stream();
            Stream ifComponentsPrefixExpressions = node.getIfComponents().stream().map(ifComponent -> PsiTreeUtil.collectElementsOfType((PsiElement)ifComponent.getTest(), (Class[])new Class[]{PyPrefixExpression.class})).flatMap(Collection::stream);
            Stream.concat(resultPrefixExpressions, ifComponentsPrefixExpressions).filter(expression -> expression.getOperator() == PyTokenTypes.AWAIT_KEYWORD && expression.getOperand() != null).map(expression -> expression.getNode().findChildByType((IElementType)PyTokenTypes.AWAIT_KEYWORD)).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.await.inside.comprehensions", new Object[0]), new LocalQuickFix[0]));
        }
    }

    @Override
    public void visitPySlashParameter(@NotNull PySlashParameter node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(45);
        }
        super.visitPySlashParameter(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.positional.only.parameters", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyFStringFragment(@NotNull PyFStringFragment node) {
        String parentFStringQuote;
        boolean isFragmentOfTopmostFStringWithSuchQuotes;
        boolean isFragmentOfTopmostSingleQuotedFString;
        boolean isTopmostFragment;
        List containingFragmentsOfSameFString;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(46);
        }
        super.visitPyFStringFragment(node);
        ASTNode equalitySignInFStringFragment = node.getNode().findChildByType((IElementType)PyTokenTypes.EQ);
        if (equalitySignInFStringFragment != null) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.support.equality.signs.in.fstrings", new Object[0]), equalitySignInFStringFragment.getPsi(), new LocalQuickFix[0]);
        }
        if ((containingFragmentsOfSameFString = PsiTreeUtil.collectParents((PsiElement)node, PyFStringFragment.class, (boolean)false, o -> o instanceof PyStringLiteralExpression)).size() > 1) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.deep.expression.nesting.in.f-strings", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
        boolean bl = isTopmostFragment = PsiTreeUtil.getParentOfType((PsiElement)node, PyFStringFragment.class, (boolean)true) == null;
        if (isTopmostFragment) {
            ArrayList<PyFStringFragment> fragments = new ArrayList<PyFStringFragment>();
            fragments.add(node);
            PyFStringFragmentFormatPart formatPart = node.getFormatPart();
            if (formatPart != null) {
                fragments.addAll(formatPart.getFragments());
            }
            for (PyFStringFragment fragment2 : fragments) {
                String wholeNodeText = fragment2.getText();
                TextRange range = fragment2.getExpressionContentRange();
                for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                    if (wholeNodeText.charAt(i) != '\\') continue;
                    TextRange backslashRange = TextRange.from((int)i, (int)1).shiftRight(fragment2.getTextRange().getStartOffset());
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.backslashes.in.f-strings", new Object[0]), (PsiElement)node, backslashRange, true, new LocalQuickFix[0]);
                }
            }
        }
        List containingFStrings = PsiTreeUtil.collectParents((PsiElement)node, PyFormattedStringElement.class, (boolean)false, e -> e instanceof PyStatement);
        assert (!containingFStrings.isEmpty());
        PyFormattedStringElement parentFString = (PyFormattedStringElement)containingFStrings.get(0);
        List remainingEnclosingFStrings = ContainerUtil.subList((List)containingFStrings, (int)1);
        boolean bl2 = isFragmentOfTopmostSingleQuotedFString = !parentFString.isTripleQuoted() && ContainerUtil.all((Collection)remainingEnclosingFStrings, PyStringElement::isTripleQuoted);
        if (isFragmentOfTopmostSingleQuotedFString && node.textContains('\n')) {
            int lineBreakOffset = node.getText().indexOf(10);
            if (node.getExpressionContentRange().contains(lineBreakOffset)) {
                PsiElement multiLineLeaf = node.findElementAt(lineBreakOffset);
                assert (multiLineLeaf != null);
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.new.lines.in.f-strings", new Object[0]), multiLineLeaf, new LocalQuickFix[0]);
            }
        }
        if (isFragmentOfTopmostFStringWithSuchQuotes = ContainerUtil.all((Collection)remainingEnclosingFStrings, arg_0 -> CompatibilityVisitor.lambda$visitPyFStringFragment$56(parentFStringQuote = parentFString.getQuote(), arg_0))) {
            int illegalQuoteOffset = node.getText().indexOf(parentFStringQuote);
            if (node.getExpressionContentRange().contains(illegalQuoteOffset)) {
                TextRange illegalQuoteRange = TextRange.from((int)illegalQuoteOffset, (int)parentFStringQuote.length());
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.quote.reuse.in.f-strings", new Object[0]), (PsiElement)node, illegalQuoteRange.shiftRight(node.getTextRange().getStartOffset()), true, new LocalQuickFix[0]);
            }
        }
    }

    public void visitComment(@NotNull PsiComment node) {
        boolean insideFStringFragment;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(47);
        }
        boolean bl = insideFStringFragment = PsiTreeUtil.getParentOfType((PsiElement)node, PyFStringFragment.class) != null;
        if (insideFStringFragment) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.line.comments.in.f-strings", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(48);
        }
        super.visitPyAssignmentExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.assignment.expressions", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyContinueStatement(@NotNull PyContinueStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(49);
        }
        super.visitPyContinueStatement(node);
        if (PsiTreeUtil.getParentOfType((PsiElement)node, PyFinallyPart.class, (boolean)false, (Class[])new Class[]{PyLoopStatement.class}) != null) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.continue.inside.finally.clause", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            CompatibilityVisitor.$$$reportNull$$$0(50);
        }
        super.visitPyDecorator(decorator);
        if (PsiTreeUtil.getChildOfType((PsiElement)decorator, PsiErrorElement.class) == null && decorator.getQualifiedName() == null) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON39) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.arbitrary.expressions.as.decorator", new Object[0]), (PsiElement)decorator, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        if (matchStatement == null) {
            CompatibilityVisitor.$$$reportNull$$$0(51);
        }
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON310), PyPsiBundle.message("INSP.compatibility.feature.support.match.statements", new Object[0]), matchStatement.getFirstChild(), new LocalQuickFix[0]);
    }

    @Override
    public void visitPyTypeAliasStatement(@NotNull PyTypeAliasStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(52);
        }
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312), PyPsiBundle.message("INSP.compatibility.feature.support.type.alias.statements", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
    }

    @Override
    public void visitPyTypeParameterList(@NotNull PyTypeParameterList node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(53);
        }
        if (!(node.getParent() instanceof PyTypeAliasStatement)) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON312), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
        }
    }

    private void checkBitwiseOrUnionSyntax(@NotNull PyBinaryExpression node) {
        boolean isInAnnotation;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(54);
        }
        if (node.getOperator() != PyTokenTypes.OR) {
            return;
        }
        PsiFile file = node.getContainingFile();
        boolean bl = isInAnnotation = PsiTreeUtil.getParentOfType((PsiElement)node, PyAnnotation.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) != null;
        if (file == null || file instanceof PyFile && ((PyFile)file).hasImportFromFuture(FutureFeature.ANNOTATIONS) && isInAnnotation) {
            return;
        }
        TypeEvalContext context = TypeEvalContext.codeAnalysis(node.getProject(), node.getContainingFile());
        if (PsiTreeUtil.getParentOfType((PsiElement)node, PyBinaryExpression.class, (boolean)true, (Class[])new Class[]{PyStatement.class}) != null) {
            return;
        }
        Ref<PyType> refType = PyTypingTypeProvider.getType((PyExpression)node, context);
        if (refType != null && refType.get() instanceof PyUnionType) {
            if (isInAnnotation) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON310), PyPsiBundle.message("INSP.compatibility.new.union.syntax.not.available.in.earlier.version", new Object[0]), (PsiElement)node, new ReplaceWithOldStyleUnionQuickFix(), new AddFromFutureImportAnnotationsQuickFix());
            } else {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON310), PyPsiBundle.message("INSP.compatibility.new.union.syntax.not.available.in.earlier.version", new Object[0]), (PsiElement)node, new ReplaceWithOldStyleUnionQuickFix());
            }
        }
    }

    private static /* synthetic */ boolean lambda$visitPyFStringFragment$56(String parentFStringQuote, PyFormattedStringElement fString) {
        return !fString.getQuote().equals(parentFStringQuote);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsToProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 31: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "levelPredicate";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedStringPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyExceptBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyImportStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStarExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDoubleStarExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNumericLiteralExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStringLiteralExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedStringPrefixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPyListCompExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPyRaiseStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReprExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWithStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkParenthesizedWithItems";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitPyForStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPrintStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFunction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPrefixExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitPyYieldExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReturnStatement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNoneLiteralExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAugAssignmentStatement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkAsyncKeyword";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerForLanguageLevel";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setVersionsToProcess";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "registerForAllMatchingVersions";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNonlocalStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "highlightIncorrectArguments";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitPyComprehensionElement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitPySlashParameter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFStringFragment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitPyContinueStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDecorator";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeAliasStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeParameterList";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkBitwiseOrUnionSyntax";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class YieldVisitor
    extends PyElementVisitor {
        private boolean _haveYield = false;

        private YieldVisitor() {
        }

        public boolean haveYield() {
            return this._haveYield;
        }

        @Override
        public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(0);
            }
            this._haveYield = true;
        }

        @Override
        public void visitPyElement(@NotNull PyElement node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(1);
            }
            if (!this._haveYield) {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor$YieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyYieldExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceWithOldStyleUnionQuickFix
    implements LocalQuickFix {
        private ReplaceWithOldStyleUnionQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.replace.with.old.union.style", new Object[0]);
            if (string == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiFile file;
            if (project == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(2);
            }
            if ((file = descriptor2.getPsiElement().getContainingFile()) == null) {
                return;
            }
            PsiElement descriptorElement = descriptor2.getPsiElement();
            if (!(descriptorElement instanceof PyBinaryExpression)) {
                return;
            }
            PyBinaryExpression expression = (PyBinaryExpression)descriptorElement;
            List<String> types = ReplaceWithOldStyleUnionQuickFix.collectUnionTypes(expression);
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
            AddImportHelper.ImportPriority priority = languageLevel.isAtLeast(LanguageLevel.PYTHON35) ? AddImportHelper.ImportPriority.BUILTIN : AddImportHelper.ImportPriority.THIRD_PARTY;
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PyCallExpression.class);
            if (call != null && call.isCalleeText("isinstance", "issubclass")) {
                ReplaceWithOldStyleUnionQuickFix.replaceOldExpressionWith(project, languageLevel, expression, "(" + StringUtil.join(types, (String)", ") + ")");
            } else if (types.size() == 2 && types.contains("None")) {
                String notNoneType = "None".equals(types.get(0)) ? types.get(1) : types.get(0);
                AddImportHelper.addOrUpdateFromImportStatement(file, "typing", "Optional", null, priority, (PsiElement)expression);
                ReplaceWithOldStyleUnionQuickFix.replaceOldExpressionWith(project, languageLevel, expression, "Optional[" + notNoneType + "]");
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(file, "typing", "Union", null, priority, (PsiElement)expression);
                ReplaceWithOldStyleUnionQuickFix.replaceOldExpressionWith(project, languageLevel, expression, "Union[" + StringUtil.join(types, (String)", ") + "]");
            }
        }

        private static void replaceOldExpressionWith(@NotNull Project project, @NotNull LanguageLevel languageLevel, @NotNull PyBinaryExpression expression, @NotNull String text) {
            if (project == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(3);
            }
            if (languageLevel == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(4);
            }
            if (expression == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(5);
            }
            if (text == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(6);
            }
            PyExpression newExpression = PyElementGenerator.getInstance(project).createExpressionFromText(languageLevel, text);
            expression.replace((PsiElement)newExpression);
        }

        @NotNull
        private static List<String> collectUnionTypes(@Nullable PyExpression expression) {
            if (expression == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(7);
                }
                return list;
            }
            if (expression instanceof PyBinaryExpression) {
                List<String> leftTypes = ReplaceWithOldStyleUnionQuickFix.collectUnionTypes(((PyBinaryExpression)expression).getLeftExpression());
                List<String> rightTypes = ReplaceWithOldStyleUnionQuickFix.collectUnionTypes(((PyBinaryExpression)expression).getRightExpression());
                List list = ContainerUtil.concat(leftTypes, rightTypes);
                if (list == null) {
                    ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(8);
                }
                return list;
            }
            if (expression instanceof PyParenthesizedExpression) {
                return ReplaceWithOldStyleUnionQuickFix.collectUnionTypes(PyPsiUtils.flattenParens(expression));
            }
            List<String> list = Collections.singletonList(expression.getText());
            if (list == null) {
                ReplaceWithOldStyleUnionQuickFix.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/CompatibilityVisitor$ReplaceWithOldStyleUnionQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor$ReplaceWithOldStyleUnionQuickFix";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectUnionTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceOldExpressionWith";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddFromFutureImportAnnotationsQuickFix
    implements LocalQuickFix {
        private AddFromFutureImportAnnotationsQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.add.from.future.import.annotations", new Object[0]);
            if (string == null) {
                AddFromFutureImportAnnotationsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                AddFromFutureImportAnnotationsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                AddFromFutureImportAnnotationsQuickFix.$$$reportNull$$$0(2);
            }
            PsiFile file = descriptor2.getPsiElement().getContainingFile();
            AddImportHelper.addOrUpdateFromImportStatement(file, "__future__", "annotations", null, AddImportHelper.ImportPriority.FUTURE, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/CompatibilityVisitor$AddFromFutureImportAnnotationsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor$AddFromFutureImportAnnotationsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

