/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnixPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final String[] BIN_DIRECTORIES = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String[] NAMES = new String[]{"jython", "pypy"};
    private static final Pattern PYTHON_3_RE = Pattern.compile("(python-?3\\.(\\d){1,2})|(python-?3)");

    private UnixPythonSdkFlavor() {
    }

    public static UnixPythonSdkFlavor getInstance() {
        return (UnixPythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(UnixPythonSdkFlavor.class);
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isUnix && !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        return UnixPythonSdkFlavor.getDefaultUnixPythons();
    }

    @NotNull
    public static List<Path> getDefaultUnixPythons() {
        return UnixPythonSdkFlavor.getDefaultUnixPythons(null);
    }

    @NotNull
    public static List<Path> getDefaultUnixPythons(@Nullable Path rootPath) {
        ArrayList<Path> candidates = new ArrayList<Path>();
        Arrays.stream(BIN_DIRECTORIES).map(x$0 -> Path.of(x$0, new String[0])).map(binDirectory -> UnixPythonSdkFlavor.optionallyChangeRoot(rootPath, binDirectory)).forEach(rootDir -> UnixPythonSdkFlavor.collectUnixPythons(rootDir, candidates));
        ArrayList<Path> arrayList = candidates;
        if (arrayList == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private static Path optionallyChangeRoot(@Nullable Path rootPath, @NotNull Path dir) {
        if (dir == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        Path path2 = rootPath != null ? rootPath.resolve(dir.getRoot().relativize(dir)) : dir;
        if (path2 == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        return path2;
    }

    public static void collectUnixPythons(@NotNull Path binDirectory, @NotNull Collection<Path> candidates) {
        if (binDirectory == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (candidates == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        try (Stream<Path> entries = Files.list(binDirectory);){
            entries.filter(UnixPythonSdkFlavor::looksLikePythonBinary).collect(Collectors.toCollection(() -> candidates));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean looksLikePythonBinary(@NotNull Path path2) {
        if (path2 == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        if (!Files.isRegularFile(path2, new LinkOption[0])) {
            return false;
        }
        return UnixPythonSdkFlavor.looksLikePythonBinaryFilename(path2.getFileName().toString());
    }

    private static boolean looksLikePythonBinaryFilename(@NotNull String filename) {
        String childName;
        if (filename == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return ArrayUtil.contains((String)(childName = StringUtil.toLowerCase((String)filename)), (String[])NAMES) || PYTHON_3_RE.matcher(childName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixPythons";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "optionallyChangeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "optionallyChangeRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectUnixPythons";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "looksLikePythonBinary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "looksLikePythonBinaryFilename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

