/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallCollector;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.PySdkToInstallManager;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.SdksKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.installer.CancelledPrepareException;
import com.jetbrains.python.sdk.installer.CancelledProcessException;
import com.jetbrains.python.sdk.installer.ExeReleaseInstaller;
import com.jetbrains.python.sdk.installer.PkgReleaseInstaller;
import com.jetbrains.python.sdk.installer.PrepareException;
import com.jetbrains.python.sdk.installer.ReleaseInstaller;
import com.jetbrains.python.sdk.installer.ReleaseInstallerException;
import com.jetbrains.python.sdk.installer.ResourceTypeReleaseInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\rH\u0002J\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fJ&\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\rH\u0007J \u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001eJ,\u0010\u0017\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010 \u001a\u00020\u001c2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallManager;", "", "()V", "installers", "", "Lcom/jetbrains/python/sdk/installer/ResourceTypeReleaseInstaller;", "findInstalledSdk", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "project", "Lcom/intellij/openapi/project/Project;", "systemWideSdksDetector", "Lkotlin/Function0;", "getAvailableVersionsToInstall", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/sdk/installer/ReleaseInstaller;", "Lcom/jetbrains/python/sdk/Release;", "getLatestReleases", "installer", "product", "Lcom/jetbrains/python/sdk/Product;", "install", "sdk", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "module", "Lcom/intellij/openapi/module/Module;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "installableRelease", "showErrorNotification", "ex", "Lcom/jetbrains/python/sdk/installer/ReleaseInstallerException;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkToInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkToInstallManager.kt\ncom/jetbrains/python/sdk/PySdkToInstallManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n1789#2,2:121\n1791#2:125\n766#2:136\n857#2,2:137\n766#2:147\n857#2,2:148\n215#3,2:123\n135#3,9:126\n215#3:135\n216#3:140\n144#3:141\n1#4:139\n12#5,5:142\n*S KotlinDebug\n*F\n+ 1 PySdkToInstallManager.kt\ncom/jetbrains/python/sdk/PySdkToInstallManager\n*L\n23#1:121,2\n23#1:125\n84#1:136\n84#1:137,2\n101#1:147\n101#1:148,2\n25#1:123,2\n83#1:126,9\n83#1:135\n83#1:140\n83#1:141\n83#1:139\n99#1:142,5\n*E\n"})
public final class PySdkToInstallManager {
    @NotNull
    public static final PySdkToInstallManager INSTANCE = new PySdkToInstallManager();
    @NotNull
    private static final List<ResourceTypeReleaseInstaller> installers;

    private PySdkToInstallManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, Pair<ReleaseInstaller, Release>> getAvailableVersionsToInstall() {
        void $this$fold$iv;
        Iterable iterable = installers;
        EnumMap initial$iv = new EnumMap(LanguageLevel.class);
        boolean $i$f$fold = false;
        EnumMap accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void installer;
            EnumMap enumMap;
            ResourceTypeReleaseInstaller resourceTypeReleaseInstaller = (ResourceTypeReleaseInstaller)element$iv;
            EnumMap union = accumulator$iv;
            boolean bl = false;
            EnumMap $this$getAvailableVersionsToInstall_u24lambda_u242_u24lambda_u241 = enumMap = union;
            boolean bl2 = false;
            Map $this$forEach$iv = PySdkToInstallManager.getLatestReleases$default(INSTANCE, (ReleaseInstaller)installer, null, 2, null);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator.next();
                boolean bl3 = false;
                LanguageLevel languageLevel = (LanguageLevel)((Object)entry.getKey());
                Release release = (Release)entry.getValue();
                ((Map)$this$getAvailableVersionsToInstall_u24lambda_u242_u24lambda_u241).put(languageLevel, TuplesKt.to((Object)installer, (Object)release));
            }
            accumulator$iv = enumMap;
        }
        return accumulator$iv;
    }

    public final void install(@NotNull Pair<? extends ReleaseInstaller, Release> installableRelease, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(installableRelease, (String)"installableRelease");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ReleaseInstaller installer = (ReleaseInstaller)installableRelease.component1();
        Release release = (Release)installableRelease.component2();
        installer.install(release, indicator, (Function0<Unit>)((Function0)new Function0<Unit>(project, release){
            final /* synthetic */ Project $project;
            final /* synthetic */ Release $release;
            {
                this.$project = $project;
                this.$release = $release;
                super(0);
            }

            public final void invoke() {
                String string = this.$release.getVersion().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(this.$project, string, PySdkToInstallCollector.Companion.DownloadResult.OK);
            }
        }));
        PySdkToInstallCollector.Companion.logSdkInstall$intellij_python_community_impl(project, release.getVersion().toString(), PySdkToInstallCollector.Companion.InstallationResult.OK);
    }

    public final void install(@NotNull PySdkToInstall sdk2, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)sdk2), (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.install((Pair<? extends ReleaseInstaller, Release>)TuplesKt.to((Object)sdk2.getInstaller(), (Object)sdk2.getRelease()), project, indicator);
    }

    @RequiresEdt
    @Nullable
    public final PyDetectedSdk install(@NotNull PySdkToInstall sdk2, @Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        Intrinsics.checkNotNullParameter((Object)((Object)sdk2), (String)"sdk");
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        Module module2 = module;
        Project project = module2 != null ? module2.getProject() : null;
        try {
            Object[] objectArray = new Object[]{sdk2.getName()};
            String string = PyBundle.message("python.sdk.installing", objectArray);
            return (PyDetectedSdk)((Object)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<PyDetectedSdk, Exception>(project, sdk2, systemWideSdksDetector, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ PySdkToInstall $sdk;
                final /* synthetic */ Function0<List<PyDetectedSdk>> $systemWideSdksDetector;
                {
                    this.$project = $project;
                    this.$sdk = $sdk;
                    this.$systemWideSdksDetector = $systemWideSdksDetector;
                    super($project, $super_call_param$1, true);
                }

                @Nullable
                protected PyDetectedSdk compute(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    PySdkToInstallManager.INSTANCE.install(this.$sdk, this.$project, indicator);
                    return PySdkToInstallManager.access$findInstalledSdk(PySdkToInstallManager.INSTANCE, SdksKt.toLanguageLevel(this.$sdk.getRelease().getVersion()), this.$project, this.$systemWideSdksDetector);
                }
            }));
        }
        catch (ReleaseInstallerException ex) {
            PySdkToInstallKt.getLOGGER().info((Throwable)ex);
            PySdkToInstallCollector.Companion.logInstallerException$intellij_python_community_impl(project, sdk2.getRelease(), ex);
            this.showErrorNotification(project, ex);
            return null;
        }
    }

    private final void showErrorNotification(Project project, ReleaseInstallerException ex) {
        String string = ex instanceof PrepareException ? PyBundle.message("python.sdk.download.failed.title", new Object[0]) : PyBundle.message("python.sdk.installation.failed.title", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        ReleaseInstallerException releaseInstallerException = ex;
        String string2 = (releaseInstallerException instanceof CancelledProcessException ? true : releaseInstallerException instanceof CancelledPrepareException) ? PyBundle.message("python.sdk.installation.cancelled.message", new Object[0]) : (releaseInstallerException instanceof PrepareException ? PyBundle.message("python.sdk.download.failed.message", new Object[0]) : PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0]));
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<LanguageLevel, Release> getLatestReleases(ReleaseInstaller installer, Product product) {
        void $this$mapNotNullTo$iv$iv;
        Map<LanguageLevel, List<Release>> $this$mapNotNull$iv = SdksKeeper.INSTANCE.pythonReleasesByLanguageLevel();
        boolean $i$f$mapNotNull = false;
        Map<LanguageLevel, List<Release>> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            LanguageLevel langVersion = (LanguageLevel)((Object)entry.getKey());
            List releases = (List)entry.getValue();
            Iterable $this$filter$iv = releases;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Release it = (Release)element$iv$iv2;
                boolean bl3 = false;
                if (!(it.getProduct() == product && installer.canInstall(it))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            if ((Release)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2)) != null) {
                Release latest;
                boolean bl4 = false;
                pair = TuplesKt.to((Object)((Object)langVersion), (Object)latest);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    static /* synthetic */ Map getLatestReleases$default(PySdkToInstallManager pySdkToInstallManager, ReleaseInstaller releaseInstaller, Product product, int n, Object object) {
        if ((n & 2) != 0) {
            product = Product.CPython;
        }
        return pySdkToInstallManager.getLatestReleases(releaseInstaller, product);
    }

    /*
     * WARNING - void declaration
     */
    private final PyDetectedSdk findInstalledSdk(LanguageLevel languageLevel, Project project, Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        PySdkToInstallCollector.Companion.LookupResult lookupResult;
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PySdkToInstallKt.getLOGGER().debug("Resetting system-wide sdks detectors");
        PySdkExtKt.resetSystemWideSdksDetectors();
        Object object = systemWideSdksDetector.invoke();
        List sdks2 = (List)object;
        boolean $i$a$-also-PySdkToInstallManager$findInstalledSdk$22 = false;
        Logger $this$debug_u24default$iv = PySdkToInstallKt.getLOGGER();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug(CollectionsKt.joinToString$default((Iterable)sdks2, null, (CharSequence)"Detected system-wide sdks: ", null, (int)0, null, (Function1)findInstalledSdk.1.1.1.INSTANCE, (int)29, null), e$iv);
        }
        object = (Iterable)object;
        boolean $i$f$filter = false;
        void $i$a$-also-PySdkToInstallManager$findInstalledSdk$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LanguageLevel languageLevel2;
            PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv$iv);
            boolean bl3 = false;
            if (PythonSdkFlavor.getFlavor((Sdk)it) != null) {
                PythonSdkFlavor<?> flavor;
                boolean bl4 = false;
                String string = it.getHomePath();
                Intrinsics.checkNotNull((Object)string);
                languageLevel2 = flavor.getLanguageLevelFromVersionString(flavor.getVersionString(string));
            } else {
                languageLevel2 = null;
            }
            LanguageLevel detectedLevel = languageLevel2;
            LanguageLevel languageLevel3 = languageLevel;
            if (!(languageLevel3 != null ? languageLevel3.equals((Object)detectedLevel) : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object it = object = (List)destination$iv$iv;
        boolean bl5 = false;
        String string = String.valueOf((Object)languageLevel);
        boolean bl6 = bl = !((Collection)it).isEmpty();
        if (bl) {
            lookupResult = PySdkToInstallCollector.Companion.LookupResult.FOUND;
        } else if (!bl) {
            lookupResult = PySdkToInstallCollector.Companion.LookupResult.NOT_FOUND;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PySdkToInstallCollector.Companion.logSdkLookup$intellij_python_community_impl(project, string, lookupResult);
        return (PyDetectedSdk)((Object)CollectionsKt.firstOrNull((List)object));
    }

    public static final /* synthetic */ PyDetectedSdk access$findInstalledSdk(PySdkToInstallManager $this, LanguageLevel languageLevel, Project project, Function0 systemWideSdksDetector) {
        return $this.findInstalledSdk(languageLevel, project, (Function0<? extends List<? extends PyDetectedSdk>>)systemWideSdksDetector);
    }

    static {
        Object[] objectArray = new ResourceTypeReleaseInstaller[]{new ExeReleaseInstaller(), new PkgReleaseInstaller()};
        installers = CollectionsKt.listOf((Object[])objectArray);
    }
}

