/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkToInstallManager;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.installer.ReleaseInstaller;
import com.jetbrains.python.sdk.installer.ReleasePreview;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\fH\u0007J(\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00140\u0013H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstall;", "Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;", "installer", "Lcom/jetbrains/python/sdk/installer/ReleaseInstaller;", "release", "Lcom/jetbrains/python/sdk/Release;", "(Lcom/jetbrains/python/sdk/installer/ReleaseInstaller;Lcom/jetbrains/python/sdk/Release;)V", "getInstaller", "()Lcom/jetbrains/python/sdk/installer/ReleaseInstaller;", "getRelease", "()Lcom/jetbrains/python/sdk/Release;", "getInstallationWarning", "", "defaultButtonName", "install", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "module", "Lcom/intellij/openapi/module/Module;", "systemWideSdksDetector", "Lkotlin/Function0;", "", "renderInList", "", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "intellij.python.community.impl"})
public final class PySdkToInstall
extends ProjectJdkImpl {
    @NotNull
    private final ReleaseInstaller installer;
    @NotNull
    private final Release release;

    public PySdkToInstall(@NotNull ReleaseInstaller installer, @NotNull Release release) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        super(release.getTitle(), (SdkTypeId)PythonSdkType.getInstance(), null, release.getVersion().toString());
        this.installer = installer;
        this.release = release;
    }

    @NotNull
    public final ReleaseInstaller getInstaller() {
        return this.installer;
    }

    @NotNull
    public final Release getRelease() {
        return this.release;
    }

    public final void renderInList(@NotNull SimpleColoredComponent renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(this.getName());
        ReleasePreview preview = this.installer.getPreview(this.release);
        renderer.append(" " + preview.getDescription(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        renderer.setIcon(AllIcons.Actions.Download);
    }

    @NlsContexts.DialogMessage
    @NotNull
    public final String getInstallationWarning(@NlsContexts.Button @NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        ReleasePreview preview = this.installer.getPreview(this.release);
        String string = StringUtil.formatFileSize((long)preview.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String fileSize = string;
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[1];
        Object[] objectArray = new Object[]{HtmlChunk.text((String)"...").bold(), "python.exe"};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.specify.path", objectArray));
        htmlChunkArray[0] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        htmlChunkArray2 = new HtmlChunk[1];
        objectArray = new Object[]{HtmlChunk.text((String)defaultButtonName).bold(), fileSize};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.download.and.install", objectArray));
        htmlChunkArray[1] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        String string2 = new HtmlBuilder().append(PyBundle.message("python.sdk.executable.not.found.header", new Object[0])).append((HtmlChunk)HtmlChunk.tag((String)"ul").children(htmlChunkArray)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @RequiresEdt
    @Nullable
    public final PyDetectedSdk install(@Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        return PySdkToInstallManager.INSTANCE.install(this, module, systemWideSdksDetector);
    }
}

