/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PythonRunConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.configuration.PythonConfigurationFragmentedEditor;
import java.io.File;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRunConfiguration
extends AbstractPythonRunConfiguration<PythonRunConfiguration>
implements AbstractPythonRunConfigurationParams,
PythonRunConfigurationParams,
RefactoringListenerProvider,
InputRedirectAware {
    public static final String SCRIPT_NAME = "SCRIPT_NAME";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String MULTIPROCESS = "MULTIPROCESS";
    public static final String SHOW_COMMAND_LINE = "SHOW_COMMAND_LINE";
    public static final String EMULATE_TERMINAL = "EMULATE_TERMINAL";
    public static final String MODULE_MODE = "MODULE_MODE";
    public static final String REDIRECT_INPUT = "REDIRECT_INPUT";
    public static final String INPUT_FILE = "INPUT_FILE";
    private static final Pattern QUALIFIED_NAME = Pattern.compile("^[\\p{javaJavaIdentifierPart}-.]*\\p{javaJavaIdentifierPart}$");
    private String myScriptName;
    private String myScriptParameters;
    private boolean myShowCommandLineAfterwards = false;
    private boolean myEmulateTerminal = false;
    private boolean myModuleMode = false;
    @NotNull
    private String myInputFile = "";
    private boolean myRedirectInput = false;

    protected PythonRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
        this.setUnbufferedEnv();
    }

    @Override
    protected boolean isNewUiSupported() {
        return true;
    }

    @Override
    protected SettingsEditor<PythonRunConfiguration> createConfigurationEditor() {
        if (Registry.is((String)"python.new.run.config", (boolean)false)) {
            return new PythonConfigurationFragmentedEditor(this);
        }
        return new PythonRunConfigurationEditor(this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PythonRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PythonRunConfiguration.$$$reportNull$$$0(1);
        }
        return new PythonScriptCommandLineState(this, env);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myScriptName)) {
            throw new RuntimeConfigurationException(PyBundle.message(this.isModuleMode() ? "runcfg.unittest.no_module_name" : "runcfg.unittest.no_script_name", new Object[0]));
        }
        if (this.isModuleMode() && !QUALIFIED_NAME.matcher(this.myScriptName).matches()) {
            throw new RuntimeConfigurationWarning(PyBundle.message("python.provide.a.qualified.name.of.a.module", new Object[0]));
        }
        if (this.isRedirectInput() && !new File(this.myInputFile).exists()) {
            throw new RuntimeConfigurationWarning(PyBundle.message("python.input.file.doesn.t.exist", new Object[0]));
        }
    }

    public String suggestedName() {
        String scriptName = this.getScriptName();
        if (scriptName == null) {
            return null;
        }
        String name2 = new File(scriptName).getName();
        if (name2.endsWith(".py")) {
            return name2.substring(0, name2.length() - 3);
        }
        return name2;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.myScriptName = scriptName;
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParameters;
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParameters = scriptParameters;
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineAfterwards;
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineAfterwards = showCommandLineAfterwards;
    }

    @Override
    public boolean emulateTerminal() {
        return this.myEmulateTerminal;
    }

    @Override
    public void setEmulateTerminal(boolean emulateTerminal2) {
        this.myEmulateTerminal = emulateTerminal2;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        if (element == null) {
            PythonRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_NAME);
        this.myScriptParameters = JDOMExternalizerUtil.readField((Element)element, (String)PARAMETERS);
        this.myShowCommandLineAfterwards = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)SHOW_COMMAND_LINE, (String)"false"));
        this.myEmulateTerminal = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EMULATE_TERMINAL, (String)"false"));
        this.myModuleMode = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)MODULE_MODE, (String)"false"));
        this.myRedirectInput = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)REDIRECT_INPUT, (String)"false"));
        this.myInputFile = JDOMExternalizerUtil.readField((Element)element, (String)INPUT_FILE, (String)"");
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PythonRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_NAME, (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element, (String)PARAMETERS, (String)this.myScriptParameters);
        JDOMExternalizerUtil.writeField((Element)element, (String)SHOW_COMMAND_LINE, (String)Boolean.toString(this.myShowCommandLineAfterwards));
        JDOMExternalizerUtil.writeField((Element)element, (String)EMULATE_TERMINAL, (String)Boolean.toString(this.myEmulateTerminal));
        JDOMExternalizerUtil.writeField((Element)element, (String)MODULE_MODE, (String)Boolean.toString(this.myModuleMode));
        JDOMExternalizerUtil.writeField((Element)element, (String)REDIRECT_INPUT, (String)Boolean.toString(this.myRedirectInput));
        JDOMExternalizerUtil.writeField((Element)element, (String)INPUT_FILE, (String)this.myInputFile);
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    @NotNull
    public InputRedirectAware.InputRedirectOptions getInputRedirectOptions() {
        return new InputRedirectAware.InputRedirectOptions(){

            public boolean isRedirectInput() {
                return PythonRunConfiguration.this.isRedirectInput();
            }

            public void setRedirectInput(boolean value) {
                PythonRunConfiguration.this.setRedirectInput(value);
            }

            @Nullable
            public String getRedirectInputPath() {
                return StringUtil.nullize((String)PythonRunConfiguration.this.getInputFile());
            }

            public void setRedirectInputPath(String value) {
                PythonRunConfiguration.this.setInputFile(StringUtil.notNullize((String)value));
            }
        };
    }

    public static void copyParams(PythonRunConfigurationParams source, PythonRunConfigurationParams target) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target.getBaseParams());
        target.setModuleMode(source.isModuleMode());
        target.setScriptName(source.getScriptName());
        target.setScriptParameters(source.getScriptParameters());
        target.setShowCommandLineAfterwards(source.showCommandLineAfterwards());
        target.setEmulateTerminal(source.emulateTerminal());
        target.setRedirectInput(source.isRedirectInput());
        target.setInputFile(source.getInputFile());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        VirtualFile virtualFile;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null && Objects.equals(new File(virtualFile.getPath()).getAbsolutePath(), new File(this.myScriptName).getAbsolutePath())) {
            return new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    VirtualFile virtualFile;
                    if (newElement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((virtualFile = ((PsiFile)newElement).getVirtualFile()) != null) {
                        this.updateScriptName(virtualFile.getPath());
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    this.updateScriptName(oldQualifiedName);
                }

                private void updateScriptName(String path2) {
                    PythonRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)path2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/run/PythonRunConfiguration$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    @Override
    public boolean isModuleMode() {
        return this.myModuleMode;
    }

    @Override
    public void setModuleMode(boolean moduleMode) {
        this.myModuleMode = moduleMode;
    }

    @Override
    @NotNull
    public String getInputFile() {
        String string = this.myInputFile;
        if (string == null) {
            PythonRunConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setInputFile(@NotNull String inputFile) {
        if (inputFile == null) {
            PythonRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myInputFile = inputFile;
    }

    @Override
    public boolean isRedirectInput() {
        return this.myRedirectInput;
    }

    @Override
    public void setRedirectInput(boolean isRedirectInput) {
        this.myRedirectInput = isRedirectInput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInputFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

