/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class ConvertDocstringQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.convert.single.quoted.docstring", new Object[0]);
        if (string == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement expression;
        if (project == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(2);
        }
        if ((expression = descriptor2.getPsiElement()) instanceof PyStringLiteralExpression && expression.isWritable()) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            String stringText = expression.getText();
            int prefixLength = PyStringLiteralUtil.getPrefixLength(stringText);
            String prefix = stringText.substring(0, prefixLength);
            String content2 = stringText.substring(prefixLength);
            if (content2.startsWith("'''")) {
                content2 = content2.substring(3, content2.length() - 3);
            } else {
                if (content2.startsWith("\"\"\"")) {
                    return;
                }
                String string = content2 = content2.length() == 1 ? "" : content2.substring(1, content2.length() - 1);
            }
            if (content2.endsWith("\"")) {
                content2 = StringUtil.replaceSubstring((String)content2, (TextRange)TextRange.create((int)(content2.length() - 1), (int)content2.length()), (String)"\\\"");
            }
            PyExpression newString = elementGenerator.createDocstring(prefix + "\"\"\"" + content2 + "\"\"\"").getExpression();
            expression.replace((PsiElement)newString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

