/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeIntention
extends PyBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            TypeIntention.$$$reportNull$$$0(0);
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        this.updateText(false);
        if (this.findOnlySuitableParameter(editor2, file) != null) {
            return true;
        }
        if (this.findOnlySuitableFunction(editor2, file) != null) {
            this.updateText(true);
            return true;
        }
        return false;
    }

    @Nullable
    protected final PyFunction findOnlySuitableFunction(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            TypeIntention.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(2);
        }
        return TypeIntention.findOnlySuitableFunction(editor2, file, input -> !this.isReturnTypeDefined((PyFunction)input));
    }

    @Nullable
    public static PyFunction findOnlySuitableFunction(@NotNull Editor editor2, @NotNull PsiFile file, Predicate<PyFunction> condition2) {
        PsiElement elementAt;
        if (editor2 == null) {
            TypeIntention.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(4);
        }
        return (elementAt = TypeIntention.getElementUnderCaret(editor2, file)) != null ? (PyFunction)ContainerUtil.getOnlyItem(TypeIntention.findSuitableFunctions(elementAt, condition2)) : null;
    }

    @Nullable
    protected final PyNamedParameter findOnlySuitableParameter(@NotNull Editor editor2, @NotNull PsiFile file) {
        PyReferenceExpression referenceExpr;
        PsiElement elementAt;
        PyNamedParameter immediateParam;
        if (editor2 == null) {
            TypeIntention.$$$reportNull$$$0(5);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(6);
        }
        StreamEx parameters = (immediateParam = (PyNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = TypeIntention.getElementUnderCaret(editor2, file)), PyNamedParameter.class)) != null ? StreamEx.of((Object)immediateParam) : ((referenceExpr = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class)) != null ? StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)referenceExpr, TypeIntention.getResolveContext(elementAt))).select(PyNamedParameter.class) : StreamEx.empty());
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)file.getProject());
        return ((StreamEx)((StreamEx)((StreamEx)((StreamEx)parameters.filter(param -> !param.isSelf())).filter(param -> PsiTreeUtil.getParentOfType((PsiElement)param, PyLambdaExpression.class) == null)).filter(param -> {
            VirtualFile dir = param.getContainingFile().getOriginalFile().getVirtualFile();
            return dir != null && !index.isInLibraryClasses(dir);
        })).filter(param -> !this.isParamTypeDefined((PyNamedParameter)param))).findFirst().orElse(null);
    }

    @Nullable
    private static PsiElement getElementUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            TypeIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            TypeIntention.$$$reportNull$$$0(8);
        }
        int offset = TargetElementUtilBase.adjustOffset((PsiFile)file, (Document)editor2.getDocument(), (int)editor2.getCaretModel().getOffset());
        return PyUtil.findNonWhitespaceAtOffset(file, offset);
    }

    protected abstract void updateText(boolean var1);

    protected abstract boolean isParamTypeDefined(@NotNull PyNamedParameter var1);

    protected abstract boolean isReturnTypeDefined(@NotNull PyFunction var1);

    @NotNull
    private static List<PyFunction> findSuitableFunctions(@NotNull PsiElement elementAt, @NotNull Predicate<PyFunction> extraCondition) {
        PyFunction immediateDefinition;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(9);
        }
        if (extraCondition == null) {
            TypeIntention.$$$reportNull$$$0(10);
        }
        StreamEx definitions = (immediateDefinition = TypeIntention.findFunctionDefinitionUnderCaret(elementAt)) != null ? StreamEx.of((Object)immediateDefinition) : StreamEx.of(TypeIntention.getCallExpressions(elementAt)).flatMap(call -> StreamEx.of(call.multiResolveCallee(TypeIntention.getResolveContext(elementAt)))).map(result2 -> result2.getCallable()).select(PyFunction.class);
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)elementAt.getProject());
        List list = ((StreamEx)((StreamEx)definitions.filter(elem -> {
            VirtualFile dir = elem.getContainingFile().getOriginalFile().getVirtualFile();
            return dir != null && !index.isInLibraryClasses(dir);
        })).filter(extraCondition)).toList();
        if (list == null) {
            TypeIntention.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private static PyFunction findFunctionDefinitionUnderCaret(@NotNull PsiElement elementAt) {
        ASTNode nameNode;
        PyFunction parentFunction;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(12);
        }
        if ((parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class)) != null && (nameNode = parentFunction.getNameNode()) != null) {
            PsiElement prev = elementAt.getContainingFile().findElementAt(elementAt.getTextOffset() - 1);
            if (nameNode.getPsi() == elementAt || nameNode.getPsi() == prev) {
                return parentFunction;
            }
        }
        return null;
    }

    @NotNull
    private static List<PyCallExpression> getCallExpressions(@NotNull PsiElement elementAt) {
        PyExpression assignedValue;
        List calls;
        if (elementAt == null) {
            TypeIntention.$$$reportNull$$$0(13);
        }
        PyResolveContext context = TypeIntention.getResolveContext(elementAt);
        PyReferenceExpression referenceExpr = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class);
        if (referenceExpr != null && !(calls = ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)referenceExpr, context)).select(PyTargetExpression.class).filter(target -> context.getTypeEvalContext().maySwitchToAST((PsiElement)target))).map(target -> target.findAssignedValue()).select(PyCallExpression.class).toList()).isEmpty()) {
            List list = calls;
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(14);
            }
            return list;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyAssignmentStatement.class);
        if (assignment != null && (assignedValue = assignment.getAssignedValue()) instanceof PyCallExpression) {
            List<PyCallExpression> list = Collections.singletonList((PyCallExpression)assignedValue);
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(15);
            }
            return list;
        }
        PyCallExpression immediateCall = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyCallExpression.class, (boolean)false);
        if (immediateCall != null) {
            List<PyCallExpression> list = Collections.singletonList(immediateCall);
            if (list == null) {
                TypeIntention.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<PyCallExpression> list = Collections.emptyList();
        if (list == null) {
            TypeIntention.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static PyResolveContext getResolveContext(@NotNull PsiElement origin) {
        if (origin == null) {
            TypeIntention.$$$reportNull$$$0(18);
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(origin.getProject(), origin.getContainingFile());
        return PyResolveContext.defaultContext(typeEvalContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraCondition";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/TypeIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableFunctions";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOnlySuitableFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOnlySuitableParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementUnderCaret";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunctions";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDefinitionUnderCaret";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallExpressions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getResolveContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

