/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.console;

import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.ide.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ArrayUtil;
import com.jetbrains.commandInterface.console.ConsoleStopProcessAction;
import com.jetbrains.commandInterface.console.ConsoleWithProcess;
import com.jetbrains.python.PyBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PanelWithActions
extends JPanel {
    private final JComponent myDataComponent;

    private PanelWithActions(@NotNull JComponent dataComponent, @NotNull Collection<Runnable> closeListeners, @Nullable JComponent actionListenerComponent, AnAction ... customActions) {
        if (dataComponent == null) {
            PanelWithActions.$$$reportNull$$$0(0);
        }
        if (closeListeners == null) {
            PanelWithActions.$$$reportNull$$$0(1);
        }
        if (customActions == null) {
            PanelWithActions.$$$reportNull$$$0(2);
        }
        this.myDataComponent = dataComponent;
        BoxLayout layout = new BoxLayout(this, 2);
        this.setLayout(layout);
        ArrayList<AnAction> actionList = new ArrayList<AnAction>(Arrays.asList(customActions));
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        actionList.add((AnAction)new MyCloseAction(closeListeners));
        toolbarActions.addAll(actionList);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(dataComponent);
        this.add(toolbar.getComponent());
        this.add(dataComponent);
        if (actionListenerComponent != null) {
            AbstractConsoleRunnerWithHistory.registerActionShortcuts(actionList, (JComponent)actionListenerComponent);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.myDataComponent.isFocusable();
    }

    @Override
    public void requestFocus() {
        this.myDataComponent.requestFocus();
    }

    @NotNull
    public static JComponent createConsolePanelWithActions(@NotNull ConsoleWithProcess consoleWithProcess, @Nullable JComponent actionListenerComponent, @Nullable Collection<? extends Runnable> closeListeners, AnAction ... customActions) {
        if (consoleWithProcess == null) {
            PanelWithActions.$$$reportNull$$$0(3);
        }
        if (customActions == null) {
            PanelWithActions.$$$reportNull$$$0(4);
        }
        ConsoleStopProcessAction stopProcessAction = new ConsoleStopProcessAction(consoleWithProcess);
        ArrayList<Runnable> resultCloseListeners = new ArrayList<Runnable>(Collections.singleton(stopProcessAction));
        if (closeListeners != null) {
            resultCloseListeners.addAll(closeListeners);
        }
        AnAction[] resultActions = (AnAction[])ArrayUtil.mergeArrays((Object[])new AnAction[]{stopProcessAction}, (Object[])customActions);
        return new PanelWithActions(consoleWithProcess.getComponent(), resultCloseListeners, actionListenerComponent, resultActions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeListeners";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customActions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleWithProcess";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/commandInterface/console/PanelWithActions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConsolePanelWithActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyCloseAction
    extends CloseAction {
        @NotNull
        private final Collection<Runnable> myCloseListeners;

        MyCloseAction(@NotNull Collection<Runnable> closeListeners) {
            if (closeListeners == null) {
                MyCloseAction.$$$reportNull$$$0(0);
            }
            this.myCloseListeners = new ArrayList<Runnable>();
            this.myCloseListeners.addAll(closeListeners);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCloseAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setText(PyBundle.messagePointer("windowWithActions.closeWindow", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCloseAction.$$$reportNull$$$0(2);
            }
            super.actionPerformed(e);
            for (Runnable closeListener : this.myCloseListeners) {
                closeListener.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeListeners";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/commandInterface/console/PanelWithActions$MyCloseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

