/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.completion;

import com.intellij.terminal.completion.CommandPartNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.terminal.completion.ShellCommand;
import org.jetbrains.terminal.completion.ShellCommandParserDirectives;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/terminal/completion/SubcommandNode;", "Lcom/intellij/terminal/completion/CommandPartNode;", "Lorg/jetbrains/terminal/completion/ShellCommand;", "text", "", "spec", "parent", "(Ljava/lang/String;Lorg/jetbrains/terminal/completion/ShellCommand;Lcom/intellij/terminal/completion/CommandPartNode;)V", "getSpec", "()Lorg/jetbrains/terminal/completion/ShellCommand;", "getMergedParserDirectives", "Lorg/jetbrains/terminal/completion/ShellCommandParserDirectives;", "mergeDirectives", "base", "child", "intellij.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nCommandPartNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandPartNodes.kt\ncom/intellij/terminal/completion/SubcommandNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n2661#2,7:49\n*S KotlinDebug\n*F\n+ 1 CommandPartNodes.kt\ncom/intellij/terminal/completion/SubcommandNode\n*L\n28#1:49,7\n*E\n"})
public final class SubcommandNode
extends CommandPartNode<ShellCommand> {
    @NotNull
    private final ShellCommand spec;

    public SubcommandNode(@NotNull String text, @NotNull ShellCommand spec, @Nullable CommandPartNode<?> parent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        super(text, spec, parent);
        this.spec = spec;
    }

    @Override
    @NotNull
    public ShellCommand getSpec() {
        return this.spec;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShellCommandParserDirectives getMergedParserDirectives() {
        List directives = new ArrayList();
        directives.add(this.getSpec().getParserDirectives());
        CommandPartNode<?> cur = this.getParent();
        while (cur instanceof SubcommandNode) {
            directives.add(((SubcommandNode)cur).getSpec().getParserDirectives());
            cur = cur.getParent();
        }
        Iterable $this$reduce$iv = CollectionsKt.asReversedMutable((List)directives);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void child;
            ShellCommandParserDirectives shellCommandParserDirectives = (ShellCommandParserDirectives)iterator$iv.next();
            ShellCommandParserDirectives base = (ShellCommandParserDirectives)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeDirectives(base, (ShellCommandParserDirectives)child);
        }
        return (ShellCommandParserDirectives)accumulator$iv;
    }

    private final ShellCommandParserDirectives mergeDirectives(ShellCommandParserDirectives base, ShellCommandParserDirectives child) {
        boolean flagsArePosixNoncompliant = child.getFlagsArePosixNoncompliant() ? true : base.getFlagsArePosixNoncompliant();
        boolean optionsMustPrecedeArguments = child.getOptionsMustPrecedeArguments() ? true : base.getOptionsMustPrecedeArguments();
        List optionArgSeparators = CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)base.getOptionArgSeparators(), (Iterable)child.getOptionArgSeparators())));
        return new ShellCommandParserDirectives(flagsArePosixNoncompliant, optionsMustPrecedeArguments, optionArgSeparators);
    }
}

