/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.action;

import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/action/GitLabURIUtil;", "", "()V", "getWebURI", "Ljava/net/URI;", "repository", "revisionOrBranch", "", "relativePath", "lineRange", "Lkotlin/ranges/IntRange;", "intellij.vcs.gitlab"})
public final class GitLabURIUtil {
    @NotNull
    public static final GitLabURIUtil INSTANCE = new GitLabURIUtil();

    private GitLabURIUtil() {
    }

    @NotNull
    public final URI getWebURI(@NotNull URI repository, @NotNull String revisionOrBranch) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        return URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"commit"), (String)revisionOrBranch);
    }

    @NotNull
    public final URI getWebURI(@NotNull URI repository, @NotNull String revisionOrBranch, @NotNull String relativePath, @Nullable IntRange lineRange) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        URI uRI2 = URIUtilKt.resolveRelative((URI)URIUtilKt.resolveRelative((URI)repository, (String)"blob"), (String)revisionOrBranch);
        String string = URLUtil.encodePath((String)relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodePath(...)");
        URI fileUri = URIUtilKt.resolveRelative((URI)uRI2, (String)string);
        if (lineRange != null) {
            StringBuilder fragmentBuilder = new StringBuilder();
            fragmentBuilder.append("L").append(lineRange.getFirst() + 1);
            if (lineRange.getLast() != lineRange.getFirst()) {
                fragmentBuilder.append("-L").append(lineRange.getLast() + 1);
            }
            uRI = UriUtilKt.withFragment((URI)fileUri, (String)fragmentBuilder.toString());
        } else {
            uRI = fileUri;
        }
        return uRI;
    }
}

