/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.semantics.experiments;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments;", "", "()V", "experimentGroup", "", "getExperimentGroup", "()I", "getSemanticFeatureForTab", "Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$SemanticSearchFeature;", "providerId", "", "Companion", "SemanticSearchFeature", "TabExperimentPlan", "intellij.searchEverywhereMl.semantics"})
public final class SearchEverywhereSemanticExperiments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int GRANULARITY = 4;
    @NotNull
    private static final HashMap<String, TabExperimentPlan> TAB_EXPERIMENTS;

    public final int getExperimentGroup() {
        int experimentGroup = EventLogConfiguration.Companion.getInstance().getBucket() % 4;
        int registryExperimentGroup = Registry.intValue((String)"search.everywhere.ml.experiment.group", (int)-1, (int)-1, (int)3);
        return registryExperimentGroup >= 0 ? registryExperimentGroup : experimentGroup;
    }

    @NotNull
    public final SemanticSearchFeature getSemanticFeatureForTab(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Object object = TAB_EXPERIMENTS.get(providerId);
        if (object == null || (object = object.getSemanticFeatureByGroup(this.getExperimentGroup())) == null) {
            object = SemanticSearchFeature.NOT_ENABLED;
        }
        return object;
    }

    static {
        Pair[] pairArray = new Pair[1];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)SemanticSearchFeature.ENABLED))};
        pairArray[0] = TuplesKt.to((Object)ActionSearchEverywhereContributor.class.getSimpleName(), (Object)new TabExperimentPlan(pairArray2));
        TAB_EXPERIMENTS = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a.\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u0016\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$Companion;", "", "()V", "GRANULARITY", "", "TAB_EXPERIMENTS", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$TabExperimentPlan;", "Lkotlin/collections/HashMap;", "getInstance", "Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments;", "intellij.searchEverywhereMl.semantics"})
    @SourceDebugExtension(value={"SMAP\nSearchEverywhereSemanticExperiments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereSemanticExperiments.kt\ncom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,47:1\n43#2,3:48\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereSemanticExperiments.kt\ncom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$Companion\n*L\n45#1:48,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchEverywhereSemanticExperiments getInstance() {
            boolean $i$f$service = false;
            Class<SearchEverywhereSemanticExperiments> serviceClass$iv = SearchEverywhereSemanticExperiments.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (SearchEverywhereSemanticExperiments)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$SemanticSearchFeature;", "", "(Ljava/lang/String;I)V", "NOT_ENABLED", "ENABLED", "intellij.searchEverywhereMl.semantics"})
    public static final class SemanticSearchFeature
    extends Enum<SemanticSearchFeature> {
        public static final /* enum */ SemanticSearchFeature NOT_ENABLED = new SemanticSearchFeature();
        public static final /* enum */ SemanticSearchFeature ENABLED = new SemanticSearchFeature();
        private static final /* synthetic */ SemanticSearchFeature[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SemanticSearchFeature[] values() {
            return (SemanticSearchFeature[])$VALUES.clone();
        }

        public static SemanticSearchFeature valueOf(String value) {
            return Enum.valueOf(SemanticSearchFeature.class, value);
        }

        @NotNull
        public static EnumEntries<SemanticSearchFeature> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = semanticSearchFeatureArray = new SemanticSearchFeature[]{SemanticSearchFeature.NOT_ENABLED, SemanticSearchFeature.ENABLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\tj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$TabExperimentPlan;", "", "mapping", "", "Lkotlin/Pair;", "", "Lcom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$SemanticSearchFeature;", "([Lkotlin/Pair;)V", "groupFeatures", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSemanticFeatureByGroup", "group", "intellij.searchEverywhereMl.semantics"})
    @SourceDebugExtension(value={"SMAP\nSearchEverywhereSemanticExperiments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereSemanticExperiments.kt\ncom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$TabExperimentPlan\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,47:1\n12271#2,2:48\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereSemanticExperiments.kt\ncom/intellij/searchEverywhereMl/semantics/experiments/SearchEverywhereSemanticExperiments$TabExperimentPlan\n*L\n26#1:48,2\n*E\n"})
    public static final class TabExperimentPlan {
        @NotNull
        private final HashMap<Integer, SemanticSearchFeature> groupFeatures;

        public TabExperimentPlan(Pair<Integer, ? extends SemanticSearchFeature> ... mapping) {
            boolean bl;
            block2: {
                Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
                this.groupFeatures = MapsKt.hashMapOf(Arrays.copyOf(mapping, mapping.length));
                Pair<Integer, ? extends SemanticSearchFeature>[] $this$all$iv = mapping;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    Pair<Integer, ? extends SemanticSearchFeature> element$iv;
                    Pair<Integer, ? extends SemanticSearchFeature> it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    int n2 = ((Number)it.getFirst()).intValue();
                    if (0 <= n2 ? n2 < 4 : false) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) {
                boolean bl3 = false;
                String string = "Group number in tab experiment mapping should be between 0 and 3";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final SemanticSearchFeature getSemanticFeatureByGroup(int group) {
            SemanticSearchFeature semanticSearchFeature = this.groupFeatures.getOrDefault(group, SemanticSearchFeature.NOT_ENABLED);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)semanticSearchFeature), (String)"getOrDefault(...)");
            return semanticSearchFeature;
        }
    }
}

