"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlCommonsPlugin = void 0;

var _routes = require("./routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class MlCommonsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('mlCommons: Setup');
    const router = core.http.createRouter();
    (0, _routes.modelRouter)(router);
    (0, _routes.profileRouter)(router);
    (0, _routes.connectorRouter)(router);
    return {};
  }

  start(core) {
    this.logger.debug('mlCommons: Started');
    return {};
  }

  stop() {}

}

exports.MlCommonsPlugin = MlCommonsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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