/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.BaseDtoAllHandler;
import org.directwebremoting.util.LocalUtil;

public class DtoAllHandler
extends BaseDtoAllHandler {
    @Override
    public String generateDtoAllScript(String contextPath, String servletPath) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(function() {\n").append("  var c;\n").append("  var addedNow = [];\n");
        for (String jsClassName : this.converterManager.getNamedConverterJavaScriptNames()) {
            buffer.append("\n").append("  if (!dwr.engine._mappedClasses[\"" + jsClassName + "\"]) {\n").append(this.remoter.generateDtoJavaScript(jsClassName, "    ", "c")).append("    dwr.engine._setObject(\"" + jsClassName + "\", c);\n").append("    dwr.engine._mappedClasses[\"" + jsClassName + "\"] = c;\n").append("    addedNow[\"" + jsClassName + "\"] = true;\n").append("  }\n");
        }
        for (String jsClassName : this.converterManager.getNamedConverterJavaScriptNames()) {
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            if (!LocalUtil.hasLength(jsSuperClassName)) continue;
            String classExpression = "dwr.engine._mappedClasses[\"" + jsClassName + "\"]";
            String superClassExpression = "dwr.engine._mappedClasses[\"" + jsSuperClassName + "\"]";
            buffer.append("\n").append("  if (addedNow[\"" + jsClassName + "\"]) {\n").append(this.remoter.generateDtoInheritanceJavaScript("    ", classExpression, superClassExpression, "dwr.engine._delegate")).append("  }\n");
        }
        buffer.append("})();\n");
        return buffer.toString();
    }
}

