/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2String;
import org.pcap4j.packet.namednumber.Ssh2DisconnectionReasonCode;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2DisconnectPacket
extends AbstractPacket {
    private static final long serialVersionUID = -1484749154591150073L;
    private final Ssh2DisconnectHeader header;

    public static Ssh2DisconnectPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2DisconnectPacket(rawData, offset, length);
    }

    private Ssh2DisconnectPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2DisconnectHeader(rawData, offset, length);
    }

    private Ssh2DisconnectPacket(Builder builder2) {
        if (builder2 == null || builder2.reasonCode == null || builder2.description == null || builder2.languageTag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.reasonCode: ").append(builder2.reasonCode).append(" builder.description: ").append(builder2.description).append(" builder.languageTag: ").append(builder2.languageTag);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2DisconnectHeader(builder2);
    }

    @Override
    public Ssh2DisconnectHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2DisconnectHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 873479096967096846L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_DISCONNECT;
        private final Ssh2DisconnectionReasonCode reasonCode;
        private final Ssh2String description;
        private final Ssh2String languageTag;

        private Ssh2DisconnectHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 13) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an SSH2 Disconnect header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[offset]).equals(Ssh2MessageNumber.SSH_MSG_DISCONNECT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 Disconnect message. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            int currentOffset = 1 + offset;
            int remainingLength = length - 1;
            this.reasonCode = Ssh2DisconnectionReasonCode.getInstance(ByteArrays.getInt(rawData, currentOffset));
            this.description = new Ssh2String(rawData, currentOffset += 4, remainingLength -= 4);
            this.languageTag = new Ssh2String(rawData, currentOffset += this.description.length(), remainingLength -= this.description.length());
        }

        private Ssh2DisconnectHeader(Builder builder2) {
            this.reasonCode = builder2.reasonCode;
            this.description = builder2.description;
            this.languageTag = builder2.languageTag;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public Ssh2DisconnectionReasonCode getReasonCode() {
            return this.reasonCode;
        }

        public Ssh2String getDescription() {
            return this.description;
        }

        public Ssh2String getLanguageTag() {
            return this.languageTag;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(ByteArrays.toByteArray((Integer)this.reasonCode.value()));
            rawFields.add(this.description.getRawData());
            rawFields.add(this.languageTag.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getRawData().length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Disconnect Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  reason code: ").append(this.reasonCode).append(ls);
            sb.append("  description: ").append(this.description).append(ls);
            sb.append("  language tag: ").append(this.languageTag).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            Ssh2DisconnectHeader other = (Ssh2DisconnectHeader)obj;
            return this.reasonCode.equals(other.reasonCode) && this.description.equals(other.description) && this.languageTag.equals(other.languageTag);
        }

        @Override
        protected int calcHashCode() {
            int result2 = 17;
            result2 = 31 * result2 + this.reasonCode.hashCode();
            result2 = 31 * result2 + this.description.hashCode();
            result2 = 31 * result2 + this.languageTag.hashCode();
            return result2;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Ssh2DisconnectionReasonCode reasonCode;
        private Ssh2String description;
        private Ssh2String languageTag;

        public Builder() {
        }

        private Builder(Ssh2DisconnectPacket packet) {
            this.reasonCode = packet.header.reasonCode;
            this.description = packet.header.description;
            this.languageTag = packet.header.languageTag;
        }

        public Builder reasonCode(Ssh2DisconnectionReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public Builder description(Ssh2String description2) {
            this.description = description2;
            return this;
        }

        public Builder languageTag(Ssh2String languageTag) {
            this.languageTag = languageTag;
            return this;
        }

        @Override
        public Ssh2DisconnectPacket build() {
            return new Ssh2DisconnectPacket(this);
        }
    }
}

