/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataCName
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 3515906031137985263L;
    private final DnsDomainName cName;

    public static DnsRDataCName newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataCName(rawData, offset, length);
    }

    private DnsRDataCName(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.cName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataCName(Builder builder2) {
        if (builder2 == null || builder2.cName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.cName: ").append(builder2.cName);
            throw new NullPointerException(sb.toString());
        }
        this.cName = builder2.cName;
    }

    public DnsDomainName getCName() {
        return this.cName;
    }

    @Override
    public int length() {
        return this.cName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.cName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("CNAME RDATA:").append(ls).append(indent).append("  CNAME: ").append(headerRawData != null ? this.cName.toString(headerRawData) : this.cName.toString()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.cName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataCName other = (DnsRDataCName)obj;
        return this.cName.equals(other.cName);
    }

    public static final class Builder {
        private DnsDomainName cName;

        public Builder() {
        }

        private Builder(DnsRDataCName obj) {
            this.cName = obj.cName;
        }

        public Builder cName(DnsDomainName cName) {
            this.cName = cName;
            return this;
        }

        public DnsRDataCName build() {
            return new DnsRDataCName(this);
        }
    }
}

