/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.tcp.TcpHostEvent;
import org.jivesoftware.smack.tcp.XmppTcpTransportModule;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;

public final class ConnectionAttemptState {
    private final ModularXmppClientToServerConnectionInternal connectionInternal;
    private final XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredEndpoints;
    private final XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState;
    final SocketChannel socketChannel;
    final List<RemoteConnectionException<?>> connectionExceptions;
    SmackException.EndpointConnectionException connectionException;
    boolean connected;
    long deadline;
    final Iterator<Rfc6120TcpRemoteConnectionEndpoint> connectionEndpointIterator;
    Rfc6120TcpRemoteConnectionEndpoint connectionEndpoint;
    Iterator<? extends InetAddress> inetAddressIterator;

    ConnectionAttemptState(ModularXmppClientToServerConnectionInternal connectionInternal, XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredEndpoints, XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState) throws IOException {
        this.connectionInternal = connectionInternal;
        this.discoveredEndpoints = discoveredEndpoints;
        this.establishingTcpConnectionState = establishingTcpConnectionState;
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        List endpoints = discoveredEndpoints.result.discoveredRemoteConnectionEndpoints;
        this.connectionEndpointIterator = endpoints.iterator();
        this.connectionExceptions = new ArrayList(endpoints.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StateTransitionResult.Failure establishTcpConnection() throws InterruptedException {
        RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> address = this.nextAddress();
        this.establishTcpConnection(address);
        ConnectionAttemptState connectionAttemptState = this;
        synchronized (connectionAttemptState) {
            while (!this.connected && this.connectionException == null) {
                long now = System.currentTimeMillis();
                if (now >= this.deadline) {
                    return new StateTransitionResult.FailureCausedByTimeout("Timeout waiting to establish connection");
                }
                this.wait(this.deadline - now);
            }
        }
        if (this.connected) {
            assert (this.connectionException == null);
            return null;
        }
        return new StateTransitionResult.FailureCausedByException<SmackException.EndpointConnectionException>(this.connectionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishTcpConnection(RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> address) {
        TcpHostEvent.ConnectingToHostEvent connectingToHostEvent = new TcpHostEvent.ConnectingToHostEvent(this.establishingTcpConnectionState, address);
        this.connectionInternal.invokeConnectionStateMachineListener(connectingToHostEvent);
        InetSocketAddress inetSocketAddress = address.getInetSocketAddress();
        this.deadline = System.currentTimeMillis() + this.connectionInternal.connection.getReplyTimeout();
        try {
            this.connected = this.socketChannel.connect(inetSocketAddress);
        }
        catch (IOException e) {
            this.onIOExceptionWhenEstablishingTcpConnection(e, address);
            return;
        }
        if (this.connected) {
            TcpHostEvent.ConnectedToHostEvent connectedToHostEvent = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, address, true);
            this.connectionInternal.invokeConnectionStateMachineListener(connectedToHostEvent);
            ConnectionAttemptState connectionAttemptState = this;
            synchronized (connectionAttemptState) {
                this.notifyAll();
            }
            return;
        }
        try {
            this.connectionInternal.registerWithSelector(this.socketChannel, 8, (selectedChannel, selectedSelectionKey) -> {
                boolean finishConnected;
                SocketChannel selectedSocketChannel = (SocketChannel)selectedChannel;
                try {
                    finishConnected = selectedSocketChannel.finishConnect();
                }
                catch (IOException e) {
                    Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(e, address));
                    return;
                }
                if (!finishConnected) {
                    Async.go(() -> this.onIOExceptionWhenEstablishingTcpConnection(new IOException("finishConnect() failed"), address));
                    return;
                }
                TcpHostEvent.ConnectedToHostEvent connectedToHostEvent = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, address, false);
                this.connectionInternal.invokeConnectionStateMachineListener(connectedToHostEvent);
                this.connected = true;
                ConnectionAttemptState connectionAttemptState = this;
                synchronized (connectionAttemptState) {
                    this.notifyAll();
                }
            });
        }
        catch (ClosedChannelException e) {
            this.onIOExceptionWhenEstablishingTcpConnection(e, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIOExceptionWhenEstablishingTcpConnection(IOException exception, RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> failedAddress) {
        RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> nextInetSocketAddress = this.nextAddress();
        if (nextInetSocketAddress == null) {
            this.connectionException = SmackException.EndpointConnectionException.from(this.discoveredEndpoints.result.lookupFailures, this.connectionExceptions);
            ConnectionAttemptState connectionAttemptState = this;
            synchronized (connectionAttemptState) {
                this.notifyAll();
            }
            return;
        }
        RemoteConnectionException<Rfc6120TcpRemoteConnectionEndpoint> rce = new RemoteConnectionException<Rfc6120TcpRemoteConnectionEndpoint>(failedAddress, exception);
        this.connectionExceptions.add(rce);
        TcpHostEvent.ConnectionToHostFailedEvent connectionToHostFailedEvent = new TcpHostEvent.ConnectionToHostFailedEvent(this.establishingTcpConnectionState, nextInetSocketAddress, exception);
        this.connectionInternal.invokeConnectionStateMachineListener(connectionToHostFailedEvent);
        this.establishTcpConnection(nextInetSocketAddress);
    }

    private RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> nextAddress() {
        if (this.inetAddressIterator == null || !this.inetAddressIterator.hasNext()) {
            if (!this.connectionEndpointIterator.hasNext()) {
                return null;
            }
            this.connectionEndpoint = this.connectionEndpointIterator.next();
            this.inetAddressIterator = this.connectionEndpoint.getInetAddresses().iterator();
            assert (this.inetAddressIterator.hasNext());
        }
        InetAddress inetAddress = this.inetAddressIterator.next();
        return new RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>(this.connectionEndpoint, inetAddress);
    }
}

