/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class XmlEnvironment {
    public static final XmlEnvironment EMPTY = new XmlEnvironment((String)null);
    private final String namespace;
    private final String language;
    private final XmlEnvironment next;
    private transient boolean effectiveNamespaceDetermined;
    private transient boolean effectiveLanguageDetermined;
    private transient String effectiveNamespace;
    private transient String effectiveLanguage;
    private transient String toStringCache;

    public XmlEnvironment(String namespace) {
        this(namespace, null);
    }

    public XmlEnvironment(String namespace, String language) {
        this(namespace, language, null);
    }

    private XmlEnvironment(Builder builder2) {
        this(builder2.namespace, builder2.language, builder2.next);
    }

    public XmlEnvironment(String namespace, String language, XmlEnvironment next) {
        this.namespace = namespace;
        this.language = language;
        this.next = next;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEffectiveNamespace() {
        if (this.effectiveNamespaceDetermined) {
            return this.effectiveNamespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.namespace)) {
            this.effectiveNamespace = this.namespace;
        } else if (this.next != null) {
            this.effectiveNamespace = this.next.getEffectiveNamespace();
        }
        this.effectiveNamespaceDetermined = true;
        return this.effectiveNamespace;
    }

    public String getEffectiveNamespaceOrUse(String namespace) {
        String effectiveNamespace = this.getEffectiveNamespace();
        if (StringUtils.isNullOrEmpty((CharSequence)effectiveNamespace)) {
            return namespace;
        }
        return effectiveNamespace;
    }

    public boolean effectiveNamespaceEquals(String namespace) {
        String effectiveNamespace = this.getEffectiveNamespace();
        if (effectiveNamespace == null) {
            return false;
        }
        return effectiveNamespace.equals(namespace);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getEffectiveLanguage() {
        if (this.effectiveLanguageDetermined) {
            return this.effectiveLanguage;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.language)) {
            this.effectiveLanguage = this.language;
        } else if (this.next != null) {
            this.effectiveLanguage = this.next.getEffectiveLanguage();
        }
        this.effectiveLanguageDetermined = true;
        return this.effectiveLanguage;
    }

    public boolean effectiveLanguageEquals(String language) {
        String effectiveLanguage = this.getEffectiveLanguage();
        if (effectiveLanguage == null) {
            return false;
        }
        return effectiveLanguage.equals(language);
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(XmlEnvironment.class.getSimpleName()).append(' ');
            sb.append("xmlns=").append(this.getEffectiveNamespace()).append(' ');
            sb.append("xmllang=").append(this.getEffectiveLanguage()).append(' ');
            this.toStringCache = sb.toString();
        }
        return this.toStringCache;
    }

    public static XmlEnvironment from(XmlPullParser parser2) {
        return XmlEnvironment.from(parser2, null);
    }

    public static XmlEnvironment from(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) {
        String namespace = parser2.getDefaultNamespace();
        String xmlLang = ParserUtils.getXmlLang(parser2);
        return new XmlEnvironment(namespace, xmlLang, outerXmlEnvironment);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String namespace;
        private String language;
        private XmlEnvironment next;

        public Builder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder withLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder withNext(XmlEnvironment next) {
            this.next = next;
            return this;
        }

        public Builder with(StreamOpen streamOpen) {
            this.withNamespace(streamOpen.getNamespace());
            this.withLanguage(streamOpen.getLanguage());
            return this;
        }

        public XmlEnvironment build() {
            return new XmlEnvironment(this);
        }
    }
}

