/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.coin.CoinIQProvider;
import org.jitsi.xmpp.extensions.coin.MediaPacketExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class MediaProvider
extends ExtensionElementProvider<MediaPacketExtension> {
    @Override
    public MediaPacketExtension parse(XmlPullParser parser2, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        String id = parser2.getAttributeValue("", "id");
        if (id == null) {
            throw new SmackParsingException.RequiredAttributeMissingException("Coin media must contains src-id element");
        }
        MediaPacketExtension ext = new MediaPacketExtension(id);
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String elementName = parser2.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                switch (elementName) {
                    case "display-text": {
                        ext.setDisplayText(CoinIQProvider.parseText(parser2));
                        break;
                    }
                    case "label": {
                        ext.setLabel(CoinIQProvider.parseText(parser2));
                        break;
                    }
                    case "src-id": {
                        ext.setSrcID(CoinIQProvider.parseText(parser2));
                        break;
                    }
                    case "status": {
                        ext.setStatus(CoinIQProvider.parseText(parser2));
                        break;
                    }
                    case "type": {
                        ext.setType(CoinIQProvider.parseText(parser2));
                    }
                }
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("media")) continue;
            done = true;
        }
        return ext;
    }
}

