/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class AbstractPacketExtension
implements ExtensionElement {
    private String namespace;
    private final String elementName;
    protected final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String textContent;
    private final List<ExtensionElement> childExtensions = new ArrayList<ExtensionElement>();

    public static <T extends AbstractPacketExtension> T clone(T src) {
        AbstractPacketExtension dst;
        try {
            dst = (AbstractPacketExtension)src.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (String name : src.getAttributeNames()) {
            dst.setAttribute(name, src.getAttribute(name));
        }
        dst.setNamespace(src.getNamespace());
        dst.setText(src.getText());
        return (T)dst;
    }

    protected AbstractPacketExtension(String namespace, String elementName) {
        this.namespace = namespace;
        this.elementName = elementName;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            Object value2 = entry.getValue();
            if (value2 == null) continue;
            xml.attribute(entry.getKey(), value2.toString());
        }
        List<? extends ExtensionElement> childElements = this.getChildExtensions();
        String text = this.getText();
        XmlStringBuilder childBuilder = this.getChildElementBuilder();
        if (childElements.isEmpty() && childBuilder.length() == 0) {
            if (org.apache.commons.lang3.StringUtils.isEmpty(text)) {
                return xml.closeEmptyElement().toString();
            }
            xml.rightAngleBracket();
        } else {
            List<? extends ExtensionElement> list = childElements;
            synchronized (list) {
                xml.rightAngleBracket();
                for (ExtensionElement extensionElement : childElements) {
                    xml.optAppend(extensionElement);
                }
                xml.append(childBuilder);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(text)) {
            xml.append(StringUtils.escapeForXmlText(text));
        }
        xml.closeElement(this.getElementName());
        return xml.toString();
    }

    public XmlStringBuilder getChildElementBuilder() {
        return new XmlStringBuilder();
    }

    public List<? extends ExtensionElement> getChildExtensions() {
        return this.childExtensions;
    }

    public void addChildExtension(ExtensionElement childExtension) {
        this.childExtensions.add(childExtension);
    }

    public void setChildExtension(ExtensionElement childExtension) {
        this.getChildExtensionsOfType(childExtension.getClass()).forEach(this::removeChildExtension);
        this.addChildExtension(childExtension);
    }

    public <T extends ExtensionElement> T getChildExtension(Class<T> type2) {
        List<T> childExts = this.getChildExtensionsOfType(type2);
        if (!childExts.isEmpty()) {
            return (T)((ExtensionElement)childExts.get(0));
        }
        return null;
    }

    public boolean removeChildExtension(ExtensionElement childExtension) {
        boolean removed = false;
        if (childExtension != null) {
            while (this.childExtensions.remove(childExtension)) {
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value2) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (value2 != null) {
                this.attributes.put(name, value2.toString());
            } else {
                this.attributes.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attribute) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeAsString(String attribute) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            Object attributeVal = this.attributes.get(attribute);
            return attributeVal == null ? null : attributeVal.toString();
        }
    }

    public int getAttributeAsInt(String attribute) {
        return this.getAttributeAsInt(attribute, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributeAsInt(String attribute, int defaultValue) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            String value2 = this.getAttributeAsString(attribute);
            return value2 == null ? defaultValue : Integer.parseInt(value2);
        }
    }

    public URI getAttributeAsURI(String attribute) throws IllegalArgumentException {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            String attributeVal = this.getAttributeAsString(attribute);
            if (attributeVal == null) {
                return null;
            }
            try {
                return new URI(attributeVal);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAttributeNames() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return new ArrayList<String>(this.attributes.keySet());
        }
    }

    public void setText(String text) {
        this.textContent = text;
    }

    public String getText() {
        return this.textContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ExtensionElement> T getFirstChildOfType(Class<T> type2) {
        List<? extends ExtensionElement> childExtensions;
        List<? extends ExtensionElement> list = childExtensions = this.getChildExtensions();
        synchronized (list) {
            for (ExtensionElement extensionElement : childExtensions) {
                if (!type2.isInstance(extensionElement)) continue;
                ExtensionElement extensionAsType = extensionElement;
                return (T)extensionAsType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ExtensionElement> List<T> getChildExtensionsOfType(Class<T> type2) {
        List<? extends ExtensionElement> childExtensions = this.getChildExtensions();
        ArrayList<ExtensionElement> result2 = new ArrayList<ExtensionElement>();
        if (childExtensions == null) {
            return result2;
        }
        List<? extends ExtensionElement> list = childExtensions;
        synchronized (list) {
            for (ExtensionElement extensionElement : childExtensions) {
                if (!type2.isInstance(extensionElement)) continue;
                ExtensionElement extensionAsType = extensionElement;
                result2.add(extensionAsType);
            }
        }
        return result2;
    }
}

