/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.VersionConfig;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.message.AddReceiverMessage;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.ClientHelloMessage;
import org.jitsi.videobridge.message.EndpointConnectionStatusMessage;
import org.jitsi.videobridge.message.EndpointMessage;
import org.jitsi.videobridge.message.EndpointStats;
import org.jitsi.videobridge.message.ServerHelloMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.message.VideoTypeMessage;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocket;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001bJ\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020)H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020/H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u000201H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u000203H\u0016J\b\u00104\u001a\u00020)H\u0014J\u001a\u00105\u001a\u00020)2\b\u00106\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020#H\u0014J\u0010\u00105\u001a\u00020)2\u0006\u00107\u001a\u00020#H\u0016J\u0018\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020,H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020)2\u0006\u0010$\u001a\u00020#H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020=H\u0016J \u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u001bH\u0016J\u0010\u0010C\u001a\u00020)2\u0006\u0010?\u001a\u00020\u001fH\u0016J\u0018\u0010D\u001a\u00020)2\u0006\u0010?\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020)2\u0006\u0010?\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001bH\u0016R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jitsi/videobridge/relay/RelayMessageTransport;", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "Lorg/jitsi/videobridge/websocket/ColibriWebSocket$EventHandler;", "relay", "Lorg/jitsi/videobridge/relay/Relay;", "statisticsSupplier", "Ljava/util/function/Supplier;", "Lorg/jitsi/videobridge/Videobridge$Statistics;", "eventHandler", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/videobridge/relay/Relay;Ljava/util/function/Supplier;Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;Lorg/jitsi/utils/logging2/Logger;)V", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "isActive", "", "()Z", "isConnected", "numOutgoingMessagesDropped", "Ljava/util/concurrent/atomic/AtomicInteger;", "outgoingWebsocket", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "sentMessagesCounts", "", "", "Ljava/util/concurrent/atomic/AtomicLong;", "url", "webSocket", "Lorg/jitsi/videobridge/websocket/ColibriWebSocket;", "webSocketSyncRoot", "", "addReceiver", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "message", "Lorg/jitsi/videobridge/message/AddReceiverMessage;", "clientHello", "Lorg/jitsi/videobridge/message/ClientHelloMessage;", "close", "", "connectTo", "createServerHello", "Lorg/jitsi/videobridge/message/ServerHelloMessage;", "doConnect", "endpointConnectionStatus", "Lorg/jitsi/videobridge/message/EndpointConnectionStatusMessage;", "endpointMessage", "Lorg/jitsi/videobridge/message/EndpointMessage;", "endpointStats", "Lorg/jitsi/videobridge/message/EndpointStats;", "notifyTransportChannelConnected", "sendMessage", "dst", "msg", "serverHello", "sourceVideoType", "Lorg/jitsi/videobridge/message/SourceVideoTypeMessage;", "unhandledMessage", "videoType", "Lorg/jitsi/videobridge/message/VideoTypeMessage;", "webSocketClosed", "ws", "statusCode", "", "reason", "webSocketConnected", "webSocketError", "cause", "", "webSocketTextReceived", "jitsi-videobridge"})
public final class RelayMessageTransport
extends AbstractEndpointMessageTransport
implements ColibriWebSocket.EventHandler {
    @NotNull
    private final Relay relay;
    @NotNull
    private final Supplier<Videobridge.Statistics> statisticsSupplier;
    @NotNull
    private final AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler;
    @Nullable
    private ColibriWebSocket webSocket;
    @Nullable
    private String url;
    @Nullable
    private WebSocketClient outgoingWebsocket;
    @NotNull
    private final Object webSocketSyncRoot;
    @NotNull
    private final AtomicInteger numOutgoingMessagesDropped;
    @NotNull
    private final Map<String, AtomicLong> sentMessagesCounts;

    public RelayMessageTransport(@NotNull Relay relay, @NotNull Supplier<Videobridge.Statistics> statisticsSupplier, @NotNull AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(relay, "relay");
        Intrinsics.checkNotNullParameter(statisticsSupplier, "statisticsSupplier");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(parentLogger);
        this.relay = relay;
        this.statisticsSupplier = statisticsSupplier;
        this.eventHandler = eventHandler;
        this.webSocketSyncRoot = new Object();
        this.numOutgoingMessagesDropped = new AtomicInteger(0);
        this.sentMessagesCounts = new ConcurrentHashMap();
        this.getLogger().addContext("relay-id", this.relay.getId());
    }

    public final void connectTo(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        if (this.url != null && Intrinsics.areEqual(this.url, url)) {
            return;
        }
        this.url = url;
        this.doConnect();
    }

    private final void doConnect() {
        Object it;
        String string = this.url;
        if (string == null) {
            throw new IllegalStateException("Cannot connect Relay transport when no URL set");
        }
        String url = string;
        ColibriWebSocket colibriWebSocket = this.webSocket;
        if (colibriWebSocket != null) {
            it = colibriWebSocket;
            boolean bl = false;
            this.getLogger().warn("Re-connecting while webSocket != null, possible leak.");
            this.webSocket = null;
        }
        ColibriWebSocket newWebSocket = new ColibriWebSocket(this.relay.getId(), this);
        WebSocketClient webSocketClient = this.outgoingWebsocket;
        if (webSocketClient != null) {
            WebSocketClient it2 = webSocketClient;
            boolean bl = false;
            this.getLogger().warn("Re-connecting while outgoingWebsocket != null, possible leak.");
            it2.stop();
        }
        WebSocketClient webSocketClient2 = new WebSocketClient();
        it = webSocketClient2;
        RelayMessageTransport relayMessageTransport = this;
        boolean bl = false;
        ((AbstractLifeCycle)it).start();
        ((WebSocketClient)it).connect(newWebSocket, new URI(url), new ClientUpgradeRequest());
        relayMessageTransport.outgoingWebsocket = webSocketClient2;
    }

    @Override
    protected void notifyTransportChannelConnected() {
        this.relay.relayMessageTransportConnected();
    }

    @Override
    @Nullable
    public BridgeChannelMessage clientHello(@NotNull ClientHelloMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.createServerHello();
    }

    @Override
    @Nullable
    public BridgeChannelMessage serverHello(@NotNull ServerHelloMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String string = message.getVersion();
        if (!(string != null ? string.equals(this.relay.getConference().getVideobridge().getVersion().toString()) : false)) {
            this.getLogger().warn(() -> RelayMessageTransport.serverHello$lambda-3(message, this));
        } else {
            this.getLogger().info(() -> RelayMessageTransport.serverHello$lambda-4(message));
        }
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage addReceiver(@NotNull AddReceiverMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String string = message.getSourceName();
        if (string == null) {
            RelayMessageTransport $this$addReceiver_u24lambda_u2d5 = this;
            boolean bl = false;
            $this$addReceiver_u24lambda_u2d5.getLogger().error("Received AddReceiverMessage for with sourceName = null");
            return null;
        }
        String sourceName = string;
        AbstractEndpoint abstractEndpoint = this.relay.getConference().findSourceOwner(sourceName);
        if (abstractEndpoint == null) {
            RelayMessageTransport $this$addReceiver_u24lambda_u2d6 = this;
            boolean bl = false;
            $this$addReceiver_u24lambda_u2d6.getLogger().warn("Received AddReceiverMessage for unknown or non-local: " + sourceName);
            return null;
        }
        AbstractEndpoint ep = abstractEndpoint;
        ep.addReceiver(this.relay.getId(), sourceName, message.getVideoConstraints());
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage videoType(@NotNull VideoTypeMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.getLogger().error("Relay: unexpected video type message: " + message.toJson());
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage sourceVideoType(@NotNull SourceVideoTypeMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String epId = message.getEndpointId();
        if (epId == null) {
            this.getLogger().warn("Received SourceVideoTypeMessage over relay channel with no endpoint ID");
            return null;
        }
        RelayedEndpoint ep = this.relay.getEndpoint(epId);
        if (ep == null) {
            this.getLogger().warn("Received SourceVideoTypeMessage for unknown epId " + epId);
            return null;
        }
        ep.setVideoType(message.getSourceName(), message.getVideoType());
        this.relay.getConference().sendMessageFromRelay(message, false, this.relay.getMeshId());
        return null;
    }

    @Override
    public void unhandledMessage(@NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.getLogger().warn("Received a message with an unexpected type: " + message.getType());
    }

    @Override
    protected void sendMessage(@Nullable Object dst, @NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        super.sendMessage(dst, message);
        if (!(dst instanceof ColibriWebSocket)) {
            throw new IllegalArgumentException("unknown transport:" + dst);
        }
        this.sendMessage((ColibriWebSocket)dst, message);
    }

    private final void sendMessage(ColibriWebSocket dst, BridgeChannelMessage message) {
        RemoteEndpoint remoteEndpoint = dst.getRemote();
        if (remoteEndpoint != null) {
            remoteEndpoint.sendString(message.toJson(), new WriteCallback.Adaptor());
        }
        this.statisticsSupplier.get().colibriWebSocketMessagesSent.inc();
    }

    @Override
    public void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.webSocket == null) {
            this.getLogger().debug("No available transport channel, can't send a message");
            this.numOutgoingMessagesDropped.incrementAndGet();
        } else {
            this.sentMessagesCounts.computeIfAbsent(msg.getClass().getSimpleName(), RelayMessageTransport::sendMessage$lambda-7).incrementAndGet();
            this.sendMessage((Object)this.webSocket, msg);
        }
    }

    @Override
    public boolean isConnected() {
        return this.webSocket != null;
    }

    public final boolean isActive() {
        return this.outgoingWebsocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketConnected(@NotNull ColibriWebSocket ws) {
        Intrinsics.checkNotNullParameter(ws, "ws");
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (!Intrinsics.areEqual(ws, this.webSocket)) {
                this.getLogger().info("Replacing an existing websocket.");
                Object object2 = this.webSocket;
                if (object2 != null && (object2 = ((WebSocketAdapter)object2).getSession()) != null) {
                    object2.close(1000, "replaced");
                }
                this.webSocket = ws;
                this.sendMessage(ws, (BridgeChannelMessage)this.createServerHello());
            } else {
                this.getLogger().warn("Websocket already connected.");
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.notifyTransportChannelConnected();
        }
        catch (Exception e) {
            this.getLogger().warn("Caught an exception in notifyTransportConnected", e);
        }
    }

    private final ServerHelloMessage createServerHello() {
        return VersionConfig.config.announceVersion() ? new ServerHelloMessage(this.relay.getConference().getVideobridge().getVersion().toString()) : new ServerHelloMessage(null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketClosed(@NotNull ColibriWebSocket ws, int statusCode, @NotNull String reason2) {
        block4: {
            Intrinsics.checkNotNullParameter(ws, "ws");
            Intrinsics.checkNotNullParameter(reason2, "reason");
            Object object = this.webSocketSyncRoot;
            synchronized (object) {
                boolean $i$a$-synchronized-RelayMessageTransport$webSocketClosed$22 = false;
                if (Intrinsics.areEqual(ws, this.webSocket)) {
                    this.webSocket = null;
                    this.getLogger().debug(() -> RelayMessageTransport.webSocketClosed$lambda-10$lambda-9(statusCode, reason2));
                }
                Unit $i$a$-synchronized-RelayMessageTransport$webSocketClosed$22 = Unit.INSTANCE;
            }
            WebSocketClient webSocketClient = this.outgoingWebsocket;
            if (webSocketClient == null) break block4;
            WebSocketClient it = webSocketClient;
            boolean bl = false;
            it.stop();
            this.outgoingWebsocket = null;
            this.doConnect();
        }
    }

    @Override
    public void webSocketError(@NotNull ColibriWebSocket ws, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(ws, "ws");
        Intrinsics.checkNotNullParameter(cause, "cause");
        this.getLogger().error("Colibri websocket error: " + cause.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean $i$a$-synchronized-RelayMessageTransport$close$22 = false;
            if (this.webSocket != null) {
                Object object2 = this.webSocket;
                if (object2 != null && (object2 = ((WebSocketAdapter)object2).getSession()) != null) {
                    object2.close(1001, "relay closed");
                }
                this.webSocket = null;
                this.getLogger().debug(RelayMessageTransport::close$lambda-13$lambda-12);
            }
            Unit $i$a$-synchronized-RelayMessageTransport$close$22 = Unit.INSTANCE;
        }
        WebSocketClient webSocketClient = this.outgoingWebsocket;
        if (webSocketClient != null) {
            WebSocketClient it = webSocketClient;
            boolean bl = false;
            TaskPools.IO_POOL.submit(() -> RelayMessageTransport.close$lambda-15$lambda-14(it, this));
        }
        this.outgoingWebsocket = null;
    }

    @Override
    public void webSocketTextReceived(@NotNull ColibriWebSocket ws, @NotNull String message) {
        Intrinsics.checkNotNullParameter(ws, "ws");
        Intrinsics.checkNotNullParameter(message, "message");
        if (!Intrinsics.areEqual(ws, this.webSocket)) {
            this.getLogger().warn("Received text from an unknown web socket.");
            return;
        }
        this.statisticsSupplier.get().colibriWebSocketMessagesReceived.inc();
        this.onMessage(ws, message);
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject debugState = super.getDebugState();
        ((Map)debugState).put("numOutgoingMessagesDropped", this.numOutgoingMessagesDropped.get());
        JSONObject sentCounts = new JSONObject();
        sentCounts.putAll(this.sentMessagesCounts);
        ((Map)debugState).put("sent_counts", sentCounts);
        return debugState;
    }

    @Override
    @Nullable
    public BridgeChannelMessage endpointMessage(@NotNull EndpointMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn("Unable to send EndpointMessage, conference is expired");
            return null;
        }
        if (message.isBroadcast()) {
            conference.sendMessageFromRelay(message, true, this.relay.getMeshId());
        } else {
            String to = message.getTo();
            Endpoint targetEndpoint = conference.getLocalEndpoint(to);
            if (targetEndpoint == null) {
                this.getLogger().warn("Unable to find endpoint to send EndpointMessage to: " + to);
                return null;
            }
            conference.sendMessage(message, CollectionsKt.listOf(targetEndpoint), false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BridgeChannelMessage endpointStats(@NotNull EndpointStats message) {
        void $this$forEach$iv;
        EncodingsManager.EncodingsUpdateListener it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(message, "message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn("Unable to send EndpointStats, conference is null or expired");
            return null;
        }
        if (message.getFrom() == null) {
            this.getLogger().warn("Unable to send EndpointStats, missing from");
            return null;
        }
        String string = message.getFrom();
        Intrinsics.checkNotNull(string);
        AbstractEndpoint from = conference.getEndpoint(string);
        if (from == null) {
            this.getLogger().warn("Unable to send EndpointStats, unknown endpoint " + message.getFrom());
            return null;
        }
        List<Endpoint> list = conference.getLocalEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "conference.localEndpoints");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Endpoint)element$iv$iv;
            boolean bl = false;
            if (!((Endpoint)it).wantsStatsFrom(from)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Endpoint it2 = (Endpoint)element$iv;
            boolean bl = false;
            it2.sendMessage(message);
        }
        List<Relay> list2 = conference.getRelays();
        Intrinsics.checkNotNullExpressionValue(list2, "conference.relays");
        $this$filter$iv = list2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (Relay)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual(((Relay)it).getMeshId(), this.relay.getMeshId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Relay it3 = (Relay)element$iv;
            boolean bl3 = false;
            it3.sendMessage(message);
        }
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage endpointConnectionStatus(@NotNull EndpointConnectionStatusMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn("Unable to send EndpointConnectionStatusMessage, conference is expired");
            return null;
        }
        conference.sendMessageFromRelay(message, true, this.relay.getMeshId());
        return null;
    }

    private static final String serverHello$lambda-3(ServerHelloMessage $message, RelayMessageTransport this$0) {
        Intrinsics.checkNotNullParameter($message, "$message");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Received ServerHelloMessage with version " + $message.getVersion() + ", but this server is version " + this$0.relay.getConference().getVideobridge().getVersion();
    }

    private static final String serverHello$lambda-4(ServerHelloMessage $message) {
        Intrinsics.checkNotNullParameter($message, "$message");
        return "Received ServerHelloMessage, version " + $message.getVersion();
    }

    private static final AtomicLong sendMessage$lambda-7(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new AtomicLong();
    }

    private static final String webSocketClosed$lambda-10$lambda-9(int $statusCode, String $reason) {
        Intrinsics.checkNotNullParameter($reason, "$reason");
        return "Web socket closed, statusCode " + $statusCode + " ( " + $reason + ").";
    }

    private static final String close$lambda-13$lambda-12() {
        return "Relay expired, closed colibri web-socket.";
    }

    private static final void close$lambda-15$lambda-14(WebSocketClient $it, RelayMessageTransport this$0) {
        Intrinsics.checkNotNullParameter($it, "$it");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            $it.stop();
        }
        catch (Exception e) {
            this$0.getLogger().warn("Error while stopping outgoing web socket", e);
        }
    }
}

