/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.load_management.PacketRateMeasurement;
import org.jitsi.videobridge.relay.Relay;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/load_management/PacketRateLoadSampler;", "Ljava/lang/Runnable;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "newMeasurementHandler", "Lkotlin/Function1;", "Lorg/jitsi/videobridge/load_management/PacketRateMeasurement;", "", "(Lorg/jitsi/videobridge/Videobridge;Lkotlin/jvm/functions/Function1;)V", "run", "jitsi-videobridge"})
public final class PacketRateLoadSampler
implements Runnable {
    @NotNull
    private final Videobridge videobridge;
    @NotNull
    private final Function1<PacketRateMeasurement, Unit> newMeasurementHandler;

    public PacketRateLoadSampler(@NotNull Videobridge videobridge, @NotNull Function1<? super PacketRateMeasurement, Unit> newMeasurementHandler) {
        Intrinsics.checkNotNullParameter(videobridge, "videobridge");
        Intrinsics.checkNotNullParameter(newMeasurementHandler, "newMeasurementHandler");
        this.videobridge = videobridge;
        this.newMeasurementHandler = newMeasurementHandler;
    }

    @Override
    public void run() {
        long totalPacketRate = 0L;
        Collection<Conference> collection = this.videobridge.getConferences();
        Intrinsics.checkNotNullExpressionValue(collection, "videobridge.conferences");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Conference conf = (Conference)element$iv;
            boolean bl = false;
            List<Endpoint> list = conf.getLocalEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "conf.localEndpoints");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Endpoint ep = (Endpoint)element$iv2;
                boolean bl2 = false;
                TransceiverStats $this$run_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0 = ep.getTransceiver().getTransceiverStats();
                boolean bl3 = false;
                totalPacketRate += $this$run_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0.getRtpReceiverStats().getPacketStreamStats().getPacketRate();
                totalPacketRate += $this$run_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0.getOutgoingPacketStreamStats().getPacketRate();
            }
            List<Relay> list2 = conf.getRelays();
            Intrinsics.checkNotNullExpressionValue(list2, "conf.relays");
            $this$forEach$iv2 = list2;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Relay relay = (Relay)element$iv2;
                boolean bl4 = false;
                totalPacketRate += relay.getIncomingPacketRate();
                totalPacketRate += relay.getOutgoingPacketRate();
            }
        }
        this.newMeasurementHandler.invoke(new PacketRateMeasurement(totalPacketRate));
    }
}

